/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.regex.Pattern;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestServerName {
    @Test
    public void testGetHostNameMinusDomain() {
        Assert.assertEquals((Object)"2607:f0d0:1002:51::4", (Object)ServerName.getHostNameMinusDomain((String)"2607:f0d0:1002:51::4"));
        Assert.assertEquals((Object)"2607:f0d0:1002:0051:0000:0000:0000:0004", (Object)ServerName.getHostNameMinusDomain((String)"2607:f0d0:1002:0051:0000:0000:0000:0004"));
        Assert.assertEquals((Object)"1.1.1.1", (Object)ServerName.getHostNameMinusDomain((String)"1.1.1.1"));
        Assert.assertEquals((Object)"x", (Object)ServerName.getHostNameMinusDomain((String)"x"));
        Assert.assertEquals((Object)"x", (Object)ServerName.getHostNameMinusDomain((String)"x.y.z"));
        Assert.assertEquals((Object)"asf000", (Object)ServerName.getHostNameMinusDomain((String)"asf000.sp2.ygridcore.net"));
        ServerName sn = ServerName.valueOf((String)"asf000.sp2.ygridcore.net", (int)1, (long)1L);
        Assert.assertEquals((Object)"asf000.sp2.ygridcore.net,1,1", (Object)sn.toString());
    }

    @Test
    public void testShortString() {
        ServerName sn = ServerName.valueOf((String)"asf000.sp2.ygridcore.net", (int)1, (long)1L);
        Assert.assertEquals((Object)"asf000:1", (Object)sn.toShortString());
        sn = ServerName.valueOf((String)"2607:f0d0:1002:0051:0000:0000:0000:0004", (int)1, (long)1L);
        Assert.assertEquals((Object)"2607:f0d0:1002:0051:0000:0000:0000:0004:1", (Object)sn.toShortString());
        sn = ServerName.valueOf((String)"1.1.1.1", (int)1, (long)1L);
        Assert.assertEquals((Object)"1.1.1.1:1", (Object)sn.toShortString());
    }

    @Test
    public void testRegexPatterns() {
        Assert.assertTrue((boolean)Pattern.matches("[\\d]+", "123"));
        Assert.assertFalse((boolean)Pattern.matches("[\\d]+", ""));
        Assert.assertTrue((boolean)ServerName.SERVERNAME_PATTERN.matcher("www1.example.org,1234,567").matches());
        ServerName.parseServerName((String)"a.b.c,58102,1319771740322");
        ServerName.parseServerName((String)"192.168.1.199,58102,1319771740322");
        ServerName.parseServerName((String)"a.b.c:58102");
        ServerName.parseServerName((String)"192.168.1.199:58102");
    }

    @Test
    public void testParseOfBytes() {
        String snStr = "www.example.org,1234,5678";
        ServerName sn = ServerName.valueOf((String)"www.example.org,1234,5678");
        byte[] versionedBytes = sn.getVersionedBytes();
        Assert.assertEquals((Object)sn.toString(), (Object)ServerName.parseVersionedServerName((byte[])versionedBytes).toString());
        String hostnamePortStr = sn.getHostAndPort();
        byte[] bytes = Bytes.toBytes((String)hostnamePortStr);
        String expecting = hostnamePortStr.replace(":", ",") + "," + -1;
        Assert.assertEquals((Object)expecting, (Object)ServerName.parseVersionedServerName((byte[])bytes).toString());
    }

    @Test
    public void testServerName() {
        ServerName sn = ServerName.valueOf((String)"www.example.org", (int)1234, (long)5678L);
        ServerName sn2 = ServerName.valueOf((String)"www.example.org", (int)1234, (long)5678L);
        ServerName sn3 = ServerName.valueOf((String)"www.example.org", (int)1234, (long)56789L);
        Assert.assertTrue((boolean)sn.equals((Object)sn2));
        Assert.assertFalse((boolean)sn.equals((Object)sn3));
        Assert.assertEquals((long)sn.hashCode(), (long)sn2.hashCode());
        Assert.assertNotSame((Object)sn.hashCode(), (Object)sn3.hashCode());
        Assert.assertEquals((Object)sn.toString(), (Object)ServerName.getServerName((String)"www.example.org", (int)1234, (long)5678L));
        Assert.assertEquals((Object)sn.toString(), (Object)ServerName.getServerName((String)"www.example.org:1234", (long)5678L));
        Assert.assertEquals((Object)sn.toString(), (Object)"www.example.org,1234,5678");
    }

    @Test
    public void getServerStartcodeFromServerName() {
        ServerName sn = ServerName.valueOf((String)"www.example.org", (int)1234, (long)5678L);
        Assert.assertEquals((long)5678L, (long)ServerName.getServerStartcodeFromServerName((String)sn.toString()));
        Assert.assertNotSame((Object)5677, (Object)ServerName.getServerStartcodeFromServerName((String)sn.toString()));
    }
}

