/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestTimestampsFilter {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testTimestampsFilter() throws Exception {
        Cell[] kvs;
        int colIdx;
        int rowIdx;
        byte[] TABLE = Bytes.toBytes((String)"testTimestampsFilter");
        byte[] FAMILY = Bytes.toBytes((String)"event_log");
        byte[][] FAMILIES = new byte[][]{FAMILY};
        HTable ht = TEST_UTIL.createTable(TableName.valueOf((byte[])TABLE), (byte[][])FAMILIES, Integer.MAX_VALUE);
        for (rowIdx = 0; rowIdx < 5; ++rowIdx) {
            for (colIdx = 0; colIdx < 5; ++colIdx) {
                this.putNVersions((Table)ht, FAMILY, rowIdx, colIdx, 201L, 300L);
                this.putNVersions((Table)ht, FAMILY, rowIdx, colIdx, 1L, 100L);
            }
        }
        this.verifyInsertedValues((Table)ht, FAMILY);
        TEST_UTIL.flush();
        this.verifyInsertedValues((Table)ht, FAMILY);
        for (rowIdx = 0; rowIdx < 5; ++rowIdx) {
            for (colIdx = 0; colIdx < 5; ++colIdx) {
                this.putNVersions((Table)ht, FAMILY, rowIdx, colIdx, 301L, 400L);
                this.putNVersions((Table)ht, FAMILY, rowIdx, colIdx, 101L, 200L);
            }
        }
        for (rowIdx = 0; rowIdx < 5; ++rowIdx) {
            for (colIdx = 0; colIdx < 5; ++colIdx) {
                kvs = this.getNVersions((Table)ht, FAMILY, rowIdx, colIdx, Arrays.asList(505L, 5L, 105L, 305L, 205L));
                Assert.assertEquals((long)4L, (long)kvs.length);
                this.checkOneCell(kvs[0], FAMILY, rowIdx, colIdx, 305L);
                this.checkOneCell(kvs[1], FAMILY, rowIdx, colIdx, 205L);
                this.checkOneCell(kvs[2], FAMILY, rowIdx, colIdx, 105L);
                this.checkOneCell(kvs[3], FAMILY, rowIdx, colIdx, 5L);
            }
        }
        kvs = this.getNVersions((Table)ht, FAMILY, 2, 2, new ArrayList<Long>());
        Assert.assertEquals((long)0L, (long)(kvs == null ? 0L : (long)kvs.length));
        Result[] results = this.scanNVersions((Table)ht, FAMILY, 0, 4, Arrays.asList(6L, 106L, 306L));
        Assert.assertEquals((String)"# of rows returned from scan", (long)5L, (long)results.length);
        for (int rowIdx2 = 0; rowIdx2 < 5; ++rowIdx2) {
            kvs = results[rowIdx2].rawCells();
            Assert.assertEquals((String)("Number of KeyValues in result for row:" + rowIdx2), (long)15L, (long)kvs.length);
            for (int colIdx2 = 0; colIdx2 < 5; ++colIdx2) {
                int offset = colIdx2 * 3;
                this.checkOneCell(kvs[offset + 0], FAMILY, rowIdx2, colIdx2, 306L);
                this.checkOneCell(kvs[offset + 1], FAMILY, rowIdx2, colIdx2, 106L);
                this.checkOneCell(kvs[offset + 2], FAMILY, rowIdx2, colIdx2, 6L);
            }
        }
        ht.close();
    }

    @Test
    public void testMultiColumns() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testTimestampsFilterMultiColumns");
        byte[] FAMILY = Bytes.toBytes((String)"event_log");
        byte[][] FAMILIES = new byte[][]{FAMILY};
        HTable ht = TEST_UTIL.createTable(TableName.valueOf((byte[])TABLE), (byte[][])FAMILIES, Integer.MAX_VALUE);
        Put p = new Put(Bytes.toBytes((String)"row"));
        p.add(FAMILY, Bytes.toBytes((String)"column0"), 3L, Bytes.toBytes((String)"value0-3"));
        p.add(FAMILY, Bytes.toBytes((String)"column1"), 3L, Bytes.toBytes((String)"value1-3"));
        p.add(FAMILY, Bytes.toBytes((String)"column2"), 1L, Bytes.toBytes((String)"value2-1"));
        p.add(FAMILY, Bytes.toBytes((String)"column2"), 2L, Bytes.toBytes((String)"value2-2"));
        p.add(FAMILY, Bytes.toBytes((String)"column2"), 3L, Bytes.toBytes((String)"value2-3"));
        p.add(FAMILY, Bytes.toBytes((String)"column3"), 2L, Bytes.toBytes((String)"value3-2"));
        p.add(FAMILY, Bytes.toBytes((String)"column4"), 1L, Bytes.toBytes((String)"value4-1"));
        p.add(FAMILY, Bytes.toBytes((String)"column4"), 2L, Bytes.toBytes((String)"value4-2"));
        p.add(FAMILY, Bytes.toBytes((String)"column4"), 3L, Bytes.toBytes((String)"value4-3"));
        ht.put(p);
        ArrayList<Long> timestamps = new ArrayList<Long>();
        timestamps.add(new Long(3L));
        TimestampsFilter filter = new TimestampsFilter(timestamps);
        Get g = new Get(Bytes.toBytes((String)"row"));
        g.setFilter((Filter)filter);
        g.setMaxVersions();
        g.addColumn(FAMILY, Bytes.toBytes((String)"column2"));
        g.addColumn(FAMILY, Bytes.toBytes((String)"column4"));
        Result result = ht.get(g);
        for (Cell kv : result.listCells()) {
            System.out.println("found row " + Bytes.toString((byte[])CellUtil.cloneRow((Cell)kv)) + ", column " + Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)) + ", value " + Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)));
        }
        Assert.assertEquals((long)result.listCells().size(), (long)2L);
        Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)((Cell)result.listCells().get(0)), (byte[])Bytes.toBytes((String)"value2-3")));
        Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)((Cell)result.listCells().get(1)), (byte[])Bytes.toBytes((String)"value4-3")));
        ht.close();
    }

    @Test
    public void testWithVersionDeletes() throws Exception {
        this.testWithVersionDeletes(false);
        this.testWithVersionDeletes(true);
    }

    private void testWithVersionDeletes(boolean flushTables) throws IOException {
        byte[] TABLE = Bytes.toBytes((String)("testWithVersionDeletes_" + (flushTables ? "flush" : "noflush")));
        byte[] FAMILY = Bytes.toBytes((String)"event_log");
        byte[][] FAMILIES = new byte[][]{FAMILY};
        HTable ht = TEST_UTIL.createTable(TableName.valueOf((byte[])TABLE), (byte[][])FAMILIES, Integer.MAX_VALUE);
        this.putNVersions((Table)ht, FAMILY, 0, 0, 1L, 5L);
        this.deleteOneVersion((Table)ht, FAMILY, 0, 0, 4L);
        if (flushTables) {
            TEST_UTIL.flush();
        }
        Cell[] kvs = this.getNVersions((Table)ht, FAMILY, 0, 0, Arrays.asList(2L, 3L, 4L, 5L));
        Assert.assertEquals((long)3L, (long)kvs.length);
        this.checkOneCell(kvs[0], FAMILY, 0, 0, 5L);
        this.checkOneCell(kvs[1], FAMILY, 0, 0, 3L);
        this.checkOneCell(kvs[2], FAMILY, 0, 0, 2L);
        ht.close();
    }

    private void verifyInsertedValues(Table ht, byte[] cf) throws IOException {
        for (int rowIdx = 0; rowIdx < 5; ++rowIdx) {
            for (int colIdx = 0; colIdx < 5; ++colIdx) {
                Cell[] kvs = this.getNVersions(ht, cf, rowIdx, colIdx, Arrays.asList(5L, 300L, 6L, 80L));
                Assert.assertEquals((long)4L, (long)kvs.length);
                this.checkOneCell(kvs[0], cf, rowIdx, colIdx, 300L);
                this.checkOneCell(kvs[1], cf, rowIdx, colIdx, 80L);
                this.checkOneCell(kvs[2], cf, rowIdx, colIdx, 6L);
                this.checkOneCell(kvs[3], cf, rowIdx, colIdx, 5L);
                kvs = this.getNVersions(ht, cf, rowIdx, colIdx, Arrays.asList(101L, 102L));
                Assert.assertEquals((long)0L, (long)(kvs == null ? 0L : (long)kvs.length));
                kvs = this.getNVersions(ht, cf, rowIdx, colIdx, Arrays.asList(1L, 300L, 105L, 70L, 115L));
                Assert.assertEquals((long)3L, (long)kvs.length);
                this.checkOneCell(kvs[0], cf, rowIdx, colIdx, 300L);
                this.checkOneCell(kvs[1], cf, rowIdx, colIdx, 70L);
                this.checkOneCell(kvs[2], cf, rowIdx, colIdx, 1L);
            }
        }
    }

    private void checkOneCell(Cell kv, byte[] cf, int rowIdx, int colIdx, long ts) {
        String ctx = "rowIdx=" + rowIdx + "; colIdx=" + colIdx + "; ts=" + ts;
        Assert.assertEquals((String)("Row mismatch which checking: " + ctx), (Object)("row:" + rowIdx), (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)kv)));
        Assert.assertEquals((String)("ColumnFamily mismatch while checking: " + ctx), (Object)Bytes.toString((byte[])cf), (Object)Bytes.toString((byte[])CellUtil.cloneFamily((Cell)kv)));
        Assert.assertEquals((String)("Column qualifier mismatch while checking: " + ctx), (Object)("column:" + colIdx), (Object)Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)kv)));
        Assert.assertEquals((String)("Timestamp mismatch while checking: " + ctx), (long)ts, (long)kv.getTimestamp());
        Assert.assertEquals((String)("Value mismatch while checking: " + ctx), (Object)("value-version-" + ts), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)kv)));
    }

    private Cell[] getNVersions(Table ht, byte[] cf, int rowIdx, int colIdx, List<Long> versions) throws IOException {
        byte[] row = Bytes.toBytes((String)("row:" + rowIdx));
        byte[] column = Bytes.toBytes((String)("column:" + colIdx));
        TimestampsFilter filter = new TimestampsFilter(versions);
        Get get = new Get(row);
        get.addColumn(cf, column);
        get.setFilter((Filter)filter);
        get.setMaxVersions();
        Result result = ht.get(get);
        return result.rawCells();
    }

    private Result[] scanNVersions(Table ht, byte[] cf, int startRowIdx, int endRowIdx, List<Long> versions) throws IOException {
        byte[] startRow = Bytes.toBytes((String)("row:" + startRowIdx));
        byte[] endRow = Bytes.toBytes((String)("row:" + endRowIdx + 1));
        TimestampsFilter filter = new TimestampsFilter(versions);
        Scan scan = new Scan(startRow, endRow);
        scan.setFilter((Filter)filter);
        scan.setMaxVersions();
        ResultScanner scanner = ht.getScanner(scan);
        return scanner.next(endRowIdx - startRowIdx + 1);
    }

    private void putNVersions(Table ht, byte[] cf, int rowIdx, int colIdx, long versionStart, long versionEnd) throws IOException {
        byte[] row = Bytes.toBytes((String)("row:" + rowIdx));
        byte[] column = Bytes.toBytes((String)("column:" + colIdx));
        Put put = new Put(row);
        put.setDurability(Durability.SKIP_WAL);
        for (long idx = versionStart; idx <= versionEnd; ++idx) {
            put.add(cf, column, idx, Bytes.toBytes((String)("value-version-" + idx)));
        }
        ht.put(put);
    }

    private void deleteOneVersion(Table ht, byte[] cf, int rowIdx, int colIdx, long version) throws IOException {
        byte[] row = Bytes.toBytes((String)("row:" + rowIdx));
        byte[] column = Bytes.toBytes((String)("column:" + colIdx));
        Delete del = new Delete(row);
        del.deleteColumn(cf, column, version);
        ht.delete(del);
    }
}

