/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import java.util.Arrays;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableInputFormatBase;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableRecordReader;
import org.apache.hadoop.hbase.mapreduce.MapreduceTestingShim;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={LargeTests.class})
public class TestTableInputFormat {
    private static final Log LOG = LogFactory.getLog(TestTableInputFormat.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static MiniMRCluster mrCluster;
    static final byte[] FAMILY;
    private static final byte[][] columns;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
        mrCluster = UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniMapReduceCluster();
        UTIL.shutdownMiniCluster();
    }

    @Before
    public void before() throws IOException {
        LOG.info((Object)"before");
        UTIL.ensureSomeRegionServersAvailable(1);
        LOG.info((Object)"before done");
    }

    public static Table createTable(byte[] tableName) throws IOException {
        return TestTableInputFormat.createTable(tableName, new byte[][]{FAMILY});
    }

    public static Table createTable(byte[] tableName, byte[][] families) throws IOException {
        HTable table = UTIL.createTable(TableName.valueOf((byte[])tableName), families);
        Put p = new Put("aaa".getBytes());
        for (byte[] family : families) {
            p.add(family, null, "value aaa".getBytes());
        }
        table.put(p);
        p = new Put("bbb".getBytes());
        for (byte[] family : families) {
            p.add(family, null, "value bbb".getBytes());
        }
        table.put(p);
        return table;
    }

    static boolean checkResult(Result r, ImmutableBytesWritable key, byte[] expectedKey, byte[] expectedValue) {
        Assert.assertEquals((long)0L, (long)key.compareTo(expectedKey));
        NavigableMap vals = r.getFamilyMap(FAMILY);
        byte[] value = (byte[])vals.values().iterator().next();
        Assert.assertTrue((boolean)Arrays.equals(value, expectedValue));
        return true;
    }

    static void runTestMapred(Table table) throws IOException {
        TableRecordReader trr = new TableRecordReader();
        trr.setStartRow("aaa".getBytes());
        trr.setEndRow("zzz".getBytes());
        trr.setHTable(table);
        trr.setInputColumns(columns);
        trr.init();
        Result r = new Result();
        ImmutableBytesWritable key = new ImmutableBytesWritable();
        boolean more = trr.next(key, r);
        Assert.assertTrue((boolean)more);
        TestTableInputFormat.checkResult(r, key, "aaa".getBytes(), "value aaa".getBytes());
        more = trr.next(key, r);
        Assert.assertTrue((boolean)more);
        TestTableInputFormat.checkResult(r, key, "bbb".getBytes(), "value bbb".getBytes());
        more = trr.next(key, r);
        Assert.assertFalse((boolean)more);
    }

    static Table createIOEScannerTable(byte[] name, final int failCnt) throws IOException {
        Answer<ResultScanner> a = new Answer<ResultScanner>(){
            int cnt = 0;

            public ResultScanner answer(InvocationOnMock invocation) throws Throwable {
                if (this.cnt++ < failCnt) {
                    Scan scan = (Scan)Mockito.mock(Scan.class);
                    ((Scan)Mockito.doReturn((Object)"bogus".getBytes()).when((Object)scan)).getStartRow();
                    ResultScanner scanner = (ResultScanner)Mockito.mock(ResultScanner.class);
                    ((ResultScanner)Mockito.doThrow((Throwable)new IOException("Injected exception")).when((Object)scanner)).next();
                    return scanner;
                }
                return (ResultScanner)invocation.callRealMethod();
            }
        };
        Table htable = (Table)Mockito.spy((Object)TestTableInputFormat.createTable(name));
        ((Table)Mockito.doAnswer((Answer)a).when((Object)htable)).getScanner((Scan)Matchers.anyObject());
        return htable;
    }

    static Table createDNRIOEScannerTable(byte[] name, final int failCnt) throws IOException {
        Answer<ResultScanner> a = new Answer<ResultScanner>(){
            int cnt = 0;

            public ResultScanner answer(InvocationOnMock invocation) throws Throwable {
                if (this.cnt++ < failCnt) {
                    Scan scan = (Scan)Mockito.mock(Scan.class);
                    ((Scan)Mockito.doReturn((Object)"bogus".getBytes()).when((Object)scan)).getStartRow();
                    ResultScanner scanner = (ResultScanner)Mockito.mock(ResultScanner.class);
                    invocation.callRealMethod();
                    ((ResultScanner)Mockito.doThrow((Throwable)new UnknownScannerException("Injected simulated TimeoutException")).when((Object)scanner)).next();
                    return scanner;
                }
                return (ResultScanner)invocation.callRealMethod();
            }
        };
        Table htable = (Table)Mockito.spy((Object)TestTableInputFormat.createTable(name));
        ((Table)Mockito.doAnswer((Answer)a).when((Object)htable)).getScanner((Scan)Matchers.anyObject());
        return htable;
    }

    @Test
    public void testTableRecordReader() throws IOException {
        Table table = TestTableInputFormat.createTable("table1".getBytes());
        TestTableInputFormat.runTestMapred(table);
    }

    @Test
    public void testTableRecordReaderScannerFail() throws IOException {
        Table htable = TestTableInputFormat.createIOEScannerTable("table2".getBytes(), 1);
        TestTableInputFormat.runTestMapred(htable);
    }

    @Test(expected=IOException.class)
    public void testTableRecordReaderScannerFailTwice() throws IOException {
        Table htable = TestTableInputFormat.createIOEScannerTable("table3".getBytes(), 2);
        TestTableInputFormat.runTestMapred(htable);
    }

    @Test
    public void testTableRecordReaderScannerTimeout() throws IOException {
        Table htable = TestTableInputFormat.createDNRIOEScannerTable("table4".getBytes(), 1);
        TestTableInputFormat.runTestMapred(htable);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testTableRecordReaderScannerTimeoutTwice() throws IOException {
        Table htable = TestTableInputFormat.createDNRIOEScannerTable("table5".getBytes(), 2);
        TestTableInputFormat.runTestMapred(htable);
    }

    @Test
    public void testExtensionOfTableInputFormatBase() throws IOException {
        LOG.info((Object)"testing use of an InputFormat taht extends InputFormatBase");
        Table table = TestTableInputFormat.createTable(Bytes.toBytes((String)"exampleTable"), new byte[][]{Bytes.toBytes((String)"columnA"), Bytes.toBytes((String)"columnB")});
        this.testInputFormat(ExampleTIF.class);
    }

    @Test
    public void testDeprecatedExtensionOfTableInputFormatBase() throws IOException {
        LOG.info((Object)"testing use of an InputFormat taht extends InputFormatBase, as it was given in 0.98.");
        Table table = TestTableInputFormat.createTable(Bytes.toBytes((String)"exampleDeprecatedTable"), new byte[][]{Bytes.toBytes((String)"columnA"), Bytes.toBytes((String)"columnB")});
        this.testInputFormat(ExampleDeprecatedTIF.class);
    }

    @Test
    public void testJobConfigurableExtensionOfTableInputFormatBase() throws IOException {
        LOG.info((Object)"testing use of an InputFormat taht extends InputFormatBase, using JobConfigurable.");
        Table table = TestTableInputFormat.createTable(Bytes.toBytes((String)"exampleJobConfigurableTable"), new byte[][]{Bytes.toBytes((String)"columnA"), Bytes.toBytes((String)"columnB")});
        this.testInputFormat(ExampleJobConfigurableTIF.class);
    }

    void testInputFormat(Class<? extends InputFormat> clazz) throws IOException {
        JobConf job = MapreduceTestingShim.getJobConf(mrCluster);
        job.setInputFormat(clazz);
        job.setOutputFormat(NullOutputFormat.class);
        job.setMapperClass(ExampleVerifier.class);
        job.setNumReduceTasks(0);
        LOG.debug((Object)"submitting job.");
        RunningJob run = JobClient.runJob((JobConf)job);
        Assert.assertTrue((String)"job failed!", (boolean)run.isSuccessful());
        Assert.assertEquals((String)"Saw the wrong number of instances of the filtered-for row.", (long)2L, (long)run.getCounters().findCounter(TestTableInputFormat.class.getName() + ":row", "aaa").getCounter());
        Assert.assertEquals((String)"Saw any instances of the filtered out row.", (long)0L, (long)run.getCounters().findCounter(TestTableInputFormat.class.getName() + ":row", "bbb").getCounter());
        Assert.assertEquals((String)"Saw the wrong number of instances of columnA.", (long)1L, (long)run.getCounters().findCounter(TestTableInputFormat.class.getName() + ":family", "columnA").getCounter());
        Assert.assertEquals((String)"Saw the wrong number of instances of columnB.", (long)1L, (long)run.getCounters().findCounter(TestTableInputFormat.class.getName() + ":family", "columnB").getCounter());
        Assert.assertEquals((String)"Saw the wrong count of values for the filtered-for row.", (long)2L, (long)run.getCounters().findCounter(TestTableInputFormat.class.getName() + ":value", "value aaa").getCounter());
        Assert.assertEquals((String)"Saw the wrong count of values for the filtered-out row.", (long)0L, (long)run.getCounters().findCounter(TestTableInputFormat.class.getName() + ":value", "value bbb").getCounter());
    }

    static {
        FAMILY = Bytes.toBytes((String)"family");
        columns = new byte[][]{FAMILY};
    }

    public static class ExampleTIF
    extends TableInputFormatBase {
        protected void initialize(JobConf job) throws IOException {
            this.initialize(job, "exampleTable");
        }

        protected void initialize(JobConf job, String table) throws IOException {
            Connection connection = ConnectionFactory.createConnection((Configuration)HBaseConfiguration.create((Configuration)job));
            TableName tableName = TableName.valueOf((String)table);
            this.initializeTable(connection, tableName);
            byte[][] inputColumns = new byte[][]{Bytes.toBytes((String)"columnA"), Bytes.toBytes((String)"columnB")};
            this.setInputColumns(inputColumns);
            RowFilter exampleFilter = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator("aa.*"));
            this.setRowFilter((Filter)exampleFilter);
        }
    }

    public static class ExampleJobConfigurableTIF
    extends ExampleTIF
    implements JobConfigurable {
        public void configure(JobConf job) {
            try {
                this.initialize(job);
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed to initialize.", exception);
            }
        }

        @Override
        protected void initialize(JobConf job) throws IOException {
            this.initialize(job, "exampleJobConfigurableTable");
        }
    }

    public static class ExampleDeprecatedTIF
    extends TableInputFormatBase
    implements JobConfigurable {
        public void configure(JobConf job) {
            try {
                HTable exampleTable = new HTable(HBaseConfiguration.create((Configuration)job), Bytes.toBytes((String)"exampleDeprecatedTable"));
                this.setHTable(exampleTable);
                byte[][] inputColumns = new byte[][]{Bytes.toBytes((String)"columnA"), Bytes.toBytes((String)"columnB")};
                this.setInputColumns(inputColumns);
                RowFilter exampleFilter = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator("aa.*"));
                this.setRowFilter((Filter)exampleFilter);
            }
            catch (IOException exception) {
                throw new RuntimeException("Failed to configure for job.", exception);
            }
        }
    }

    public static class ExampleVerifier
    implements TableMap<NullWritable, NullWritable> {
        public void configure(JobConf conf) {
        }

        public void map(ImmutableBytesWritable key, Result value, OutputCollector<NullWritable, NullWritable> output, Reporter reporter) throws IOException {
            for (Cell cell : value.listCells()) {
                reporter.getCounter(TestTableInputFormat.class.getName() + ":row", Bytes.toString((byte[])cell.getRowArray(), (int)cell.getRowOffset(), (int)cell.getRowLength())).increment(1L);
                reporter.getCounter(TestTableInputFormat.class.getName() + ":family", Bytes.toString((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength())).increment(1L);
                reporter.getCounter(TestTableInputFormat.class.getName() + ":value", Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength())).increment(1L);
            }
        }

        public void close() {
        }
    }
}

