/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MiniMRCluster;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;

public abstract class MapreduceTestingShim {
    private static MapreduceTestingShim instance;
    private static Class[] emptyParam;

    public abstract JobContext newJobContext(Configuration var1) throws IOException;

    public abstract Job newJob(Configuration var1) throws IOException;

    public abstract JobConf obtainJobConf(MiniMRCluster var1);

    public abstract String obtainMROutputDirProp();

    public static JobContext createJobContext(Configuration jobConf) throws IOException {
        return instance.newJobContext(jobConf);
    }

    public static JobConf getJobConf(MiniMRCluster cluster) {
        return instance.obtainJobConf(cluster);
    }

    public static Job createJob(Configuration conf) throws IOException {
        return instance.newJob(conf);
    }

    public static String getMROutputDirProp() {
        return instance.obtainMROutputDirProp();
    }

    static {
        emptyParam = new Class[0];
        try {
            Class<?> c = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
            instance = new MapreduceV2Shim();
        }
        catch (Exception e) {
            instance = new MapreduceV1Shim();
        }
    }

    private static class MapreduceV2Shim
    extends MapreduceTestingShim {
        private MapreduceV2Shim() {
        }

        @Override
        public JobContext newJobContext(Configuration jobConf) {
            return this.newJob(jobConf);
        }

        @Override
        public Job newJob(Configuration jobConf) {
            try {
                Method m = Job.class.getMethod("getInstance", Configuration.class);
                return (Job)m.invoke(null, jobConf);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalStateException("Failed to return from Job.getInstance(jobConf)");
            }
        }

        @Override
        public JobConf obtainJobConf(MiniMRCluster cluster) {
            try {
                Method meth = MiniMRCluster.class.getMethod("getJobTrackerConf", emptyParam);
                JobConf conf = (JobConf)meth.invoke((Object)cluster, new Object[0]);
                meth = MiniMRCluster.class.getMethod("createJobConf", JobConf.class);
                return (JobConf)meth.invoke((Object)cluster, conf);
            }
            catch (NoSuchMethodException nsme) {
                return null;
            }
            catch (InvocationTargetException ite) {
                return null;
            }
            catch (IllegalAccessException iae) {
                return null;
            }
        }

        @Override
        public String obtainMROutputDirProp() {
            return "mapreduce.output.fileoutputformat.outputdir";
        }
    }

    private static class MapreduceV1Shim
    extends MapreduceTestingShim {
        private MapreduceV1Shim() {
        }

        @Override
        public JobContext newJobContext(Configuration jobConf) throws IOException {
            JobID jobId = new JobID();
            try {
                Constructor c = JobContext.class.getConstructor(Configuration.class, JobID.class);
                return (JobContext)c.newInstance(jobConf, jobId);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate new JobContext(jobConf, new JobID())", e);
            }
        }

        @Override
        public Job newJob(Configuration conf) throws IOException {
            try {
                Constructor c = Job.class.getConstructor(Configuration.class);
                return (Job)c.newInstance(conf);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate new Job(conf)", e);
            }
        }

        @Override
        public JobConf obtainJobConf(MiniMRCluster cluster) {
            if (cluster == null) {
                return null;
            }
            try {
                MiniMRCluster.JobTrackerRunner runner = cluster.getJobTrackerRunner();
                Method meth = runner.getClass().getDeclaredMethod("getJobTracker", emptyParam);
                Object tracker = meth.invoke((Object)runner, new Object[0]);
                Method m = tracker.getClass().getDeclaredMethod("getConf", emptyParam);
                return (JobConf)m.invoke(tracker, new Object[0]);
            }
            catch (NoSuchMethodException nsme) {
                return null;
            }
            catch (InvocationTargetException ite) {
                return null;
            }
            catch (IllegalAccessException iae) {
                return null;
            }
        }

        @Override
        public String obtainMROutputDirProp() {
            return "mapred.output.dir";
        }
    }
}

