/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hadoop.hbase.coordination.ZkCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.ZkOpenRegionCoordination;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.handler.OpenedRegionHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKTableStateManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestOpenedRegionHandler {
    private static final Log LOG = LogFactory.getLog(TestOpenedRegionHandler.class);
    private HBaseTestingUtility TEST_UTIL;
    private final int NUM_MASTERS = 1;
    private final int NUM_RS = 1;
    private Configuration conf;
    private Configuration resetConf;
    private ZooKeeperWatcher zkw;

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create();
        this.conf.setBoolean("hbase.assignment.usezk", true);
        this.TEST_UTIL = HBaseTestingUtility.createLocalHTU(this.conf);
    }

    @After
    public void tearDown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
        this.TEST_UTIL = new HBaseTestingUtility(this.resetConf);
    }

    @Test
    public void testOpenedRegionHandlerOnMasterRestart() throws Exception {
        this.log("Starting cluster");
        this.conf = HBaseConfiguration.create();
        this.conf.setBoolean("hbase.assignment.usezk", true);
        this.resetConf = this.conf;
        this.TEST_UTIL = new HBaseTestingUtility(this.conf);
        this.TEST_UTIL.startMiniCluster(1, 1);
        String tableName = "testOpenedRegionHandlerOnMasterRestart";
        MiniHBaseCluster cluster = this.createRegions(tableName);
        this.abortMaster(cluster);
        HRegionServer regionServer = cluster.getRegionServer(0);
        HRegion region = this.getRegionBeingServed(cluster, regionServer);
        this.zkw = HBaseTestingUtility.createAndForceNodeToOpenedState(this.TEST_UTIL, region, regionServer.getServerName());
        this.log("Starting up a new master");
        cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)this.zkw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldNotCompeleteOpenedRegionSuccessfullyIfVersionMismatches() throws Exception {
        HRegion region = null;
        try {
            int testIndex = 0;
            this.TEST_UTIL.startMiniZKCluster();
            MockServer server = new MockServer(this.TEST_UTIL);
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"testShouldNotCompeleteOpenedRegionSuccessfullyIfVersionMismatches"));
            HRegionInfo hri = new HRegionInfo(htd.getTableName(), Bytes.toBytes((int)testIndex), Bytes.toBytes((int)(testIndex + 1)));
            region = HRegion.createHRegion((HRegionInfo)hri, (Path)this.TEST_UTIL.getDataTestDir(), (Configuration)this.TEST_UTIL.getConfiguration(), (HTableDescriptor)htd);
            Assert.assertNotNull((Object)region);
            AssignmentManager am = (AssignmentManager)Mockito.mock(AssignmentManager.class);
            RegionStates rsm = (RegionStates)Mockito.mock(RegionStates.class);
            ((AssignmentManager)Mockito.doReturn((Object)rsm).when((Object)am)).getRegionStates();
            Mockito.when((Object)rsm.isRegionInTransition(hri)).thenReturn((Object)false);
            Mockito.when((Object)rsm.getRegionState(hri)).thenReturn((Object)new RegionState(region.getRegionInfo(), RegionState.State.OPEN, System.currentTimeMillis(), server.getServerName()));
            this.zkw = HBaseTestingUtility.createAndForceNodeToOpenedState(this.TEST_UTIL, region, server.getServerName());
            Mockito.when((Object)am.getTableStateManager()).thenReturn((Object)new ZKTableStateManager(this.zkw));
            Stat stat = new Stat();
            String nodeName = ZKAssign.getNodeName((ZooKeeperWatcher)this.zkw, (String)region.getRegionInfo().getEncodedName());
            ZKUtil.getDataAndWatch((ZooKeeperWatcher)this.zkw, (String)nodeName, (Stat)stat);
            ZkCoordinatedStateManager csm = new ZkCoordinatedStateManager();
            csm.initialize((Server)server);
            csm.start();
            OpenRegionCoordination orc = csm.getOpenRegionCoordination();
            ZkOpenRegionCoordination.ZkOpenRegionDetails zkOrd = new ZkOpenRegionCoordination.ZkOpenRegionDetails();
            zkOrd.setServerName(server.getServerName());
            zkOrd.setVersion(stat.getVersion());
            OpenedRegionHandler handler = new OpenedRegionHandler((Server)server, am, region.getRegionInfo(), orc, (OpenRegionCoordination.OpenRegionDetails)zkOrd);
            ZKAssign.transitionNode((ZooKeeperWatcher)this.zkw, (HRegionInfo)region.getRegionInfo(), (ServerName)server.getServerName(), (EventType)EventType.RS_ZK_REGION_OPENED, (EventType)EventType.RS_ZK_REGION_OPENED, (int)stat.getVersion());
            boolean expectedException = false;
            try {
                handler.process();
            }
            catch (Exception e) {
                expectedException = true;
            }
            Assert.assertFalse((String)"The process method should not throw any exception.", (boolean)expectedException);
            List znodes = ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)this.zkw, (String)this.zkw.assignmentZNode);
            String regionName = (String)znodes.get(0);
            Assert.assertEquals((String)"The region should not be opened successfully.", (Object)regionName, (Object)region.getRegionInfo().getEncodedName());
        }
        catch (Throwable throwable) {
            HRegion.closeHRegion(region);
            this.TEST_UTIL.shutdownMiniZKCluster();
            throw throwable;
        }
        HRegion.closeHRegion((HRegion)region);
        this.TEST_UTIL.shutdownMiniZKCluster();
    }

    private MiniHBaseCluster createRegions(String tableName) throws InterruptedException, ZooKeeperConnectionException, IOException, KeeperException {
        MiniHBaseCluster cluster = this.TEST_UTIL.getHBaseCluster();
        this.log("Waiting for active/ready master");
        cluster.waitForActiveAndReadyMaster();
        this.zkw = new ZooKeeperWatcher(this.conf, "testOpenedRegionHandler", null);
        byte[] table = Bytes.toBytes((String)tableName);
        byte[] family = Bytes.toBytes((String)"family");
        this.TEST_UTIL.createTable(table, family);
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)this.zkw);
        return cluster;
    }

    private void abortMaster(MiniHBaseCluster cluster) {
        this.log("Aborting master");
        cluster.abortMaster(0);
        cluster.waitOnMaster(0);
        this.log("Master has aborted");
    }

    private HRegion getRegionBeingServed(MiniHBaseCluster cluster, HRegionServer regionServer) {
        Collection onlineRegionsLocalContext = regionServer.getOnlineRegionsLocalContext();
        Iterator iterator = onlineRegionsLocalContext.iterator();
        HRegion region = null;
        while (iterator.hasNext() && (region = (HRegion)iterator.next()).getRegionInfo().isMetaTable()) {
        }
        return region;
    }

    private void log(String msg) {
        LOG.debug((Object)("\n\nTRR: " + msg + "\n"));
    }
}

