/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestDefaultMobStoreFlusher {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] row2 = Bytes.toBytes((String)"row2");
    private static final byte[] family = Bytes.toBytes((String)"family");
    private static final byte[] qf1 = Bytes.toBytes((String)"qf1");
    private static final byte[] qf2 = Bytes.toBytes((String)"qf2");
    private static final byte[] value1 = Bytes.toBytes((String)"value1");
    private static final byte[] value2 = Bytes.toBytes((String)"value2");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFlushNonMobFile() throws InterruptedException {
        String TN = "testFlushNonMobFile";
        HTable table = null;
        HBaseAdmin admin = null;
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)TN));
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            hcd.setMaxVersions(4);
            desc.addFamily(hcd);
            admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
            admin.createTable(desc);
            table = new HTable(TEST_UTIL.getConfiguration(), TN);
            Put put0 = new Put(row1);
            put0.add(family, qf1, 1L, value1);
            table.put(put0);
            Put put1 = new Put(row2);
            put1.add(family, qf2, 1L, value2);
            table.put(put1);
            table.flushCommits();
            admin.flush(TN);
            Scan scan = new Scan();
            scan.addColumn(family, qf1);
            scan.setMaxVersions(4);
            ResultScanner scanner = table.getScanner(scan);
            Result result = scanner.next();
            int size = 0;
            while (result != null) {
                ++size;
                List cells = result.getColumnCells(family, qf1);
                Assert.assertEquals((long)1L, (long)cells.size());
                Assert.assertEquals((Object)Bytes.toString((byte[])value1), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells.get(0)))));
                result = scanner.next();
            }
            scanner.close();
            Assert.assertEquals((long)1L, (long)size);
            admin.close();
        }
        catch (MasterNotRunningException e1) {
            e1.printStackTrace();
        }
        catch (ZooKeeperConnectionException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    @Test
    public void testFlushMobFile() throws InterruptedException {
        String TN = "testFlushMobFile";
        HTable table = null;
        HBaseAdmin admin = null;
        try {
            HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)TN));
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            hcd.setMobEnabled(true);
            hcd.setMobThreshold(3L);
            hcd.setMaxVersions(4);
            desc.addFamily(hcd);
            admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
            admin.createTable(desc);
            table = new HTable(TEST_UTIL.getConfiguration(), TN);
            Put put0 = new Put(row1);
            put0.add(family, qf1, 1L, value1);
            table.put(put0);
            Put put1 = new Put(row2);
            put1.add(family, qf2, 1L, value2);
            table.put(put1);
            table.flushCommits();
            admin.flush(TN);
            Scan scan = new Scan();
            scan.addColumn(family, qf1);
            scan.setMaxVersions(4);
            ResultScanner scanner = table.getScanner(scan);
            Result result = scanner.next();
            int size = 0;
            while (result != null) {
                ++size;
                List cells = result.getColumnCells(family, qf1);
                Assert.assertEquals((long)1L, (long)cells.size());
                Assert.assertEquals((Object)Bytes.toString((byte[])value1), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)((Cell)cells.get(0)))));
                result = scanner.next();
            }
            scanner.close();
            Assert.assertEquals((long)1L, (long)size);
            admin.close();
        }
        catch (MasterNotRunningException e1) {
            e1.printStackTrace();
        }
        catch (ZooKeeperConnectionException e2) {
            e2.printStackTrace();
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }
}

