/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mob.MobFile;
import org.apache.hadoop.hbase.mob.MobTestUtil;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMobFile
extends TestCase {
    static final Log LOG = LogFactory.getLog(TestMobFile.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf = TEST_UTIL.getConfiguration();
    private CacheConfig cacheConf = new CacheConfig(this.conf);
    private final String TABLE = "tableName";
    private final String FAMILY = "familyName";

    @Test
    public void testReadKeyValue() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path testDir = FSUtils.getRootDir((Configuration)this.conf);
        Path outputDir = new Path(new Path(testDir, "tableName"), "familyName");
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, fs).withOutputDir(outputDir).withFileContext(meta).build();
        String caseName = this.getName();
        MobTestUtil.writeStoreFile(writer, caseName);
        MobFile mobFile = new MobFile(new StoreFile(fs, writer.getPath(), this.conf, this.cacheConf, BloomType.NONE));
        byte[] family = Bytes.toBytes((String)caseName);
        byte[] qualify = Bytes.toBytes((String)caseName);
        byte[] startKey = Bytes.toBytes((String)"aa");
        KeyValue expectedKey = new KeyValue(startKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, startKey);
        KeyValue seekKey = expectedKey.createKeyOnly(false);
        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)mobFile.readCell((Cell)seekKey, false));
        MobTestUtil.assertKeyValuesEquals(expectedKey, kv);
        byte[] endKey = Bytes.toBytes((String)"zz");
        expectedKey = new KeyValue(endKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, endKey);
        seekKey = expectedKey.createKeyOnly(false);
        kv = KeyValueUtil.ensureKeyValue((Cell)mobFile.readCell((Cell)seekKey, false));
        MobTestUtil.assertKeyValuesEquals(expectedKey, kv);
        byte[] randomKey = Bytes.toBytes((String)MobTestUtil.generateRandomString(2));
        expectedKey = new KeyValue(randomKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, randomKey);
        seekKey = expectedKey.createKeyOnly(false);
        kv = KeyValueUtil.ensureKeyValue((Cell)mobFile.readCell((Cell)seekKey, false));
        MobTestUtil.assertKeyValuesEquals(expectedKey, kv);
        byte[] lowerKey = Bytes.toBytes((String)"a1");
        expectedKey = new KeyValue(startKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, startKey);
        seekKey = new KeyValue(lowerKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, lowerKey);
        kv = KeyValueUtil.ensureKeyValue((Cell)mobFile.readCell((Cell)seekKey, false));
        MobTestUtil.assertKeyValuesEquals(expectedKey, kv);
        byte[] upperKey = Bytes.toBytes((String)"z{");
        seekKey = new KeyValue(upperKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, upperKey);
        kv = KeyValueUtil.ensureKeyValue((Cell)mobFile.readCell((Cell)seekKey, false));
        TestMobFile.assertNull((Object)kv);
    }

    @Test
    public void testGetScanner() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path testDir = FSUtils.getRootDir((Configuration)this.conf);
        Path outputDir = new Path(new Path(testDir, "tableName"), "familyName");
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFile.Writer writer = new StoreFile.WriterBuilder(this.conf, this.cacheConf, fs).withOutputDir(outputDir).withFileContext(meta).build();
        MobTestUtil.writeStoreFile(writer, this.getName());
        MobFile mobFile = new MobFile(new StoreFile(fs, writer.getPath(), this.conf, this.cacheConf, BloomType.NONE));
        TestMobFile.assertNotNull((Object)mobFile.getScanner());
        TestMobFile.assertTrue((boolean)(mobFile.getScanner() instanceof StoreFileScanner));
    }
}

