/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.mob.CachedMobFile;
import org.apache.hadoop.hbase.mob.MobCacheConfig;
import org.apache.hadoop.hbase.mob.MobFileCache;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMobFileCache
extends TestCase {
    static final Log LOG = LogFactory.getLog(TestMobFileCache.class);
    private HBaseTestingUtility UTIL;
    private HRegion region;
    private Configuration conf;
    private MobCacheConfig mobCacheConf;
    private MobFileCache mobFileCache;
    private Date currentDate = new Date();
    private final String TEST_CACHE_SIZE = "2";
    private final int EXPECTED_CACHE_SIZE_ZERO = 0;
    private final int EXPECTED_CACHE_SIZE_ONE = 1;
    private final int EXPECTED_CACHE_SIZE_TWO = 2;
    private final int EXPECTED_CACHE_SIZE_THREE = 3;
    private final long EXPECTED_REFERENCE_ONE = 1L;
    private final long EXPECTED_REFERENCE_TWO = 2L;
    private final String TABLE = "tableName";
    private final String FAMILY1 = "family1";
    private final String FAMILY2 = "family2";
    private final String FAMILY3 = "family3";
    private final byte[] ROW = Bytes.toBytes((String)"row");
    private final byte[] ROW2 = Bytes.toBytes((String)"row2");
    private final byte[] VALUE = Bytes.toBytes((String)"value");
    private final byte[] VALUE2 = Bytes.toBytes((String)"value2");
    private final byte[] QF1 = Bytes.toBytes((String)"qf1");
    private final byte[] QF2 = Bytes.toBytes((String)"qf2");
    private final byte[] QF3 = Bytes.toBytes((String)"qf3");

    public void setUp() throws Exception {
        this.UTIL = HBaseTestingUtility.createLocalHTU();
        this.conf = this.UTIL.getConfiguration();
        this.conf.setInt("hfile.format.version", 3);
        HTableDescriptor htd = this.UTIL.createTableDescriptor("testMobFileCache");
        HColumnDescriptor hcd1 = new HColumnDescriptor("family1");
        hcd1.setMobEnabled(true);
        hcd1.setMobThreshold(0L);
        HColumnDescriptor hcd2 = new HColumnDescriptor("family2");
        hcd2.setMobEnabled(true);
        hcd2.setMobThreshold(0L);
        HColumnDescriptor hcd3 = new HColumnDescriptor("family3");
        hcd3.setMobEnabled(true);
        hcd3.setMobThreshold(0L);
        htd.addFamily(hcd1);
        htd.addFamily(hcd2);
        htd.addFamily(hcd3);
        this.region = this.UTIL.createLocalHRegion(htd, null, null);
    }

    protected void tearDown() throws Exception {
        this.region.close();
        this.region.getFilesystem().delete(this.UTIL.getDataTestDir(), true);
    }

    private Path createMobStoreFile(String family) throws IOException {
        return this.createMobStoreFile(HBaseConfiguration.create(), family);
    }

    private Path createMobStoreFile(Configuration conf, String family) throws IOException {
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        hcd.setMaxVersions(4);
        hcd.setMobEnabled(true);
        this.mobCacheConf = new MobCacheConfig(conf, hcd);
        return this.createMobStoreFile(conf, hcd);
    }

    private Path createMobStoreFile(Configuration conf, HColumnDescriptor hcd) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"tableName"));
        htd.addFamily(hcd);
        HMobStore mobStore = (HMobStore)this.region.getStore(hcd.getName());
        KeyValue key1 = new KeyValue(this.ROW, hcd.getName(), this.QF1, 1L, this.VALUE);
        KeyValue key2 = new KeyValue(this.ROW, hcd.getName(), this.QF2, 1L, this.VALUE);
        KeyValue key3 = new KeyValue(this.ROW2, hcd.getName(), this.QF3, 1L, this.VALUE2);
        KeyValue[] keys = new KeyValue[]{key1, key2, key3};
        int maxKeyCount = keys.length;
        HRegionInfo regionInfo = new HRegionInfo();
        StoreFile.Writer mobWriter = mobStore.createWriterInTmp(this.currentDate, (long)maxKeyCount, hcd.getCompactionCompression(), regionInfo.getStartKey());
        Path mobFilePath = mobWriter.getPath();
        String fileName = mobFilePath.getName();
        mobWriter.append((Cell)key1);
        mobWriter.append((Cell)key2);
        mobWriter.append((Cell)key3);
        mobWriter.close();
        String targetPathName = MobUtils.formatDate((Date)this.currentDate);
        Path targetPath = new Path(mobStore.getPath(), targetPathName);
        mobStore.commitFile(mobFilePath, targetPath);
        return new Path(targetPath, fileName);
    }

    @Test
    public void testMobFileCache() throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        this.conf.set("hbase.mob.file.cache.size", "2");
        this.mobFileCache = new MobFileCache(this.conf);
        Path file1Path = this.createMobStoreFile("family1");
        Path file2Path = this.createMobStoreFile("family2");
        Path file3Path = this.createMobStoreFile("family3");
        TestMobFileCache.assertEquals((int)0, (int)this.mobFileCache.getCacheSize());
        CachedMobFile cachedMobFile1 = (CachedMobFile)this.mobFileCache.openFile(fs, file1Path, this.mobCacheConf);
        TestMobFileCache.assertEquals((int)1, (int)this.mobFileCache.getCacheSize());
        TestMobFileCache.assertNotNull((Object)cachedMobFile1);
        TestMobFileCache.assertEquals((long)2L, (long)cachedMobFile1.getReferenceCount());
        this.mobFileCache.evict();
        TestMobFileCache.assertEquals((int)1, (int)this.mobFileCache.getCacheSize());
        TestMobFileCache.assertEquals((long)2L, (long)cachedMobFile1.getReferenceCount());
        this.mobFileCache.evictFile(file1Path.getName());
        TestMobFileCache.assertEquals((int)0, (int)this.mobFileCache.getCacheSize());
        TestMobFileCache.assertEquals((long)1L, (long)cachedMobFile1.getReferenceCount());
        cachedMobFile1.close();
        cachedMobFile1 = (CachedMobFile)this.mobFileCache.openFile(fs, file1Path, this.mobCacheConf);
        TestMobFileCache.assertEquals((int)1, (int)this.mobFileCache.getCacheSize());
        CachedMobFile cachedMobFile2 = (CachedMobFile)this.mobFileCache.openFile(fs, file2Path, this.mobCacheConf);
        TestMobFileCache.assertEquals((int)2, (int)this.mobFileCache.getCacheSize());
        CachedMobFile cachedMobFile3 = (CachedMobFile)this.mobFileCache.openFile(fs, file3Path, this.mobCacheConf);
        TestMobFileCache.assertEquals((int)3, (int)this.mobFileCache.getCacheSize());
        TestMobFileCache.assertEquals((long)2L, (long)cachedMobFile1.getReferenceCount());
        TestMobFileCache.assertEquals((long)2L, (long)cachedMobFile2.getReferenceCount());
        TestMobFileCache.assertEquals((long)2L, (long)cachedMobFile3.getReferenceCount());
        this.mobFileCache.evict();
        TestMobFileCache.assertEquals((int)1, (int)this.mobFileCache.getCacheSize());
        TestMobFileCache.assertEquals((long)1L, (long)cachedMobFile1.getReferenceCount());
        TestMobFileCache.assertEquals((long)1L, (long)cachedMobFile2.getReferenceCount());
        TestMobFileCache.assertEquals((long)2L, (long)cachedMobFile3.getReferenceCount());
    }
}

