/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestMobFileLink {
    @Test
    public void testMobFilePath() throws IOException {
        TableName tableName = TableName.valueOf((String)"testMobFilePath");
        Configuration conf = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        Path tableDir = FSUtils.getTableDir((Path)rootDir, (TableName)tableName);
        Path archiveDir = FSUtils.getTableDir((Path)HFileArchiveUtil.getArchivePath((Configuration)conf), (TableName)tableName);
        String fileName = "mobFile";
        String encodedRegionName = MobUtils.getMobRegionInfo((TableName)tableName).getEncodedName();
        String columnFamily = "columnFamily";
        Path regionDir = new Path(tableDir, encodedRegionName);
        Path archivedRegionDir = new Path(archiveDir, encodedRegionName);
        Path expectedMobFilePath = new Path(MobUtils.getMobFamilyPath((Configuration)conf, (TableName)tableName, (String)columnFamily), fileName).makeQualified(fs.getUri(), fs.getWorkingDirectory());
        Path expectedOriginPath = new Path(new Path(regionDir, columnFamily), fileName).makeQualified(fs.getUri(), fs.getWorkingDirectory());
        Path expectedArchivePath = new Path(new Path(archivedRegionDir, columnFamily), fileName).makeQualified(fs.getUri(), fs.getWorkingDirectory());
        String hfileLinkName = tableName.getNameAsString() + "=" + encodedRegionName + "-" + fileName;
        Path hfileLinkPath = new Path(columnFamily, hfileLinkName);
        HFileLink hfileLink = HFileLink.buildFromHFileLinkPattern((Configuration)conf, (Path)hfileLinkPath);
        Assert.assertEquals((Object)expectedMobFilePath, (Object)hfileLink.getMobPath());
        Assert.assertEquals((Object)expectedOriginPath, (Object)hfileLink.getOriginPath());
        Assert.assertEquals((Object)expectedArchivePath, (Object)hfileLink.getArchivePath());
    }
}

