/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.filecompactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.filecompactions.PartitionedMobFileCompactor;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestMobFileCompactor {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf = null;
    private String tableNameAsString;
    private TableName tableName;
    private HTable hTable;
    private Admin admin;
    private HTableDescriptor desc;
    private HColumnDescriptor hcd1;
    private HColumnDescriptor hcd2;
    private FileSystem fs;
    private final String family1 = "family1";
    private final String family2 = "family2";
    private final String qf1 = "qualifier1";
    private final String qf2 = "qualifier2";
    private byte[] KEYS = Bytes.toBytes((String)"012");
    private int regionNum = this.KEYS.length;
    private int delRowNum = 1;
    private int delCellNum = 6;
    private int cellNumPerRow = 3;
    private int rowNumPerFile = 2;
    private static ExecutorService pool;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        TEST_UTIL.getConfiguration().setLong("hbase.mob.file.compaction.mergeable.threshold", 5000L);
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.startMiniCluster(1);
        pool = TestMobFileCompactor.createThreadPool(TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        pool.shutdown();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.fs = TEST_UTIL.getTestFileSystem();
        this.conf = TEST_UTIL.getConfiguration();
        long tid = System.currentTimeMillis();
        this.tableNameAsString = "testMob" + tid;
        this.tableName = TableName.valueOf((String)this.tableNameAsString);
        this.hcd1 = new HColumnDescriptor("family1");
        this.hcd1.setMobEnabled(true);
        this.hcd1.setMobThreshold(0L);
        this.hcd1.setMaxVersions(4);
        this.hcd2 = new HColumnDescriptor("family2");
        this.hcd2.setMobEnabled(true);
        this.hcd2.setMobThreshold(0L);
        this.hcd2.setMaxVersions(4);
        this.desc = new HTableDescriptor(this.tableName);
        this.desc.addFamily(this.hcd1);
        this.desc.addFamily(this.hcd2);
        this.admin = TEST_UTIL.getHBaseAdmin();
        this.admin.createTable(this.desc, this.getSplitKeys());
        this.hTable = new HTable(this.conf, this.tableNameAsString);
        this.hTable.setAutoFlush(false, false);
    }

    @After
    public void tearDown() throws Exception {
        this.admin.disableTable(this.tableName);
        this.admin.deleteTable(this.tableName);
        this.admin.close();
        this.hTable.close();
        this.fs.delete(TEST_UTIL.getDataTestDir(), true);
    }

    @Test
    public void testCompactionWithoutDelFilesWithNamespace() throws Exception {
        this.resetConf();
        NamespaceDescriptor namespaceDescriptor = NamespaceDescriptor.create((String)"ns").build();
        String tableNameAsString = "ns:testCompactionWithoutDelFilesWithNamespace";
        this.admin.createNamespace(namespaceDescriptor);
        TableName tableName = TableName.valueOf((String)tableNameAsString);
        HColumnDescriptor hcd1 = new HColumnDescriptor("family1");
        hcd1.setMobEnabled(true);
        hcd1.setMobThreshold(0L);
        hcd1.setMaxVersions(4);
        HColumnDescriptor hcd2 = new HColumnDescriptor("family2");
        hcd2.setMobEnabled(true);
        hcd2.setMobThreshold(0L);
        hcd2.setMaxVersions(4);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(hcd1);
        desc.addFamily(hcd2);
        this.admin.createTable(desc, this.getSplitKeys());
        HTable table = new HTable(this.conf, tableName);
        table.setAutoFlush(false, false);
        int count = 4;
        this.loadData(this.admin, table, tableName, count, this.rowNumPerFile);
        int rowNumPerRegion = count * this.rowNumPerFile;
        Assert.assertEquals((String)"Before compaction: mob rows count", (long)(this.regionNum * rowNumPerRegion), (long)this.countMobRows(table));
        Assert.assertEquals((String)"Before compaction: mob file count", (long)(this.regionNum * count), (long)this.countFiles(tableName, true, "family1"));
        Assert.assertEquals((String)"Before compaction: del file count", (long)0L, (long)this.countFiles(tableName, false, "family1"));
        PartitionedMobFileCompactor compactor = new PartitionedMobFileCompactor(this.conf, this.fs, tableName, hcd1, pool);
        compactor.compact();
        Assert.assertEquals((String)"After compaction: mob rows count", (long)(this.regionNum * rowNumPerRegion), (long)this.countMobRows(table));
        Assert.assertEquals((String)"After compaction: mob file count", (long)this.regionNum, (long)this.countFiles(tableName, true, "family1"));
        Assert.assertEquals((String)"After compaction: del file count", (long)0L, (long)this.countFiles(tableName, false, "family1"));
        table.close();
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
        this.admin.deleteNamespace("ns");
    }

    @Test
    public void testCompactionWithoutDelFiles() throws Exception {
        this.resetConf();
        int count = 4;
        this.loadData(this.admin, this.hTable, this.tableName, count, this.rowNumPerFile);
        int rowNumPerRegion = count * this.rowNumPerFile;
        Assert.assertEquals((String)"Before compaction: mob rows count", (long)(this.regionNum * rowNumPerRegion), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before compaction: mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"Before compaction: del file count", (long)0L, (long)this.countFiles(this.tableName, false, "family1"));
        PartitionedMobFileCompactor compactor = new PartitionedMobFileCompactor(this.conf, this.fs, this.tableName, this.hcd1, pool);
        compactor.compact();
        Assert.assertEquals((String)"After compaction: mob rows count", (long)(this.regionNum * rowNumPerRegion), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"After compaction: mob file count", (long)this.regionNum, (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"After compaction: del file count", (long)0L, (long)this.countFiles(this.tableName, false, "family1"));
    }

    @Test
    public void testCompactionWithDelFiles() throws Exception {
        this.resetConf();
        int count = 4;
        this.loadData(this.admin, this.hTable, this.tableName, count, this.rowNumPerFile);
        int rowNumPerRegion = count * this.rowNumPerFile;
        Assert.assertEquals((String)"Before deleting: mob rows count", (long)(this.regionNum * rowNumPerRegion), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before deleting: mob cells count", (long)(this.regionNum * this.cellNumPerRow * rowNumPerRegion), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"Before deleting: family1 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"Before deleting: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        this.createDelFile();
        Assert.assertEquals((String)"Before compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"Before compaction: family1 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"Before compaction: family1 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
        PartitionedMobFileCompactor compactor = new PartitionedMobFileCompactor(this.conf, this.fs, this.tableName, this.hcd1, pool);
        compactor.compact();
        Assert.assertEquals((String)"After compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"After compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"After compaction: family1 mob file count", (long)this.regionNum, (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"After compaction: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"After compaction: family1 del file count", (long)0L, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"After compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
        this.assertRefFileNameEqual("family1");
    }

    @Test
    public void testCompactionWithDelFilesAndNotMergeAllFiles() throws Exception {
        this.resetConf();
        int mergeSize = 5000;
        this.conf.setLong("hbase.mob.file.compaction.mergeable.threshold", (long)mergeSize);
        int count = 4;
        this.loadData(this.admin, this.hTable, this.tableName, count, this.rowNumPerFile);
        int rowNumPerRegion = count * this.rowNumPerFile;
        Assert.assertEquals((String)"Before deleting: mob rows count", (long)(this.regionNum * rowNumPerRegion), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before deleting: mob cells count", (long)(this.regionNum * this.cellNumPerRow * rowNumPerRegion), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"Before deleting: mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        int largeFilesCount = this.countLargeFiles(mergeSize, "family1");
        this.createDelFile();
        Assert.assertEquals((String)"Before compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"Before compaction: family1 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"Before compaction: family1 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
        PartitionedMobFileCompactor compactor = new PartitionedMobFileCompactor(this.conf, this.fs, this.tableName, this.hcd1, pool);
        compactor.compact();
        Assert.assertEquals((String)"After compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"After compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"After compaction: family1 mob file count", (long)(largeFilesCount + this.regionNum), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"After compaction: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"After compaction: family1 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"After compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
    }

    @Test
    public void testCompactionWithDelFilesAndWithSmallCompactionBatchSize() throws Exception {
        this.resetConf();
        int batchSize = 2;
        this.conf.setInt("hbase.mob.file.compaction.batch.size", batchSize);
        int count = 4;
        this.loadData(this.admin, this.hTable, this.tableName, count, this.rowNumPerFile);
        int rowNumPerRegion = count * this.rowNumPerFile;
        Assert.assertEquals((String)"Before deleting: mob row count", (long)(this.regionNum * rowNumPerRegion), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before deleting: family1 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"Before deleting: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        this.createDelFile();
        Assert.assertEquals((String)"Before compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"Before compaction: family1 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"Before compaction: family1 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
        PartitionedMobFileCompactor compactor = new PartitionedMobFileCompactor(this.conf, this.fs, this.tableName, this.hcd1, pool);
        compactor.compact();
        Assert.assertEquals((String)"After compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"After compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"After compaction: family1 mob file count", (long)(this.regionNum * (count / batchSize)), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"After compaction: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"After compaction: family1 del file count", (long)0L, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"After compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
    }

    @Test
    public void testCompactionWithHFileLink() throws IOException, InterruptedException {
        this.resetConf();
        int count = 4;
        this.loadData(this.admin, this.hTable, this.tableName, count, this.rowNumPerFile);
        int rowNumPerRegion = count * this.rowNumPerFile;
        long tid = System.currentTimeMillis();
        byte[] snapshotName1 = Bytes.toBytes((String)("snaptb-" + tid));
        this.admin.snapshot(snapshotName1, this.tableName);
        this.createDelFile();
        Assert.assertEquals((String)"Before compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"Before compaction: family1 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"Before compaction: family1 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
        PartitionedMobFileCompactor compactor = new PartitionedMobFileCompactor(this.conf, this.fs, this.tableName, this.hcd1, pool);
        compactor.compact();
        Assert.assertEquals((String)"After first compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"After first compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"After first compaction: family1 mob file count", (long)this.regionNum, (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"After first compaction: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"After first compaction: family1 del file count", (long)0L, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"After first compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
        Assert.assertEquals((String)"After first compaction: family1 hfilelink count", (long)0L, (long)this.countHFileLinks("family1"));
        Assert.assertEquals((String)"After first compaction: family2 hfilelink count", (long)0L, (long)this.countHFileLinks("family2"));
        this.admin.disableTable(this.tableName);
        this.admin.restoreSnapshot(snapshotName1);
        this.admin.enableTable(this.tableName);
        Assert.assertEquals((String)"After restoring snapshot: mob rows count", (long)(this.regionNum * rowNumPerRegion), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"After restoring snapshot: mob cells count", (long)(this.regionNum * this.cellNumPerRow * rowNumPerRegion), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"After restoring snapshot: family1 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"After restoring snapshot: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"After restoring snapshot: family1 del file count", (long)0L, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"After restoring snapshot: family2 del file count", (long)0L, (long)this.countFiles(this.tableName, false, "family2"));
        Assert.assertEquals((String)"After restoring snapshot: family1 hfilelink count", (long)(this.regionNum * count), (long)this.countHFileLinks("family1"));
        Assert.assertEquals((String)"After restoring snapshot: family2 hfilelink count", (long)0L, (long)this.countHFileLinks("family2"));
        compactor.compact();
        Assert.assertEquals((String)"After second compaction: mob rows count", (long)(this.regionNum * rowNumPerRegion), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"After second compaction: mob cells count", (long)(this.regionNum * this.cellNumPerRow * rowNumPerRegion), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"After second compaction: family1 mob file count", (long)this.regionNum, (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"After second compaction: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"After second compaction: family1 del file count", (long)0L, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"After second compaction: family2 del file count", (long)0L, (long)this.countFiles(this.tableName, false, "family2"));
        Assert.assertEquals((String)"After second compaction: family1 hfilelink count", (long)0L, (long)this.countHFileLinks("family1"));
        Assert.assertEquals((String)"After second compaction: family2 hfilelink count", (long)0L, (long)this.countHFileLinks("family2"));
        this.assertRefFileNameEqual("family1");
    }

    @Test
    public void testCompactionFromAdmin() throws Exception {
        int count = 4;
        this.loadData(this.admin, this.hTable, this.tableName, count, this.rowNumPerFile);
        int rowNumPerRegion = count * this.rowNumPerFile;
        Assert.assertEquals((String)"Before deleting: mob rows count", (long)(this.regionNum * rowNumPerRegion), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before deleting: mob cells count", (long)(this.regionNum * this.cellNumPerRow * rowNumPerRegion), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"Before deleting: family1 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"Before deleting: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        this.createDelFile();
        Assert.assertEquals((String)"Before compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"Before compaction: family1 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"Before compaction: family1 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
        int largeFilesCount = this.countLargeFiles(5000, "family1");
        this.admin.compactMob(this.tableName, this.hcd1.getName());
        this.waitUntilCompactionFinished(this.tableName);
        Assert.assertEquals((String)"After compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"After compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"After compaction: family1 mob file count", (long)(this.regionNum + largeFilesCount), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"After compaction: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"After compaction: family1 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"After compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
        this.assertRefFileNameEqual("family1");
    }

    @Test
    public void testMajorCompactionFromAdmin() throws Exception {
        int count = 4;
        this.loadData(this.admin, this.hTable, this.tableName, count, this.rowNumPerFile);
        int rowNumPerRegion = count * this.rowNumPerFile;
        Assert.assertEquals((String)"Before deleting: mob rows count", (long)(this.regionNum * rowNumPerRegion), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before deleting: mob cells count", (long)(this.regionNum * this.cellNumPerRow * rowNumPerRegion), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"Before deleting: mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        this.createDelFile();
        Assert.assertEquals((String)"Before compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"Before compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"Before compaction: family1 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"Before compaction: family1 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"Before compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
        this.admin.majorCompactMob(this.tableName, this.hcd1.getName());
        this.waitUntilCompactionFinished(this.tableName);
        Assert.assertEquals((String)"After compaction: mob rows count", (long)(this.regionNum * (rowNumPerRegion - this.delRowNum)), (long)this.countMobRows(this.hTable));
        Assert.assertEquals((String)"After compaction: mob cells count", (long)(this.regionNum * (this.cellNumPerRow * rowNumPerRegion - this.delCellNum)), (long)this.countMobCells(this.hTable));
        Assert.assertEquals((String)"After compaction: family1 mob file count", (long)this.regionNum, (long)this.countFiles(this.tableName, true, "family1"));
        Assert.assertEquals((String)"After compaction: family2 mob file count", (long)(this.regionNum * count), (long)this.countFiles(this.tableName, true, "family2"));
        Assert.assertEquals((String)"After compaction: family1 del file count", (long)0L, (long)this.countFiles(this.tableName, false, "family1"));
        Assert.assertEquals((String)"After compaction: family2 del file count", (long)this.regionNum, (long)this.countFiles(this.tableName, false, "family2"));
    }

    private void waitUntilCompactionFinished(TableName tableName) throws IOException, InterruptedException {
        long finished = EnvironmentEdgeManager.currentTime() + 60000L;
        AdminProtos.GetRegionInfoResponse.CompactionState state = this.admin.getMobCompactionState(tableName);
        while (EnvironmentEdgeManager.currentTime() < finished && state != AdminProtos.GetRegionInfoResponse.CompactionState.NONE) {
            state = this.admin.getMobCompactionState(tableName);
            Thread.sleep(10L);
        }
        Assert.assertEquals((Object)AdminProtos.GetRegionInfoResponse.CompactionState.NONE, (Object)state);
    }

    private int countMobRows(HTable table) throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            ++count;
        }
        results.close();
        return count;
    }

    private int countMobCells(HTable table) throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            for (Cell cell : res.listCells()) {
                ++count;
            }
        }
        results.close();
        return count;
    }

    private int countFiles(TableName tableName, boolean isMobFile, String familyName) throws IOException {
        Path mobDirPath = MobUtils.getMobFamilyPath((Path)MobUtils.getMobRegionPath((Configuration)this.conf, (TableName)tableName), (String)familyName);
        int count = 0;
        if (this.fs.exists(mobDirPath)) {
            FileStatus[] files;
            for (FileStatus file : files = this.fs.listStatus(mobDirPath)) {
                if (isMobFile) {
                    if (StoreFileInfo.isDelFile((Path)file.getPath())) continue;
                    ++count;
                    continue;
                }
                if (!StoreFileInfo.isDelFile((Path)file.getPath())) continue;
                ++count;
            }
        }
        return count;
    }

    private int countHFileLinks(String familyName) throws IOException {
        Path mobDirPath = MobUtils.getMobFamilyPath((Path)MobUtils.getMobRegionPath((Configuration)this.conf, (TableName)this.tableName), (String)familyName);
        int count = 0;
        if (this.fs.exists(mobDirPath)) {
            FileStatus[] files;
            for (FileStatus file : files = this.fs.listStatus(mobDirPath)) {
                if (!HFileLink.isHFileLink((Path)file.getPath())) continue;
                ++count;
            }
        }
        return count;
    }

    private int countLargeFiles(int size, String familyName) throws IOException {
        Path mobDirPath = MobUtils.getMobFamilyPath((Path)MobUtils.getMobRegionPath((Configuration)this.conf, (TableName)this.tableName), (String)familyName);
        int count = 0;
        if (this.fs.exists(mobDirPath)) {
            FileStatus[] files;
            for (FileStatus file : files = this.fs.listStatus(mobDirPath)) {
                if (StoreFileInfo.isDelFile((Path)file.getPath()) || file.getLen() <= (long)size) continue;
                ++count;
            }
        }
        return count;
    }

    private void loadData(Admin admin, HTable table, TableName tableName, int fileNum, int rowNumPerFile) throws IOException, InterruptedException {
        if (fileNum <= 0) {
            throw new IllegalArgumentException();
        }
        for (byte k0 : this.KEYS) {
            byte[] k = new byte[]{k0};
            for (int i = 0; i < fileNum * rowNumPerFile; ++i) {
                byte[] key = Bytes.add((byte[])k, (byte[])Bytes.toBytes((int)i));
                byte[] mobVal = this.makeDummyData(10 * (i + 1));
                Put put = new Put(key);
                put.setDurability(Durability.SKIP_WAL);
                put.add(Bytes.toBytes((String)"family1"), Bytes.toBytes((String)"qualifier1"), mobVal);
                put.add(Bytes.toBytes((String)"family1"), Bytes.toBytes((String)"qualifier2"), mobVal);
                put.add(Bytes.toBytes((String)"family2"), Bytes.toBytes((String)"qualifier1"), mobVal);
                table.put(put);
                if ((i + 1) % rowNumPerFile != 0) continue;
                table.flushCommits();
                admin.flush(tableName);
            }
        }
    }

    private void createDelFile() throws IOException, InterruptedException {
        for (byte k0 : this.KEYS) {
            byte[] k = new byte[]{k0};
            byte[] key1 = Bytes.add((byte[])k, (byte[])Bytes.toBytes((int)0));
            Delete delete1 = new Delete(key1);
            delete1.deleteFamily(Bytes.toBytes((String)"family1"));
            this.hTable.delete(delete1);
            byte[] key2 = Bytes.add((byte[])k, (byte[])Bytes.toBytes((int)2));
            Delete delete2 = new Delete(key2);
            this.hTable.delete(delete2);
            byte[] key3 = Bytes.add((byte[])k, (byte[])Bytes.toBytes((int)4));
            Delete delete3 = new Delete(key3);
            delete3.deleteColumn(Bytes.toBytes((String)"family1"), Bytes.toBytes((String)"qualifier1"));
            this.hTable.delete(delete3);
            this.hTable.flushCommits();
            this.admin.flush(this.tableName);
            List<HRegion> regions = TEST_UTIL.getHBaseCluster().getRegions(Bytes.toBytes((String)this.tableNameAsString));
            for (HRegion region : regions) {
                region.waitForFlushesAndCompactions();
                region.compactStores(true);
            }
        }
    }

    private byte[] makeDummyData(int size) {
        byte[] dummyData = new byte[size];
        new Random().nextBytes(dummyData);
        return dummyData;
    }

    private byte[][] getSplitKeys() {
        byte[][] splitKeys = new byte[this.KEYS.length - 1][];
        for (int i = 0; i < splitKeys.length; ++i) {
            splitKeys[i] = new byte[]{this.KEYS[i + 1]};
        }
        return splitKeys;
    }

    private static ExecutorService createThreadPool(Configuration conf) {
        int maxThreads = 10;
        long keepAliveTime = 60L;
        final SynchronousQueue<Runnable> queue = new SynchronousQueue<Runnable>();
        ThreadPoolExecutor pool = new ThreadPoolExecutor(1, maxThreads, keepAliveTime, TimeUnit.SECONDS, queue, Threads.newDaemonThreadFactory((String)"MobFileCompactionChore"), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                try {
                    queue.put(r);
                }
                catch (InterruptedException e) {
                    throw new RejectedExecutionException(e);
                }
            }
        });
        pool.allowCoreThreadTimeOut(true);
        return pool;
    }

    private void assertRefFileNameEqual(String familyName) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(Bytes.toBytes((String)familyName));
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        ResultScanner results = this.hTable.getScanner(scan);
        Path mobFamilyPath = new Path(MobUtils.getMobRegionPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)this.tableName), familyName);
        ArrayList<Path> actualFilePaths = new ArrayList<Path>();
        ArrayList<Path> expectFilePaths = new ArrayList<Path>();
        for (Result res : results) {
            for (Cell cell : res.listCells()) {
                byte[] referenceValue = CellUtil.cloneValue((Cell)cell);
                String fileName = Bytes.toString((byte[])referenceValue, (int)4, (int)(referenceValue.length - 4));
                Path targetPath = new Path(mobFamilyPath, fileName);
                if (actualFilePaths.contains(targetPath)) continue;
                actualFilePaths.add(targetPath);
            }
        }
        results.close();
        if (this.fs.exists(mobFamilyPath)) {
            FileStatus[] files;
            for (FileStatus file : files = this.fs.listStatus(mobFamilyPath)) {
                if (StoreFileInfo.isDelFile((Path)file.getPath())) continue;
                expectFilePaths.add(file.getPath());
            }
        }
        Collections.sort(actualFilePaths);
        Collections.sort(expectFilePaths);
        Assert.assertEquals(expectFilePaths, actualFilePaths);
    }

    private void resetConf() {
        this.conf.setLong("hbase.mob.file.compaction.mergeable.threshold", 0xC000000L);
        this.conf.setInt("hbase.mob.file.compaction.batch.size", 100);
    }
}

