/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.mapreduce;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.mapreduce.SweepJob;
import org.apache.hadoop.hbase.mob.mapreduce.SweepReducer;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.serializer.JavaSerialization;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.counters.GenericCounter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestMobSweepReducer {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String tableName = "testSweepReducer";
    private static final String row = "row";
    private static final String family = "family";
    private static final String qf = "qf";
    private static HTable table;
    private static Admin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(3L);
        hcd.setMaxVersions(4);
        desc.addFamily(hcd);
        admin = TEST_UTIL.getHBaseAdmin();
        admin.createTable(desc);
        table = new HTable(TEST_UTIL.getConfiguration(), tableName);
    }

    @After
    public void tearDown() throws Exception {
        admin.disableTable(TableName.valueOf((String)tableName));
        admin.deleteTable(TableName.valueOf((String)tableName));
        admin.close();
    }

    private List<String> getKeyFromSequenceFile(FileSystem fs, Path path, Configuration conf) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)path)});
        String next = (String)reader.next((Object)null);
        while (next != null) {
            list.add(next);
            next = (String)reader.next((Object)null);
        }
        reader.close();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRun() throws Exception {
        TableName tn = TableName.valueOf((String)tableName);
        byte[] mobValueBytes = new byte[100];
        Path mobFamilyPath = MobUtils.getMobFamilyPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)family);
        Put put = new Put(Bytes.toBytes((String)row));
        put.add(Bytes.toBytes((String)family), Bytes.toBytes((String)qf), 1L, mobValueBytes);
        Put put2 = new Put(Bytes.toBytes((String)"rowignore"));
        put2.add(Bytes.toBytes((String)family), Bytes.toBytes((String)qf), 1L, mobValueBytes);
        table.put(put);
        table.put(put2);
        table.flushCommits();
        admin.flush(tn);
        FileStatus[] fileStatuses = TEST_UTIL.getTestFileSystem().listStatus(mobFamilyPath);
        Assert.assertEquals((long)1L, (long)fileStatuses.length);
        String mobFile1 = fileStatuses[0].getPath().getName();
        Configuration configuration = new Configuration(TEST_UTIL.getConfiguration());
        configuration.setFloat("hbase.mob.sweep.tool.compaction.ratio", 0.6f);
        configuration.setStrings("hbase.mapreduce.inputtable", new String[]{tableName});
        configuration.setStrings("hbase.mapreduce.scan.column.family", new String[]{family});
        configuration.setStrings("mob.sweep.job.visited.dir", new String[]{"jobWorkingNamesDir"});
        configuration.setStrings("mob.sweep.job.files.dir", new String[]{"compactionFileDir"});
        configuration.setStrings("io.serializations", new String[]{JavaSerialization.class.getName()});
        configuration.set("mob.sweep.job.visited.dir", "compactionVisitedDir");
        configuration.setLong("hbase.mob.sweep.tool.compaction.start.date", System.currentTimeMillis() + 86400000L);
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(configuration, "1", (Abortable)new SweepJob.DummyMobAbortable());
        TableName lockName = MobUtils.getTableLockName((TableName)tn);
        String znode = ZKUtil.joinZNode((String)zkw.tableLockZNode, (String)lockName.getNameAsString());
        configuration.set("mob.sweep.job.id", "1");
        configuration.set("mob.sweep.job.table.node", znode);
        ServerName serverName = SweepJob.getCurrentServerName((Configuration)configuration);
        configuration.set("mob.sweep.job.servername", serverName.toString());
        TableLockManager tableLockManager = TableLockManager.createTableLockManager((Configuration)configuration, (ZooKeeperWatcher)zkw, (ServerName)serverName);
        TableLockManager.TableLock lock = tableLockManager.writeLock(lockName, "Run sweep tool");
        lock.acquire();
        try {
            GenericCounter counter = new GenericCounter();
            Reducer.Context ctx = (Reducer.Context)Mockito.mock(Reducer.Context.class);
            Mockito.when((Object)ctx.getConfiguration()).thenReturn((Object)configuration);
            Mockito.when((Object)ctx.getCounter((Enum)Matchers.any(SweepJob.SweepCounter.class))).thenReturn((Object)counter);
            Mockito.when((Object)ctx.nextKey()).thenReturn((Object)true).thenReturn((Object)false);
            Mockito.when((Object)ctx.getCurrentKey()).thenReturn((Object)new Text(mobFile1));
            byte[] refBytes = Bytes.toBytes((String)mobFile1);
            long valueLength = refBytes.length;
            byte[] newValue = Bytes.add((byte[])Bytes.toBytes((long)valueLength), (byte[])refBytes);
            KeyValue kv2 = new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)family), Bytes.toBytes((String)qf), 1L, KeyValue.Type.Put, newValue);
            ArrayList<KeyValue> list = new ArrayList<KeyValue>();
            list.add(kv2);
            Mockito.when((Object)ctx.getValues()).thenReturn(list);
            SweepReducer reducer = new SweepReducer();
            reducer.run(ctx);
        }
        finally {
            lock.release();
        }
        FileStatus[] filsStatuses2 = TEST_UTIL.getTestFileSystem().listStatus(mobFamilyPath);
        String mobFile2 = filsStatuses2[0].getPath().getName();
        Assert.assertEquals((long)1L, (long)filsStatuses2.length);
        Assert.assertEquals((Object)false, (Object)mobFile2.equalsIgnoreCase(mobFile1));
        String workingPath = configuration.get("mob.sweep.job.visited.dir");
        FileStatus[] statuses = TEST_UTIL.getTestFileSystem().listStatus(new Path(workingPath));
        TreeSet<String> files = new TreeSet<String>();
        for (FileStatus st : statuses) {
            files.addAll(this.getKeyFromSequenceFile(TEST_UTIL.getTestFileSystem(), st.getPath(), configuration));
        }
        Assert.assertEquals((long)1L, (long)files.size());
        Assert.assertEquals((Object)true, (Object)files.contains(mobFile1));
    }
}

