/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.mapreduce;

import java.io.IOException;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.mapreduce.Sweeper;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMobSweeper {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private String tableName;
    private static final String row = "row_";
    private static final String family = "family";
    private static final String column = "column";
    private static HTable table;
    private static Admin admin;
    private Random random = new Random();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compaction.min", 15);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compaction.max", 30);
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL.shutdownMiniMapReduceCluster();
    }

    @Before
    public void setUp() throws Exception {
        long tid = System.currentTimeMillis();
        this.tableName = "testSweeper" + tid;
        HTableDescriptor desc = new HTableDescriptor(this.tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(3L);
        hcd.setMaxVersions(4);
        desc.addFamily(hcd);
        admin = TEST_UTIL.getHBaseAdmin();
        admin.createTable(desc);
        table = new HTable(TEST_UTIL.getConfiguration(), this.tableName);
        table.setAutoFlush(false, false);
    }

    @After
    public void tearDown() throws Exception {
        admin.disableTable(TableName.valueOf((String)this.tableName));
        admin.deleteTable(TableName.valueOf((String)this.tableName));
        admin.close();
    }

    private Path getMobFamilyPath(Configuration conf, String tableNameStr, String familyName) {
        Path p = new Path(MobUtils.getMobRegionPath((Configuration)conf, (TableName)TableName.valueOf((String)tableNameStr)), familyName);
        return p;
    }

    private String mergeString(Set<String> set) {
        StringBuilder sb = new StringBuilder();
        for (String s : set) {
            sb.append(s);
        }
        return sb.toString();
    }

    private void generateMobTable(Admin admin, HTable table, String tableName, int count, int flushStep) throws IOException, InterruptedException {
        if (count <= 0 || flushStep <= 0) {
            return;
        }
        int index = 0;
        for (int i = 0; i < count; ++i) {
            byte[] mobVal = new byte[103424];
            this.random.nextBytes(mobVal);
            Put put = new Put(Bytes.toBytes((String)(row + i)));
            put.add(Bytes.toBytes((String)family), Bytes.toBytes((String)column), mobVal);
            table.put(put);
            if (index++ % flushStep != 0) continue;
            table.flushCommits();
            admin.flush(TableName.valueOf((String)tableName));
        }
        table.flushCommits();
        admin.flush(TableName.valueOf((String)tableName));
    }

    @Test
    public void testSweeper() throws Exception {
        int count = 10;
        this.generateMobTable(admin, table, this.tableName, count, 1);
        Path mobFamilyPath = this.getMobFamilyPath(TEST_UTIL.getConfiguration(), this.tableName, family);
        FileStatus[] fileStatuses = TEST_UTIL.getTestFileSystem().listStatus(mobFamilyPath);
        TreeSet<String> mobFilesSet = new TreeSet<String>();
        for (FileStatus status : fileStatuses) {
            mobFilesSet.add(status.getPath().getName());
        }
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        scan.setAttribute("hbase.mob.scan.ref.only", Bytes.toBytes((boolean)Boolean.TRUE));
        ResultScanner rs = table.getScanner(scan);
        TreeSet<String> mobFilesScanned = new TreeSet<String>();
        for (Result res : rs) {
            byte[] valueBytes = res.getValue(Bytes.toBytes((String)family), Bytes.toBytes((String)column));
            mobFilesScanned.add(Bytes.toString((byte[])valueBytes, (int)4, (int)(valueBytes.length - 4)));
        }
        Assert.assertEquals((long)10L, (long)mobFilesScanned.size());
        Assert.assertEquals((Object)this.mergeString(mobFilesSet), (Object)this.mergeString(mobFilesScanned));
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.mob.sweep.job.delay", 86400000L);
        String[] args = new String[]{this.tableName, family};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new Sweeper(), (String[])args));
        mobFamilyPath = this.getMobFamilyPath(TEST_UTIL.getConfiguration(), this.tableName, family);
        fileStatuses = TEST_UTIL.getTestFileSystem().listStatus(mobFamilyPath);
        mobFilesSet = new TreeSet();
        for (FileStatus status : fileStatuses) {
            mobFilesSet.add(status.getPath().getName());
        }
        Assert.assertEquals((long)10L, (long)mobFilesSet.size());
        scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        scan.setAttribute("hbase.mob.scan.ref.only", Bytes.toBytes((boolean)Boolean.TRUE));
        rs = table.getScanner(scan);
        TreeSet<String> mobFilesScannedAfterJob = new TreeSet<String>();
        for (Result res : rs) {
            byte[] valueBytes = res.getValue(Bytes.toBytes((String)family), Bytes.toBytes((String)column));
            mobFilesScannedAfterJob.add(Bytes.toString((byte[])valueBytes, (int)4, (int)(valueBytes.length - 4)));
        }
        Assert.assertEquals((long)10L, (long)mobFilesScannedAfterJob.size());
        fileStatuses = TEST_UTIL.getTestFileSystem().listStatus(mobFamilyPath);
        mobFilesSet = new TreeSet();
        for (FileStatus status : fileStatuses) {
            mobFilesSet.add(status.getPath().getName());
        }
        Assert.assertEquals((long)10L, (long)mobFilesSet.size());
        Assert.assertEquals((Object)true, (Object)((String)mobFilesScannedAfterJob.iterator().next()).equalsIgnoreCase(mobFilesSet.iterator().next()));
    }

    private void testCompactionDelaySweeperInternal(HTable table, String tableName) throws Exception {
        int count = 10;
        this.generateMobTable(admin, table, tableName, count, 1);
        Path mobFamilyPath = this.getMobFamilyPath(TEST_UTIL.getConfiguration(), tableName, family);
        FileStatus[] fileStatuses = TEST_UTIL.getTestFileSystem().listStatus(mobFamilyPath);
        TreeSet<String> mobFilesSet = new TreeSet<String>();
        for (FileStatus status : fileStatuses) {
            mobFilesSet.add(status.getPath().getName());
        }
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        scan.setAttribute("hbase.mob.scan.ref.only", Bytes.toBytes((boolean)Boolean.TRUE));
        ResultScanner rs = table.getScanner(scan);
        TreeSet<String> mobFilesScanned = new TreeSet<String>();
        for (Result res : rs) {
            byte[] valueBytes = res.getValue(Bytes.toBytes((String)family), Bytes.toBytes((String)column));
            mobFilesScanned.add(Bytes.toString((byte[])valueBytes, (int)4, (int)(valueBytes.length - 4)));
        }
        Assert.assertEquals((long)10L, (long)mobFilesScanned.size());
        Assert.assertEquals((Object)this.mergeString(mobFilesSet), (Object)this.mergeString(mobFilesScanned));
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.mob.sweep.job.delay", 0L);
        String[] args = new String[]{tableName, family};
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new Sweeper(), (String[])args));
        mobFamilyPath = this.getMobFamilyPath(TEST_UTIL.getConfiguration(), tableName, family);
        fileStatuses = TEST_UTIL.getTestFileSystem().listStatus(mobFamilyPath);
        mobFilesSet = new TreeSet();
        for (FileStatus status : fileStatuses) {
            mobFilesSet.add(status.getPath().getName());
        }
        Assert.assertEquals((long)1L, (long)mobFilesSet.size());
        scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        scan.setAttribute("hbase.mob.scan.ref.only", Bytes.toBytes((boolean)Boolean.TRUE));
        rs = table.getScanner(scan);
        TreeSet<String> mobFilesScannedAfterJob = new TreeSet<String>();
        for (Result res : rs) {
            byte[] valueBytes = res.getValue(Bytes.toBytes((String)family), Bytes.toBytes((String)column));
            mobFilesScannedAfterJob.add(Bytes.toString((byte[])valueBytes, (int)4, (int)(valueBytes.length - 4)));
        }
        Assert.assertEquals((long)1L, (long)mobFilesScannedAfterJob.size());
        fileStatuses = TEST_UTIL.getTestFileSystem().listStatus(mobFamilyPath);
        mobFilesSet = new TreeSet();
        for (FileStatus status : fileStatuses) {
            mobFilesSet.add(status.getPath().getName());
        }
        Assert.assertEquals((long)1L, (long)mobFilesSet.size());
        Assert.assertEquals((Object)true, (Object)((String)mobFilesScannedAfterJob.iterator().next()).equalsIgnoreCase(mobFilesSet.iterator().next()));
    }

    @Test
    public void testCompactionDelaySweeper() throws Exception {
        this.testCompactionDelaySweeperInternal(table, this.tableName);
    }

    @Test
    public void testCompactionDelaySweeperWithNamespace() throws Exception {
        NamespaceDescriptor namespaceDescriptor = NamespaceDescriptor.create((String)"ns").build();
        admin.createNamespace(namespaceDescriptor);
        String tableNameAsString = "ns:testSweeperWithNamespace";
        TableName tableName = TableName.valueOf((String)tableNameAsString);
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(family);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(3L);
        hcd.setMaxVersions(4);
        desc.addFamily(hcd);
        admin.createTable(desc);
        HTable table = new HTable(TEST_UTIL.getConfiguration(), tableName);
        table.setAutoFlush(false, false);
        this.testCompactionDelaySweeperInternal(table, tableNameAsString);
        table.close();
        admin.disableTable(tableName);
        admin.deleteTable(tableName);
        admin.deleteNamespace("ns");
    }
}

