/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestDeleteMobTable {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[] QF = Bytes.toBytes((String)"qualifier");
    private static Random random = new Random();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static byte[] generateMobValue(int size) {
        byte[] mobVal = new byte[size];
        random.nextBytes(mobVal);
        return mobVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteMobTable() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testDeleteMobTable");
        TableName tn = TableName.valueOf((byte[])tableName);
        HTableDescriptor htd = new HTableDescriptor(tn);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(0L);
        htd.addFamily(hcd);
        HTable table = null;
        try (HBaseAdmin admin = null;){
            admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
            admin.createTable(htd);
            table = new HTable(TEST_UTIL.getConfiguration(), tableName);
            byte[] value = TestDeleteMobTable.generateMobValue(10);
            byte[] row = Bytes.toBytes((String)"row");
            Put put = new Put(row);
            put.add(FAMILY, QF, EnvironmentEdgeManager.currentTime(), value);
            table.put(put);
            table.flushCommits();
            admin.flush(tableName);
            Assert.assertEquals((long)1L, (long)this.countMobFiles(tn, hcd.getNameAsString()));
            Assert.assertEquals((long)0L, (long)this.countArchiveMobFiles(tn, hcd.getNameAsString()));
            String fileName = this.assertHasOneMobRow(table, tn, hcd.getNameAsString());
            Assert.assertFalse((boolean)this.mobArchiveExist(tn, hcd.getNameAsString(), fileName));
            Assert.assertTrue((boolean)this.mobTableDirExist(tn));
            table.close();
            admin.disableTable(tn);
            admin.deleteTable(tn);
            Assert.assertFalse((boolean)admin.tableExists(tn));
            Assert.assertEquals((long)0L, (long)this.countMobFiles(tn, hcd.getNameAsString()));
            Assert.assertEquals((long)1L, (long)this.countArchiveMobFiles(tn, hcd.getNameAsString()));
            Assert.assertTrue((boolean)this.mobArchiveExist(tn, hcd.getNameAsString(), fileName));
            Assert.assertFalse((boolean)this.mobTableDirExist(tn));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteNonMobTable() throws Exception {
        byte[] tableName = Bytes.toBytes((String)"testDeleteNonMobTable");
        TableName tn = TableName.valueOf((byte[])tableName);
        HTableDescriptor htd = new HTableDescriptor(tn);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        htd.addFamily(hcd);
        HTable table = null;
        try (HBaseAdmin admin = null;){
            admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
            admin.createTable(htd);
            table = new HTable(TEST_UTIL.getConfiguration(), tableName);
            byte[] value = TestDeleteMobTable.generateMobValue(10);
            byte[] row = Bytes.toBytes((String)"row");
            Put put = new Put(row);
            put.add(FAMILY, QF, EnvironmentEdgeManager.currentTime(), value);
            table.put(put);
            table.flushCommits();
            admin.flush(tableName);
            table.close();
            Assert.assertEquals((long)0L, (long)this.countMobFiles(tn, hcd.getNameAsString()));
            Assert.assertEquals((long)0L, (long)this.countArchiveMobFiles(tn, hcd.getNameAsString()));
            Assert.assertFalse((boolean)this.mobTableDirExist(tn));
            admin.disableTable(tn);
            admin.deleteTable(tn);
            Assert.assertFalse((boolean)admin.tableExists(tn));
            Assert.assertEquals((long)0L, (long)this.countMobFiles(tn, hcd.getNameAsString()));
            Assert.assertEquals((long)0L, (long)this.countArchiveMobFiles(tn, hcd.getNameAsString()));
            Assert.assertFalse((boolean)this.mobTableDirExist(tn));
        }
    }

    private int countMobFiles(TableName tn, String familyName) throws IOException {
        Path mobFileDir;
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        if (fs.exists(mobFileDir = MobUtils.getMobFamilyPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)familyName))) {
            return fs.listStatus(mobFileDir).length;
        }
        return 0;
    }

    private int countArchiveMobFiles(TableName tn, String familyName) throws IOException {
        Path storePath;
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        if (fs.exists(storePath = HFileArchiveUtil.getStoreArchivePath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)MobUtils.getMobRegionInfo((TableName)tn).getEncodedName(), (String)familyName))) {
            return fs.listStatus(storePath).length;
        }
        return 0;
    }

    private boolean mobTableDirExist(TableName tn) throws IOException {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path tableDir = FSUtils.getTableDir((Path)MobUtils.getMobHome((Configuration)TEST_UTIL.getConfiguration()), (TableName)tn);
        return fs.exists(tableDir);
    }

    private boolean mobArchiveExist(TableName tn, String familyName, String fileName) throws IOException {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path storePath = HFileArchiveUtil.getStoreArchivePath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)MobUtils.getMobRegionInfo((TableName)tn).getEncodedName(), (String)familyName);
        return fs.exists(new Path(storePath, fileName));
    }

    private String assertHasOneMobRow(HTable table, TableName tn, String familyName) throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        ResultScanner rs = table.getScanner(scan);
        Result r = rs.next();
        Assert.assertNotNull((Object)r);
        byte[] value = r.getValue(FAMILY, QF);
        String fileName = Bytes.toString((byte[])value, (int)4, (int)(value.length - 4));
        Path filePath = new Path(MobUtils.getMobFamilyPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)tn, (String)familyName), fileName);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Assert.assertTrue((boolean)fs.exists(filePath));
        r = rs.next();
        Assert.assertNull((Object)r);
        return fileName;
    }
}

