/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMobStoreScanner {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] row1 = Bytes.toBytes((String)"row1");
    private static final byte[] family = Bytes.toBytes((String)"family");
    private static final byte[] qf1 = Bytes.toBytes((String)"qualifier1");
    private static final byte[] qf2 = Bytes.toBytes((String)"qualifier2");
    protected final byte[] qf3 = Bytes.toBytes((String)"qualifier3");
    private static HTable table;
    private static HBaseAdmin admin;
    private static HColumnDescriptor hcd;
    private static HTableDescriptor desc;
    private static Random random;
    private static long defaultThreshold;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hfile.format.version", 3);
        TEST_UTIL.getConfiguration().setInt("hbase.master.info.port", 0);
        TEST_UTIL.getConfiguration().setBoolean("hbase.regionserver.info.port.auto", true);
        TEST_UTIL.getConfiguration().setInt("hbase.client.keyvalue.maxsize", 0x6400000);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public void setUp(long threshold, String TN) throws Exception {
        desc = new HTableDescriptor(TableName.valueOf((String)TN));
        hcd = new HColumnDescriptor(family);
        hcd.setMobEnabled(true);
        hcd.setMobThreshold(threshold);
        hcd.setMaxVersions(4);
        desc.addFamily(hcd);
        admin = new HBaseAdmin(TEST_UTIL.getConfiguration());
        admin.createTable(desc);
        table = new HTable(TEST_UTIL.getConfiguration(), TN);
    }

    private static byte[] generateMobValue(int size) {
        byte[] mobVal = new byte[size];
        random.nextBytes(mobVal);
        return mobVal;
    }

    public void setScan(Scan scan, boolean reversed, boolean mobScanRaw) {
        scan.setReversed(reversed);
        scan.setMaxVersions(4);
        if (mobScanRaw) {
            scan.setAttribute("hbase.mob.scan.raw", Bytes.toBytes((boolean)Boolean.TRUE));
        }
    }

    @Test
    public void testMobStoreScanner() throws Exception {
        this.testGetFromFiles(false);
        this.testGetFromMemStore(false);
        this.testGetReferences(false);
        this.testMobThreshold(false);
        this.testGetFromArchive(false);
    }

    @Test
    public void testReversedMobStoreScanner() throws Exception {
        this.testGetFromFiles(true);
        this.testGetFromMemStore(true);
        this.testGetReferences(true);
        this.testMobThreshold(true);
        this.testGetFromArchive(true);
    }

    @Test(timeout=60000L)
    public void testGetMassive() throws Exception {
        String TN = "testGetMassive";
        this.setUp(defaultThreshold, TN);
        byte[] bigValue = new byte[0x1900000];
        Put put = new Put(row1);
        put.add(family, qf1, bigValue);
        put.add(family, qf2, bigValue);
        put.add(family, this.qf3, bigValue);
        table.put(put);
        Get g = new Get(row1);
        Result r = table.get(g);
    }

    public void testGetFromFiles(boolean reversed) throws Exception {
        String TN = "testGetFromFiles" + reversed;
        this.setUp(defaultThreshold, TN);
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        byte[] value = TestMobStoreScanner.generateMobValue((int)defaultThreshold + 1);
        Put put1 = new Put(row1);
        put1.add(family, qf1, ts3, value);
        put1.add(family, qf2, ts2, value);
        put1.add(family, this.qf3, ts1, value);
        table.put(put1);
        table.flushCommits();
        admin.flush(TN);
        Scan scan = new Scan();
        this.setScan(scan, reversed, false);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            List cells = res.listCells();
            for (Cell cell : cells) {
                Assert.assertEquals((Object)Bytes.toString((byte[])value), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell)));
                ++count;
            }
        }
        results.close();
        Assert.assertEquals((long)3L, (long)count);
    }

    public void testGetFromMemStore(boolean reversed) throws Exception {
        String TN = "testGetFromMemStore" + reversed;
        this.setUp(defaultThreshold, TN);
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        byte[] value = TestMobStoreScanner.generateMobValue((int)defaultThreshold + 1);
        Put put1 = new Put(row1);
        put1.add(family, qf1, ts3, value);
        put1.add(family, qf2, ts2, value);
        put1.add(family, this.qf3, ts1, value);
        table.put(put1);
        Scan scan = new Scan();
        this.setScan(scan, reversed, false);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            List cells = res.listCells();
            for (Cell cell : cells) {
                Assert.assertEquals((Object)Bytes.toString((byte[])value), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell)));
                ++count;
            }
        }
        results.close();
        Assert.assertEquals((long)3L, (long)count);
    }

    public void testGetReferences(boolean reversed) throws Exception {
        String TN = "testGetReferences" + reversed;
        this.setUp(defaultThreshold, TN);
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        byte[] value = TestMobStoreScanner.generateMobValue((int)defaultThreshold + 1);
        Put put1 = new Put(row1);
        put1.add(family, qf1, ts3, value);
        put1.add(family, qf2, ts2, value);
        put1.add(family, this.qf3, ts1, value);
        table.put(put1);
        table.flushCommits();
        admin.flush(TN);
        Scan scan = new Scan();
        this.setScan(scan, reversed, true);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            List cells = res.listCells();
            for (Cell cell : cells) {
                TestMobStoreScanner.assertIsMobReference(cell, row1, family, value, TN);
                ++count;
            }
        }
        results.close();
        Assert.assertEquals((long)3L, (long)count);
    }

    public void testMobThreshold(boolean reversed) throws Exception {
        String TN = "testMobThreshold" + reversed;
        this.setUp(defaultThreshold, TN);
        byte[] valueLess = TestMobStoreScanner.generateMobValue((int)defaultThreshold - 1);
        byte[] valueEqual = TestMobStoreScanner.generateMobValue((int)defaultThreshold);
        byte[] valueGreater = TestMobStoreScanner.generateMobValue((int)defaultThreshold + 1);
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        Put put1 = new Put(row1);
        put1.add(family, qf1, ts3, valueLess);
        put1.add(family, qf2, ts2, valueEqual);
        put1.add(family, this.qf3, ts1, valueGreater);
        table.put(put1);
        table.flushCommits();
        admin.flush(TN);
        Scan scan = new Scan();
        this.setScan(scan, reversed, true);
        Cell cellLess = null;
        Cell cellEqual = null;
        Cell cellGreater = null;
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            List cells = res.listCells();
            for (Cell cell : cells) {
                String qf = Bytes.toString((byte[])CellUtil.cloneQualifier((Cell)cell));
                if (qf.equals(Bytes.toString((byte[])qf1))) {
                    cellLess = cell;
                }
                if (qf.equals(Bytes.toString((byte[])qf2))) {
                    cellEqual = cell;
                }
                if (qf.equals(Bytes.toString((byte[])this.qf3))) {
                    cellGreater = cell;
                }
                ++count;
            }
        }
        Assert.assertEquals((long)3L, (long)count);
        TestMobStoreScanner.assertNotMobReference(cellLess, row1, family, valueLess);
        TestMobStoreScanner.assertNotMobReference(cellEqual, row1, family, valueEqual);
        TestMobStoreScanner.assertIsMobReference(cellGreater, row1, family, valueGreater, TN);
        results.close();
    }

    public void testGetFromArchive(boolean reversed) throws Exception {
        String TN = "testGetFromArchive" + reversed;
        this.setUp(defaultThreshold, TN);
        long ts1 = System.currentTimeMillis();
        long ts2 = ts1 + 1L;
        long ts3 = ts1 + 2L;
        byte[] value = TestMobStoreScanner.generateMobValue((int)defaultThreshold + 1);
        Put put1 = new Put(row1);
        put1.add(family, qf1, ts3, value);
        put1.add(family, qf2, ts2, value);
        put1.add(family, this.qf3, ts1, value);
        table.put(put1);
        table.flushCommits();
        admin.flush(TN);
        Path mobFamilyPath = new Path(MobUtils.getMobRegionPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)TableName.valueOf((String)TN)), hcd.getNameAsString());
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        FileStatus[] files = fs.listStatus(mobFamilyPath);
        Path rootDir = FSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration());
        Path tableDir = FSUtils.getTableDir((Path)rootDir, (TableName)TableName.valueOf((String)TN));
        HRegionInfo regionInfo = MobUtils.getMobRegionInfo((TableName)TableName.valueOf((String)TN));
        Path storeArchiveDir = HFileArchiveUtil.getStoreArchivePath((Configuration)TEST_UTIL.getConfiguration(), (HRegionInfo)regionInfo, (Path)tableDir, (byte[])family);
        fs.mkdirs(storeArchiveDir);
        int fileCount = 0;
        for (FileStatus file : files) {
            ++fileCount;
            Path filePath = file.getPath();
            Path src = new Path(mobFamilyPath, filePath.getName());
            Path dst = new Path(storeArchiveDir, filePath.getName());
            fs.rename(src, dst);
        }
        FileStatus[] files1 = fs.listStatus(mobFamilyPath);
        Assert.assertEquals((long)0L, (long)files1.length);
        FileStatus[] files2 = fs.listStatus(storeArchiveDir);
        Assert.assertEquals((long)fileCount, (long)files2.length);
        Scan scan = new Scan();
        this.setScan(scan, reversed, false);
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            List cells = res.listCells();
            for (Cell cell : cells) {
                Assert.assertEquals((Object)Bytes.toString((byte[])value), (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell)));
                ++count;
            }
        }
        results.close();
        Assert.assertEquals((long)3L, (long)count);
    }

    private static void assertNotMobReference(Cell cell, byte[] row, byte[] family, byte[] value) throws IOException {
        Assert.assertEquals((Object)Bytes.toString((byte[])row), (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)cell)));
        Assert.assertEquals((Object)Bytes.toString((byte[])family), (Object)Bytes.toString((byte[])CellUtil.cloneFamily((Cell)cell)));
        Assert.assertTrue((boolean)Bytes.toString((byte[])value).equals(Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell))));
    }

    private static void assertIsMobReference(Cell cell, byte[] row, byte[] family, byte[] value, String TN) throws IOException {
        Assert.assertEquals((Object)Bytes.toString((byte[])row), (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)cell)));
        Assert.assertEquals((Object)Bytes.toString((byte[])family), (Object)Bytes.toString((byte[])CellUtil.cloneFamily((Cell)cell)));
        Assert.assertFalse((boolean)Bytes.toString((byte[])value).equals(Bytes.toString((byte[])CellUtil.cloneValue((Cell)cell))));
        byte[] referenceValue = CellUtil.cloneValue((Cell)cell);
        String fileName = Bytes.toString((byte[])referenceValue, (int)4, (int)(referenceValue.length - 4));
        int valLen = Bytes.toInt((byte[])referenceValue, (int)0, (int)4);
        Assert.assertEquals((long)value.length, (long)valLen);
        Path mobFamilyPath = new Path(MobUtils.getMobRegionPath((Configuration)TEST_UTIL.getConfiguration(), (TableName)TableName.valueOf((String)TN)), hcd.getNameAsString());
        Path targetPath = new Path(mobFamilyPath, fileName);
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Assert.assertTrue((boolean)fs.exists(targetPath));
    }

    static {
        random = new Random();
        defaultThreshold = 10L;
    }
}

