/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.regionserver.RegionReplicaReplicationEndpoint;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.log4j.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestRegionReplicaReplicationEndpoint {
    private static final Log LOG = LogFactory.getLog(TestRegionReplicaReplicationEndpoint.class);
    private static final int NB_SERVERS = 2;
    private static final HBaseTestingUtility HTU;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = HTU.getConfiguration();
        conf.setFloat("hbase.regionserver.logroll.multiplier", 3.0E-4f);
        conf.setInt("replication.source.size.capacity", 10240);
        conf.setLong("replication.source.sleepforretries", 100L);
        conf.setInt("hbase.regionserver.maxlogs", 10);
        conf.setLong("hbase.master.logcleaner.ttl", 10L);
        conf.setInt("zookeeper.recovery.retry", 1);
        conf.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf.setBoolean("hbase.replication", true);
        conf.setBoolean("hbase.region.replica.replication.enabled", true);
        conf.setLong("hbase.server.thread.wakefrequency", 100L);
        conf.setInt("replication.stats.thread.period.seconds", 5);
        conf.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf.setInt("hbase.client.retries.number", 5);
        conf.setInt("hbase.client.serverside.retries.multiplier", 1);
        HTU.startMiniCluster(2);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HTU.shutdownMiniCluster();
    }

    @Test
    public void testRegionReplicaReplicationPeerIsCreated() throws IOException, ReplicationException {
        String peerId;
        ReplicationAdmin admin = new ReplicationAdmin(HTU.getConfiguration());
        if (admin.getPeerConfig(peerId = "region_replica_replication") != null) {
            admin.removePeer(peerId);
        }
        HTableDescriptor htd = HTU.createTableDescriptor("testReplicationPeerIsCreated_no_region_replicas");
        HTU.getHBaseAdmin().createTable(htd);
        ReplicationPeerConfig peerConfig = admin.getPeerConfig(peerId);
        Assert.assertNull((Object)peerConfig);
        htd = HTU.createTableDescriptor("testReplicationPeerIsCreated");
        htd.setRegionReplication(2);
        HTU.getHBaseAdmin().createTable(htd);
        peerConfig = admin.getPeerConfig(peerId);
        Assert.assertNotNull((Object)peerConfig);
        Assert.assertEquals((Object)peerConfig.getClusterKey(), (Object)ZKUtil.getZooKeeperClusterKey((Configuration)HTU.getConfiguration()));
        Assert.assertEquals((Object)peerConfig.getReplicationEndpointImpl(), (Object)RegionReplicaReplicationEndpoint.class.getName());
        admin.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionReplicaReplication(int regionReplication) throws Exception {
        TableName tableName = TableName.valueOf((String)("testRegionReplicaReplicationWithReplicas_" + regionReplication));
        HTableDescriptor htd = HTU.createTableDescriptor(tableName.toString());
        htd.setRegionReplication(regionReplication);
        HTU.getHBaseAdmin().createTable(htd);
        TableName tableNameNoReplicas = TableName.valueOf((String)"testRegionReplicaReplicationWithReplicas_NO_REPLICAS");
        HTU.deleteTableIfAny(tableNameNoReplicas);
        HTU.createTable(tableNameNoReplicas, HBaseTestingUtility.fam1);
        Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        Table table = connection.getTable(tableName);
        Table tableNoReplicas = connection.getTable(tableNameNoReplicas);
        try {
            HTU.loadNumericRows(tableNoReplicas, HBaseTestingUtility.fam1, 6000, 7000);
            HTU.loadNumericRows(table, HBaseTestingUtility.fam1, 0, 1000);
            this.verifyReplication(tableName, regionReplication, 0, 1000);
        }
        finally {
            table.close();
            tableNoReplicas.close();
            HTU.deleteTableIfAny(tableNameNoReplicas);
            connection.close();
        }
    }

    private void verifyReplication(TableName tableName, int regionReplication, int startRow, int endRow) throws Exception {
        this.verifyReplication(tableName, regionReplication, startRow, endRow, true);
    }

    private void verifyReplication(TableName tableName, int regionReplication, final int startRow, final int endRow, final boolean present) throws Exception {
        HRegion[] regions = new HRegion[regionReplication];
        for (int i = 0; i < 2; ++i) {
            HRegionServer rs = HTU.getMiniHBaseCluster().getRegionServer(i);
            List onlineRegions = rs.getOnlineRegions(tableName);
            Iterator i$ = onlineRegions.iterator();
            while (i$.hasNext()) {
                HRegion region;
                regions[region.getRegionInfo().getReplicaId()] = region = (HRegion)i$.next();
            }
        }
        for (HRegion region : regions) {
            Assert.assertNotNull((Object)region);
        }
        for (int i = 1; i < regionReplication; ++i) {
            final HRegion region = regions[i];
            Waiter.waitFor((Configuration)HTU.getConfiguration(), (long)90000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    LOG.info((Object)("verifying replication for region replica:" + region.getRegionInfo()));
                    try {
                        HTU.verifyNumericRows(region, HBaseTestingUtility.fam1, startRow, endRow, present);
                    }
                    catch (Throwable ex) {
                        LOG.warn((Object)("Verification from secondary region is not complete yet. Got:" + ex + " " + ex.getMessage()));
                        return false;
                    }
                    return true;
                }
            });
        }
    }

    @Test(timeout=240000L)
    public void testRegionReplicaReplicationWith2Replicas() throws Exception {
        this.testRegionReplicaReplication(2);
    }

    @Test(timeout=240000L)
    public void testRegionReplicaReplicationWith3Replicas() throws Exception {
        this.testRegionReplicaReplication(3);
    }

    @Test(timeout=240000L)
    public void testRegionReplicaReplicationWith10Replicas() throws Exception {
        this.testRegionReplicaReplication(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=240000L)
    public void testRegionReplicaWithoutMemstoreReplication() throws Exception {
        int regionReplication = 3;
        TableName tableName = TableName.valueOf((String)"testRegionReplicaWithoutMemstoreReplication");
        HTableDescriptor htd = HTU.createTableDescriptor(tableName.toString());
        htd.setRegionReplication(regionReplication);
        htd.setRegionMemstoreReplication(false);
        HTU.getHBaseAdmin().createTable(htd);
        Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        Table table = connection.getTable(tableName);
        try {
            int STEP = 100;
            for (int i = 0; i < 3; ++i) {
                int startRow = i * 100;
                int endRow = (i + 1) * 100;
                LOG.info((Object)("Writing data from " + startRow + " to " + endRow));
                HTU.loadNumericRows(table, HBaseTestingUtility.fam1, startRow, endRow);
                this.verifyReplication(tableName, regionReplication, startRow, endRow, false);
                LOG.info((Object)"flushing table");
                HTU.flush(tableName);
                this.verifyReplication(tableName, regionReplication, 0, endRow, true);
            }
        }
        finally {
            table.close();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=240000L)
    public void testRegionReplicaReplicationForFlushAndCompaction() throws Exception {
        int regionReplication = 3;
        TableName tableName = TableName.valueOf((String)"testRegionReplicaReplicationForFlushAndCompaction");
        HTableDescriptor htd = HTU.createTableDescriptor(tableName.toString());
        htd.setRegionReplication(regionReplication);
        HTU.getHBaseAdmin().createTable(htd);
        Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        Table table = connection.getTable(tableName);
        try {
            for (int i = 0; i < 6000; i += 1000) {
                LOG.info((Object)("Writing data from " + i + " to " + (i + 1000)));
                HTU.loadNumericRows(table, HBaseTestingUtility.fam1, i, i + 1000);
                LOG.info((Object)"flushing table");
                HTU.flush(tableName);
                LOG.info((Object)"compacting table");
                HTU.compact(tableName, false);
            }
            this.verifyReplication(tableName, regionReplication, 0, 1000);
        }
        finally {
            table.close();
            connection.close();
        }
    }

    @Test(timeout=240000L)
    public void testRegionReplicaReplicationIgnoresDisabledTables() throws Exception {
        this.testRegionReplicaReplicationIgnoresDisabledTables(false);
    }

    @Test(timeout=240000L)
    public void testRegionReplicaReplicationIgnoresDroppedTables() throws Exception {
        this.testRegionReplicaReplicationIgnoresDisabledTables(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionReplicaReplicationIgnoresDisabledTables(boolean dropTable) throws Exception {
        TableName tableName = TableName.valueOf((String)("testRegionReplicaReplicationIgnoresDisabledTables" + dropTable));
        HTableDescriptor htd = HTU.createTableDescriptor(tableName.toString());
        int regionReplication = 3;
        htd.setRegionReplication(regionReplication);
        HTU.deleteTableIfAny(tableName);
        HTU.getHBaseAdmin().createTable(htd);
        TableName toBeDisabledTable = TableName.valueOf((String)(dropTable ? "droppedTable" : "disabledTable"));
        HTU.deleteTableIfAny(toBeDisabledTable);
        htd = HTU.createTableDescriptor(toBeDisabledTable.toString());
        htd.setRegionReplication(regionReplication);
        HTU.getHBaseAdmin().createTable(htd);
        ReplicationAdmin admin = new ReplicationAdmin(HTU.getConfiguration());
        admin.disablePeer(ServerRegionReplicaUtil.getReplicationPeerId());
        Connection connection = ConnectionFactory.createConnection((Configuration)HTU.getConfiguration());
        Table table = connection.getTable(tableName);
        Table tableToBeDisabled = connection.getTable(toBeDisabledTable);
        HTU.loadNumericRows(tableToBeDisabled, HBaseTestingUtility.fam1, 6000, 7000);
        AtomicLong skippedEdits = new AtomicLong();
        RegionReplicaReplicationEndpoint.RegionReplicaOutputSink sink = (RegionReplicaReplicationEndpoint.RegionReplicaOutputSink)Mockito.mock(RegionReplicaReplicationEndpoint.RegionReplicaOutputSink.class);
        Mockito.when((Object)sink.getSkippedEditsCounter()).thenReturn((Object)skippedEdits);
        RegionReplicaReplicationEndpoint.RegionReplicaSinkWriter sinkWriter = new RegionReplicaReplicationEndpoint.RegionReplicaSinkWriter(sink, (ClusterConnection)connection, Executors.newSingleThreadExecutor(), Integer.MAX_VALUE);
        RegionLocator rl = connection.getRegionLocator(toBeDisabledTable);
        HRegionLocation hrl = rl.getRegionLocation(HConstants.EMPTY_BYTE_ARRAY);
        byte[] encodedRegionName = hrl.getRegionInfo().getEncodedNameAsBytes();
        WAL.Entry entry = new WAL.Entry(new WALKey(encodedRegionName, toBeDisabledTable, 1L), new WALEdit());
        HTU.getHBaseAdmin().disableTable(toBeDisabledTable);
        if (dropTable) {
            HTU.getHBaseAdmin().deleteTable(toBeDisabledTable);
        }
        sinkWriter.append(toBeDisabledTable, encodedRegionName, HConstants.EMPTY_BYTE_ARRAY, (List)Lists.newArrayList((Object[])new WAL.Entry[]{entry, entry}));
        Assert.assertEquals((long)2L, (long)skippedEdits.get());
        try {
            HTU.loadNumericRows(table, HBaseTestingUtility.fam1, 0, 1000);
            admin.enablePeer(ServerRegionReplicaUtil.getReplicationPeerId());
            this.verifyReplication(tableName, regionReplication, 0, 1000);
        }
        finally {
            admin.close();
            table.close();
            rl.close();
            tableToBeDisabled.close();
            HTU.deleteTableIfAny(toBeDisabledTable);
            connection.close();
        }
    }

    static {
        ((Log4JLogger)RpcRetryingCaller.LOG).getLogger().setLevel(Level.ALL);
        HTU = new HBaseTestingUtility();
    }
}

