/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Assert;

public class MobSnapshotTestingUtils {
    public static void createMobTable(HBaseTestingUtility util, TableName tableName, int regionReplication, byte[] ... families) throws IOException, InterruptedException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        htd.setRegionReplication(regionReplication);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            hcd.setMobEnabled(true);
            hcd.setMobThreshold(0L);
            htd.addFamily(hcd);
        }
        byte[][] splitKeys = SnapshotTestingUtils.getSplitKeys();
        util.getHBaseAdmin().createTable(htd, splitKeys);
        SnapshotTestingUtils.waitForTableToBeOnline(util, tableName);
        Assert.assertEquals((long)((splitKeys.length + 1) * regionReplication), (long)util.getHBaseAdmin().getTableRegions(tableName).size());
    }

    public static HTable createMobTable(HBaseTestingUtility util, TableName tableName, byte[] ... families) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (byte[] family : families) {
            HColumnDescriptor hcd = new HColumnDescriptor(family);
            hcd.setBloomFilterType(BloomType.NONE);
            hcd.setMobEnabled(true);
            hcd.setMobThreshold(0L);
            htd.addFamily(hcd);
        }
        util.getHBaseAdmin().createTable(htd);
        util.waitUntilAllRegionsAssigned(htd.getTableName());
        return new HTable(util.getConfiguration(), htd.getTableName());
    }

    public static int countMobRows(HTable table) throws IOException {
        Scan scan = new Scan();
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            ++count;
            List cells = res.listCells();
            for (Cell cell : cells) {
                Assert.assertTrue((CellUtil.cloneValue((Cell)cell).length > 0 ? 1 : 0) != 0);
            }
        }
        results.close();
        return count;
    }

    public static int countMobRows(HTable table, byte[] ... families) throws IOException {
        Scan scan = new Scan();
        for (byte[] family : families) {
            scan.addFamily(family);
        }
        ResultScanner results = table.getScanner(scan);
        int count = 0;
        for (Result res : results) {
            ++count;
            List cells = res.listCells();
            for (Cell cell : cells) {
                Assert.assertTrue((CellUtil.cloneValue((Cell)cell).length > 0 ? 1 : 0) != 0);
            }
        }
        results.close();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verifyMobRowCount(HBaseTestingUtility util, TableName tableName, long expectedRows) throws IOException {
        try (HTable table = new HTable(util.getConfiguration(), tableName);){
            Assert.assertEquals((long)expectedRows, (long)MobSnapshotTestingUtils.countMobRows(table));
        }
    }

    public static class SnapshotMock {
        private static final String TEST_FAMILY = "cf";
        public static final int TEST_NUM_REGIONS = 4;
        private final Configuration conf;
        private final FileSystem fs;
        private final Path rootDir;

        public SnapshotMock(Configuration conf, FileSystem fs, Path rootDir) {
            this.fs = fs;
            this.conf = conf;
            this.rootDir = rootDir;
        }

        public SnapshotBuilder createSnapshotV1(String snapshotName) throws IOException {
            return this.createSnapshot(snapshotName, 0);
        }

        public SnapshotBuilder createSnapshotV2(String snapshotName) throws IOException {
            return this.createSnapshot(snapshotName, 2);
        }

        private SnapshotBuilder createSnapshot(String snapshotName, int version) throws IOException {
            HTableDescriptor htd = this.createHtd(snapshotName);
            RegionData[] regions = this.createTable(htd, 4);
            HBaseProtos.SnapshotDescription desc = HBaseProtos.SnapshotDescription.newBuilder().setTable(htd.getNameAsString()).setName(snapshotName).setVersion(version).build();
            Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((HBaseProtos.SnapshotDescription)desc, (Path)this.rootDir);
            SnapshotDescriptionUtils.writeSnapshotInfo((HBaseProtos.SnapshotDescription)desc, (Path)workingDir, (FileSystem)this.fs);
            return new SnapshotBuilder(this.conf, this.fs, this.rootDir, htd, desc, regions);
        }

        public HTableDescriptor createHtd(String tableName) {
            HTableDescriptor htd = new HTableDescriptor(tableName);
            HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
            hcd.setMobEnabled(true);
            hcd.setMobThreshold(0L);
            htd.addFamily(hcd);
            return htd;
        }

        private RegionData[] createTable(HTableDescriptor htd, int nregions) throws IOException {
            Path tableDir = FSUtils.getTableDir((Path)this.rootDir, (TableName)htd.getTableName());
            new FSTableDescriptors(this.conf).createTableDescriptorForTableDirectory(tableDir, htd, false);
            Assert.assertTrue((nregions % 2 == 0 ? 1 : 0) != 0);
            RegionData[] regions = new RegionData[nregions];
            for (int i = 0; i < regions.length; i += 2) {
                int j;
                byte[] startKey = Bytes.toBytes((int)(0 + i * 2));
                byte[] endKey = Bytes.toBytes((int)(1 + i * 2));
                HRegionInfo hri = new HRegionInfo(htd.getTableName(), startKey, endKey);
                HRegionFileSystem rfs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)tableDir, (HRegionInfo)hri);
                regions[i] = new RegionData(tableDir, hri, 3);
                for (j = 0; j < regions[i].files.length; ++j) {
                    Path storeFile = this.createStoreFile(rfs.createTempName());
                    regions[i].files[j] = rfs.commitStoreFile(TEST_FAMILY, storeFile);
                }
                startKey = Bytes.toBytes((int)(2 + i * 2));
                endKey = Bytes.toBytes((int)(3 + i * 2));
                hri = new HRegionInfo(htd.getTableName());
                rfs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)tableDir, (HRegionInfo)hri);
                regions[i + 1] = new RegionData(tableDir, hri, regions[i].files.length);
                for (j = 0; j < regions[i].files.length; ++j) {
                    String refName = regions[i].files[j].getName() + '.' + regions[i].hri.getEncodedName();
                    Path refFile = this.createStoreFile(new Path(this.rootDir, refName));
                    regions[i + 1].files[j] = rfs.commitStoreFile(TEST_FAMILY, refFile);
                }
            }
            return regions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Path createStoreFile(Path storeFile) throws IOException {
            try (FSDataOutputStream out = this.fs.create(storeFile);){
                out.write(Bytes.toBytes((String)storeFile.toString()));
            }
            return storeFile;
        }

        public static class SnapshotBuilder {
            private final RegionData[] tableRegions;
            private final HBaseProtos.SnapshotDescription desc;
            private final HTableDescriptor htd;
            private final Configuration conf;
            private final FileSystem fs;
            private final Path rootDir;
            private Path snapshotDir;
            private int snapshotted = 0;

            public SnapshotBuilder(Configuration conf, FileSystem fs, Path rootDir, HTableDescriptor htd, HBaseProtos.SnapshotDescription desc, RegionData[] tableRegions) throws IOException {
                this.fs = fs;
                this.conf = conf;
                this.rootDir = rootDir;
                this.htd = htd;
                this.desc = desc;
                this.tableRegions = tableRegions;
                this.snapshotDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((HBaseProtos.SnapshotDescription)desc, (Path)rootDir);
                new FSTableDescriptors(conf).createTableDescriptorForTableDirectory(this.snapshotDir, htd, false);
            }

            public HTableDescriptor getTableDescriptor() {
                return this.htd;
            }

            public HBaseProtos.SnapshotDescription getSnapshotDescription() {
                return this.desc;
            }

            public Path getSnapshotsDir() {
                return this.snapshotDir;
            }

            public Path[] addRegion() throws IOException {
                return this.addRegion(this.desc);
            }

            public Path[] addRegionV1() throws IOException {
                return this.addRegion(this.desc.toBuilder().setVersion(0).build());
            }

            public Path[] addRegionV2() throws IOException {
                return this.addRegion(this.desc.toBuilder().setVersion(2).build());
            }

            private Path[] addRegion(HBaseProtos.SnapshotDescription desc) throws IOException {
                if (this.snapshotted == this.tableRegions.length) {
                    throw new UnsupportedOperationException("No more regions in the table");
                }
                RegionData regionData = this.tableRegions[this.snapshotted++];
                ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(desc.getName());
                SnapshotManifest manifest = SnapshotManifest.create((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (HBaseProtos.SnapshotDescription)desc, (ForeignExceptionSnare)monitor);
                manifest.addRegion(regionData.tableDir, regionData.hri);
                return regionData.files;
            }

            public Path commit() throws IOException {
                ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(this.desc.getName());
                SnapshotManifest manifest = SnapshotManifest.create((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (HBaseProtos.SnapshotDescription)this.desc, (ForeignExceptionSnare)monitor);
                manifest.addTableDescriptor(this.htd);
                manifest.consolidate();
                SnapshotDescriptionUtils.completeSnapshot((HBaseProtos.SnapshotDescription)this.desc, (Path)this.rootDir, (Path)this.snapshotDir, (FileSystem)this.fs);
                this.snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((HBaseProtos.SnapshotDescription)this.desc, (Path)this.rootDir);
                return this.snapshotDir;
            }
        }

        static class RegionData {
            public HRegionInfo hri;
            public Path tableDir;
            public Path[] files;

            public RegionData(Path tableDir, HRegionInfo hri, int nfiles) {
                this.tableDir = tableDir;
                this.hri = hri;
                this.files = new Path[nfiles];
            }
        }
    }
}

