/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ExportSnapshot;
import org.apache.hadoop.hbase.snapshot.MobSnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMobExportSnapshot {
    private final Log LOG = LogFactory.getLog(this.getClass());
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private byte[] emptySnapshotName;
    private byte[] snapshotName;
    private int tableNumFiles;
    private TableName tableName;
    private Admin admin;

    public static void setUpBaseConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setInt("hbase.regionserver.msginterval", 100);
        conf.setInt("hbase.client.pause", 250);
        conf.setInt("hbase.client.retries.number", 6);
        conf.setBoolean("hbase.master.enabletable.roundrobin", true);
        conf.setInt("mapreduce.map.maxattempts", 10);
        conf.setInt("hbase.mob.file.cache.size", 0);
        conf.setInt("hfile.format.version", 3);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestMobExportSnapshot.setUpBaseConf(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniMapReduceCluster();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
        long tid = System.currentTimeMillis();
        this.tableName = TableName.valueOf((String)("testtb-" + tid));
        this.snapshotName = Bytes.toBytes((String)("snaptb0-" + tid));
        this.emptySnapshotName = Bytes.toBytes((String)("emptySnaptb0-" + tid));
        MobSnapshotTestingUtils.createMobTable(TEST_UTIL, this.tableName, 1, (byte[][])new byte[][]{FAMILY});
        this.admin.snapshot(this.emptySnapshotName, this.tableName);
        SnapshotTestingUtils.loadData(TEST_UTIL, this.tableName, 50, (byte[][])new byte[][]{FAMILY});
        this.tableNumFiles = this.admin.getTableRegions(this.tableName).size();
        this.admin.snapshot(this.snapshotName, this.tableName);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.deleteTable(this.tableName);
        SnapshotTestingUtils.deleteAllSnapshots((Admin)TEST_UTIL.getHBaseAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(TEST_UTIL);
    }

    @Test
    public void testBalanceSplit() throws Exception {
        ArrayList<Pair> files = new ArrayList<Pair>();
        for (long i = 0L; i <= 20L; ++i) {
            SnapshotProtos.SnapshotFileInfo fileInfo = SnapshotProtos.SnapshotFileInfo.newBuilder().setType(SnapshotProtos.SnapshotFileInfo.Type.HFILE).setHfile("file-" + i).build();
            files.add(new Pair((Object)fileInfo, (Object)i));
        }
        List splits = ExportSnapshot.getBalancedSplits(files, (int)5);
        Assert.assertEquals((long)5L, (long)splits.size());
        String[] split0 = new String[]{"file-20", "file-11", "file-10", "file-1", "file-0"};
        this.verifyBalanceSplit((List)splits.get(0), split0, 42L);
        String[] split1 = new String[]{"file-19", "file-12", "file-9", "file-2"};
        this.verifyBalanceSplit((List)splits.get(1), split1, 42L);
        String[] split2 = new String[]{"file-18", "file-13", "file-8", "file-3"};
        this.verifyBalanceSplit((List)splits.get(2), split2, 42L);
        String[] split3 = new String[]{"file-17", "file-14", "file-7", "file-4"};
        this.verifyBalanceSplit((List)splits.get(3), split3, 42L);
        String[] split4 = new String[]{"file-16", "file-15", "file-6", "file-5"};
        this.verifyBalanceSplit((List)splits.get(4), split4, 42L);
    }

    private void verifyBalanceSplit(List<Pair<SnapshotProtos.SnapshotFileInfo, Long>> split, String[] expected, long expectedSize) {
        Assert.assertEquals((long)expected.length, (long)split.size());
        long totalSize = 0L;
        for (int i = 0; i < expected.length; ++i) {
            Pair<SnapshotProtos.SnapshotFileInfo, Long> fileInfo = split.get(i);
            Assert.assertEquals((Object)expected[i], (Object)((SnapshotProtos.SnapshotFileInfo)fileInfo.getFirst()).getHfile());
            totalSize += ((Long)fileInfo.getSecond()).longValue();
        }
        Assert.assertEquals((long)expectedSize, (long)totalSize);
    }

    @Test
    public void testExportFileSystemState() throws Exception {
        this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles);
    }

    @Test
    public void testExportFileSystemStateWithSkipTmp() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("snapshot.export.skip.tmp", true);
        this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles);
    }

    @Test
    public void testEmptyExportFileSystemState() throws Exception {
        this.testExportFileSystemState(this.tableName, this.emptySnapshotName, this.emptySnapshotName, 0);
    }

    @Test
    public void testConsecutiveExports() throws Exception {
        Path copyDir = this.getLocalDestinationDir();
        this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles, copyDir, false);
        this.testExportFileSystemState(this.tableName, this.snapshotName, this.snapshotName, this.tableNumFiles, copyDir, true);
        this.removeExportDir(copyDir);
    }

    @Test
    public void testExportWithTargetName() throws Exception {
        byte[] targetName = Bytes.toBytes((String)"testExportWithTargetName");
        this.testExportFileSystemState(this.tableName, this.snapshotName, targetName, this.tableNumFiles);
    }

    @Test
    public void testSnapshotWithRefsExportFileSystemState() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        Path rootDir = TEST_UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        FileSystem fs = TEST_UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(TEST_UTIL.getConfiguration(), fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2("tableWithRefsV1");
        this.testSnapshotWithRefsExportFileSystemState(builder);
        snapshotMock = new SnapshotTestingUtils.SnapshotMock(TEST_UTIL.getConfiguration(), fs, rootDir);
        builder = snapshotMock.createSnapshotV2("tableWithRefsV2");
        this.testSnapshotWithRefsExportFileSystemState(builder);
    }

    private void testSnapshotWithRefsExportFileSystemState(SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder) throws Exception {
        Path[] r1Files = builder.addRegion();
        Path[] r2Files = builder.addRegion();
        builder.commit();
        int snapshotFilesCount = r1Files.length + r2Files.length;
        byte[] snapshotName = Bytes.toBytes((String)builder.getSnapshotDescription().getName());
        TableName tableName = builder.getTableDescriptor().getTableName();
        this.testExportFileSystemState(tableName, snapshotName, snapshotName, snapshotFilesCount);
    }

    private void testExportFileSystemState(TableName tableName, byte[] snapshotName, byte[] targetName, int filesExpected) throws Exception {
        Path copyDir = this.getHdfsDestinationDir();
        this.testExportFileSystemState(tableName, snapshotName, targetName, filesExpected, copyDir, false);
        this.removeExportDir(copyDir);
    }

    private void testExportFileSystemState(TableName tableName, byte[] snapshotName, byte[] targetName, int filesExpected, Path copyDir, boolean overwrite) throws Exception {
        URI hdfsUri = FileSystem.get((Configuration)TEST_UTIL.getConfiguration()).getUri();
        FileSystem fs = FileSystem.get((URI)copyDir.toUri(), (Configuration)new Configuration());
        copyDir = copyDir.makeQualified(fs);
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("-snapshot");
        opts.add(Bytes.toString((byte[])snapshotName));
        opts.add("-copy-to");
        opts.add(copyDir.toString());
        if (targetName != snapshotName) {
            opts.add("-target");
            opts.add(Bytes.toString((byte[])targetName));
        }
        if (overwrite) {
            opts.add("-overwrite");
        }
        int res = ExportSnapshot.innerMain((Configuration)TEST_UTIL.getConfiguration(), (String[])opts.toArray(new String[opts.size()]));
        Assert.assertEquals((long)0L, (long)res);
        FileStatus[] rootFiles = fs.listStatus(copyDir);
        Assert.assertEquals((long)(filesExpected > 0 ? 2L : 1L), (long)rootFiles.length);
        for (FileStatus fileStatus : rootFiles) {
            String name = fileStatus.getPath().getName();
            Assert.assertTrue((boolean)fileStatus.isDirectory());
            Assert.assertTrue((name.equals(".hbase-snapshot") || name.equals("archive") ? 1 : 0) != 0);
        }
        FileSystem hdfs = FileSystem.get((URI)hdfsUri, (Configuration)TEST_UTIL.getConfiguration());
        Path snapshotDir = new Path(".hbase-snapshot", Bytes.toString((byte[])snapshotName));
        Path targetDir = new Path(".hbase-snapshot", Bytes.toString((byte[])targetName));
        this.verifySnapshotDir(hdfs, new Path(TEST_UTIL.getDefaultRootDirPath(), snapshotDir), fs, new Path(copyDir, targetDir));
        Set<String> snapshotFiles = this.verifySnapshot(fs, copyDir, tableName, Bytes.toString((byte[])targetName));
        Assert.assertEquals((long)filesExpected, (long)snapshotFiles.size());
    }

    @Test
    public void testExportFailure() throws Exception {
        Assert.assertEquals((long)1L, (long)this.runExportAndInjectFailures(this.snapshotName, false));
    }

    @Test
    public void testExportRetry() throws Exception {
        Assert.assertEquals((long)0L, (long)this.runExportAndInjectFailures(this.snapshotName, true));
    }

    private int runExportAndInjectFailures(byte[] snapshotName, boolean retry) throws Exception {
        Path copyDir = this.getLocalDestinationDir();
        URI hdfsUri = FileSystem.get((Configuration)TEST_UTIL.getConfiguration()).getUri();
        FileSystem fs = FileSystem.get((URI)copyDir.toUri(), (Configuration)new Configuration());
        copyDir = copyDir.makeQualified(fs);
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setBoolean("test.snapshot.export.failure", true);
        conf.setBoolean("test.snapshot.export.failure.retry", retry);
        Path sourceDir = TEST_UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        int res = ExportSnapshot.innerMain((Configuration)conf, (String[])new String[]{"-snapshot", Bytes.toString((byte[])snapshotName), "-copy-from", sourceDir.toString(), "-copy-to", copyDir.toString()});
        return res;
    }

    private void verifySnapshotDir(FileSystem fs1, Path root1, FileSystem fs2, Path root2) throws IOException {
        Assert.assertEquals(this.listFiles(fs1, root1, root1), this.listFiles(fs2, root2, root2));
    }

    private Set<String> verifySnapshot(final FileSystem fs, Path rootDir, final TableName tableName, String snapshotName) throws IOException {
        final Path exportedSnapshot = new Path(rootDir, new Path(".hbase-snapshot", snapshotName));
        final HashSet<String> snapshotFiles = new HashSet<String>();
        final Path exportedArchive = new Path(rootDir, "archive");
        SnapshotReferenceUtil.visitReferencedFiles((Configuration)TEST_UTIL.getConfiguration(), (FileSystem)fs, (Path)exportedSnapshot, (SnapshotReferenceUtil.SnapshotVisitor)new SnapshotReferenceUtil.SnapshotVisitor(){

            public void storeFile(HRegionInfo regionInfo, String family, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                if (MobUtils.isMobRegionInfo((HRegionInfo)regionInfo)) {
                    return;
                }
                String hfile = storeFile.getName();
                snapshotFiles.add(hfile);
                if (!storeFile.hasReference()) {
                    this.verifyNonEmptyFile(new Path(exportedArchive, new Path(FSUtils.getTableDir((Path)new Path("./"), (TableName)tableName), new Path(regionInfo.getEncodedName(), new Path(family, hfile)))));
                }
            }

            public void logFile(String server, String logfile) throws IOException {
                snapshotFiles.add(logfile);
                this.verifyNonEmptyFile(new Path(exportedSnapshot, new Path(server, logfile)));
            }

            private void verifyNonEmptyFile(Path path) throws IOException {
                Assert.assertTrue((String)(path + " should exists"), (boolean)fs.exists(path));
                Assert.assertTrue((String)(path + " should not be empty"), (fs.getFileStatus(path).getLen() > 0L ? 1 : 0) != 0);
            }
        });
        HBaseProtos.SnapshotDescription desc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fs, (Path)exportedSnapshot);
        Assert.assertTrue((boolean)desc.getName().equals(snapshotName));
        Assert.assertTrue((boolean)desc.getTable().equals(tableName.getNameAsString()));
        return snapshotFiles;
    }

    private Set<String> listFiles(FileSystem fs, Path root, Path dir) throws IOException {
        HashSet<String> files = new HashSet<String>();
        int rootPrefix = root.toString().length();
        FileStatus[] list = FSUtils.listStatus((FileSystem)fs, (Path)dir);
        if (list != null) {
            for (FileStatus fstat : list) {
                this.LOG.debug((Object)fstat.getPath());
                if (fstat.isDirectory()) {
                    files.addAll(this.listFiles(fs, root, fstat.getPath()));
                    continue;
                }
                files.add(fstat.getPath().toString().substring(rootPrefix));
            }
        }
        return files;
    }

    private Path getHdfsDestinationDir() {
        Path rootDir = TEST_UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        Path path = new Path(new Path(rootDir, "export-test"), "export-" + System.currentTimeMillis());
        this.LOG.info((Object)("HDFS export destination path: " + path));
        return path;
    }

    private Path getLocalDestinationDir() {
        Path path = TEST_UTIL.getDataTestDir("local-export-" + System.currentTimeMillis());
        this.LOG.info((Object)("Local export destination path: " + path));
        return path;
    }

    private void removeExportDir(Path path) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)new Configuration());
        fs.delete(path, true);
    }
}

