/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.mr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.errors.ErrorAndSolution;
import org.apache.hadoop.hive.ql.exec.errors.TaskLogProcessor;
import org.apache.hadoop.hive.ql.exec.mr.JobTrackerURLResolver;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;

public class JobDebugger
implements Runnable {
    private final JobConf conf;
    private final RunningJob rj;
    private final SessionState.LogHelper console;
    private final Map<String, List<List<String>>> stackTraces;
    private final Map<String, Integer> failures = new HashMap<String, Integer>();
    private final Set<String> successes = new HashSet<String>();
    private final Map<String, TaskInfo> taskIdToInfo = new HashMap<String, TaskInfo>();
    private int maxFailures = 0;

    public JobDebugger(JobConf conf, RunningJob rj, SessionState.LogHelper console) {
        this.conf = conf;
        this.rj = rj;
        this.console = console;
        this.stackTraces = null;
    }

    public JobDebugger(JobConf conf, RunningJob rj, SessionState.LogHelper console, Map<String, List<List<String>>> stackTraces) {
        this.conf = conf;
        this.rj = rj;
        this.console = console;
        this.stackTraces = stackTraces;
    }

    @Override
    public void run() {
        try {
            this.showJobFailDebugInfo();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.console.printError("Could not obtain debuging information: " + t.getClass().getSimpleName() + ": " + t.getMessage());
        }
    }

    public static int extractErrorCode(String[] diagnostics) {
        int result = 0;
        Pattern errorCodeRegex = ErrorMsg.getErrorCodePattern();
        for (String mesg : diagnostics) {
            Matcher matcher = errorCodeRegex.matcher(mesg);
            if (!matcher.find()) continue;
            result = Integer.parseInt(matcher.group(1));
        }
        return result;
    }

    private void computeMaxFailures() {
        this.maxFailures = 0;
        for (Integer failCount : this.failures.values()) {
            if (this.maxFailures >= failCount) continue;
            this.maxFailures = failCount;
        }
    }

    private void showJobFailDebugInfo() throws IOException {
        this.console.printError("Error during job, obtaining debugging information...");
        if (!this.conf.get("mapred.job.tracker", "local").equals("local")) {
            this.console.printError("Job Tracking URL: " + this.rj.getTrackingURL());
        }
        TaskInfoGrabber tlg = new TaskInfoGrabber();
        Thread t = new Thread(tlg);
        try {
            t.start();
            t.join(HiveConf.getIntVar((Configuration)this.conf, HiveConf.ConfVars.TASKLOG_DEBUG_TIMEOUT));
        }
        catch (InterruptedException e) {
            this.console.printError("Timed out trying to finish grabbing task log URLs, some task info may be missing");
        }
        for (String task : this.successes) {
            this.failures.remove(task);
        }
        if (this.failures.keySet().size() == 0) {
            return;
        }
        this.computeMaxFailures();
        String jtUrl = null;
        try {
            jtUrl = JobTrackerURLResolver.getURL(this.conf);
        }
        catch (Exception e) {
            this.console.printError("Unable to retrieve URL for Hadoop Task logs. " + e.getMessage());
        }
        for (String task : this.failures.keySet()) {
            String[] diagMesgs;
            if (this.failures.get(task) != this.maxFailures) continue;
            TaskInfo ti = this.taskIdToInfo.get(task);
            String jobId = ti.getJobId();
            String taskUrl = jtUrl == null ? null : jtUrl + "/taskdetails.jsp?jobid=" + jobId + "&tipid=" + task.toString();
            TaskLogProcessor tlp = new TaskLogProcessor(this.conf);
            for (String logUrl : ti.getLogUrls()) {
                tlp.addTaskAttemptLogUrl(logUrl);
            }
            if (HiveConf.getBoolVar((Configuration)this.conf, HiveConf.ConfVars.JOB_DEBUG_CAPTURE_STACKTRACES) && this.stackTraces != null) {
                if (!this.stackTraces.containsKey(jobId)) {
                    this.stackTraces.put(jobId, new ArrayList());
                }
                this.stackTraces.get(jobId).addAll(tlp.getStackTraces());
            }
            if (!HiveConf.getBoolVar((Configuration)this.conf, HiveConf.ConfVars.SHOW_JOB_FAIL_DEBUG_INFO)) break;
            List<ErrorAndSolution> errors = tlp.getErrors();
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("Task with the most failures(" + this.maxFailures + "): \n");
            sb.append("-----\n");
            sb.append("Task ID:\n  " + task + "\n\n");
            if (taskUrl != null) {
                sb.append("URL:\n  " + taskUrl + "\n");
            }
            for (ErrorAndSolution e : errors) {
                sb.append("\n");
                sb.append("Possible error:\n  " + e.getError() + "\n\n");
                sb.append("Solution:\n  " + e.getSolution() + "\n");
            }
            sb.append("-----\n");
            sb.append("Diagnostic Messages for this Task:\n");
            for (String mesg : diagMesgs = ti.getDiagnosticMesgs()) {
                sb.append(mesg + "\n");
            }
            this.console.printError(sb.toString());
            break;
        }
    }

    public int getErrorCode() {
        for (String task : this.failures.keySet()) {
            if (this.failures.get(task) != this.maxFailures) continue;
            TaskInfo ti = this.taskIdToInfo.get(task);
            return ti.getErrorCode();
        }
        return 0;
    }

    class TaskInfoGrabber
    implements Runnable {
        TaskInfoGrabber() {
        }

        @Override
        public void run() {
            try {
                this.getTaskInfos();
            }
            catch (Exception e) {
                JobDebugger.this.console.printError(e.getMessage());
            }
        }

        private void getTaskInfos() throws IOException, MalformedURLException {
            TaskCompletionEvent[] taskCompletions;
            int startIndex = 0;
            while ((taskCompletions = JobDebugger.this.rj.getTaskCompletionEvents(startIndex)) != null && taskCompletions.length != 0) {
                boolean more = true;
                boolean firstError = true;
                for (TaskCompletionEvent t : taskCompletions) {
                    TaskInfo ti;
                    String taskId = t.getTaskAttemptId().getTaskID().toString();
                    String jobId = t.getTaskAttemptId().getJobID().toString();
                    if (firstError) {
                        JobDebugger.this.console.printError("Examining task ID: " + taskId + " (and more) from job " + jobId);
                        firstError = false;
                    }
                    if ((ti = (TaskInfo)JobDebugger.this.taskIdToInfo.get(taskId)) == null) {
                        ti = new TaskInfo(jobId);
                        JobDebugger.this.taskIdToInfo.put(taskId, ti);
                    }
                    assert (ti.getJobId() != null && ti.getJobId().equals(jobId));
                    String taskAttemptLogUrl = ShimLoader.getHadoopShims().getTaskAttemptLogUrl(JobDebugger.this.conf, t.getTaskTrackerHttp(), t.getTaskId());
                    if (taskAttemptLogUrl != null) {
                        ti.getLogUrls().add(taskAttemptLogUrl);
                    }
                    if (t.getTaskStatus() != TaskCompletionEvent.Status.SUCCEEDED) {
                        Integer failAttempts;
                        String[] diags = JobDebugger.this.rj.getTaskDiagnostics(t.getTaskAttemptId());
                        ti.setDiagnosticMesgs(diags);
                        if (ti.getErrorCode() == 0) {
                            ti.setErrorCode(JobDebugger.extractErrorCode(diags));
                        }
                        if ((failAttempts = (Integer)JobDebugger.this.failures.get(taskId)) == null) {
                            failAttempts = 0;
                        }
                        failAttempts = failAttempts + 1;
                        JobDebugger.this.failures.put(taskId, failAttempts);
                        continue;
                    }
                    JobDebugger.this.successes.add(taskId);
                }
                if (!more) break;
                startIndex += taskCompletions.length;
            }
        }
    }

    private static class TaskInfo {
        String jobId;
        Set<String> logUrls;
        int errorCode;
        String[] diagnosticMesgs;

        public TaskInfo(String jobId) {
            this.jobId = jobId;
            this.logUrls = new HashSet<String>();
            this.errorCode = 0;
            this.diagnosticMesgs = null;
        }

        public void addLogUrl(String logUrl) {
            this.logUrls.add(logUrl);
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public void setDiagnosticMesgs(String[] diagnosticMesgs) {
            this.diagnosticMesgs = diagnosticMesgs;
        }

        public Set<String> getLogUrls() {
            return this.logUrls;
        }

        public String getJobId() {
            return this.jobId;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String[] getDiagnosticMesgs() {
            return this.diagnosticMesgs;
        }
    }
}

