/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatistic;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatisticGroup;
import org.apache.hadoop.hive.ql.exec.spark.Statistic.SparkStatistics;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManagerImpl;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobRef;
import org.apache.hadoop.hive.ql.exec.spark.status.SparkJobStatus;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.spark.counter.SparkCounters;

public class SparkTask
extends Task<SparkWork> {
    private static final String CLASS_NAME = SparkTask.class.getName();
    private final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    private static final long serialVersionUID = 1L;
    private SparkCounters sparkCounters;

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext driverContext) {
        super.initialize(conf, queryPlan, driverContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        int rc = 0;
        SparkSession sparkSession = null;
        SparkSessionManagerImpl sparkSessionManager = null;
        try {
            this.printConfigInfo();
            sparkSessionManager = SparkSessionManagerImpl.getInstance();
            sparkSession = SparkUtilities.getSparkSession(this.conf, sparkSessionManager);
            SparkWork sparkWork = (SparkWork)this.getWork();
            sparkWork.setRequiredCounterPrefix(this.getCounterPrefixes());
            this.perfLogger.PerfLogBegin(CLASS_NAME, "SparkSubmitJob");
            SparkJobRef jobRef = sparkSession.submit(driverContext, sparkWork);
            this.perfLogger.PerfLogEnd(CLASS_NAME, "SparkSubmitJob");
            this.addToHistory(jobRef);
            rc = jobRef.monitorJob();
            SparkJobStatus sparkJobStatus = jobRef.getSparkJobStatus();
            if (rc == 0) {
                this.sparkCounters = sparkJobStatus.getCounter();
                SparkStatistics sparkStatistics = sparkJobStatus.getSparkStatistics();
                if (LOG.isInfoEnabled() && sparkStatistics != null) {
                    LOG.info((Object)String.format("=====Spark Job[%s] statistics=====", jobRef.getJobId()));
                    this.logSparkStatistic(sparkStatistics);
                }
            } else if (rc == 2) {
                jobRef.cancelJob();
            }
            sparkJobStatus.cleanup();
        }
        catch (Exception e) {
            String msg = "Failed to execute spark task, with exception '" + Utilities.getNameMessage(e) + "'";
            this.console.printError(msg, "\n" + StringUtils.stringifyException((Throwable)e));
            LOG.error((Object)msg, (Throwable)e);
            rc = 1;
        }
        finally {
            Utilities.clearWork(this.conf);
            if (sparkSession != null && sparkSessionManager != null) {
                rc = this.close(rc);
                try {
                    sparkSessionManager.returnSession(sparkSession);
                }
                catch (HiveException ex) {
                    LOG.error((Object)"Failed to return the session to SessionManager", (Throwable)ex);
                }
            }
        }
        return rc;
    }

    private void addToHistory(SparkJobRef jobRef) {
        this.console.printInfo("Starting Spark Job = " + jobRef.getJobId());
        if (SessionState.get() != null) {
            SessionState.get().getHiveHistory().setQueryProperty(SessionState.get().getQueryId(), HiveHistory.Keys.SPARK_JOB_ID, jobRef.getJobId());
        }
    }

    private void logSparkStatistic(SparkStatistics sparkStatistic) {
        Iterator<SparkStatisticGroup> groupIterator = sparkStatistic.getStatisticGroups();
        while (groupIterator.hasNext()) {
            SparkStatisticGroup group = groupIterator.next();
            LOG.info((Object)group.getGroupName());
            Iterator<SparkStatistic> statisticIterator = group.getStatistics();
            while (statisticIterator.hasNext()) {
                SparkStatistic statistic = statisticIterator.next();
                LOG.info((Object)("\t" + statistic.getName() + ": " + statistic.getValue()));
            }
        }
    }

    private int close(int rc) {
        block4: {
            try {
                List<BaseWork> ws = ((SparkWork)this.work).getAllWork();
                for (BaseWork w : ws) {
                    for (Operator<?> op : w.getAllOperators()) {
                        op.jobClose(this.conf, rc == 0);
                    }
                }
            }
            catch (Exception e) {
                if (rc != 0) break block4;
                rc = 3;
                String mesg = "Job Commit failed with exception '" + Utilities.getNameMessage(e) + "'";
                this.console.printError(mesg, "\n" + StringUtils.stringifyException((Throwable)e));
            }
        }
        return rc;
    }

    @Override
    public boolean isMapRedTask() {
        return true;
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    @Override
    public String getName() {
        return "SPARK";
    }

    @Override
    public Collection<MapWork> getMapWork() {
        ArrayList<MapWork> result = Lists.newArrayList();
        for (BaseWork w : ((SparkWork)this.getWork()).getRoots()) {
            result.add((MapWork)w);
        }
        return result;
    }

    @Override
    public Operator<? extends OperatorDesc> getReducer(MapWork mapWork) {
        List<BaseWork> children = ((SparkWork)this.getWork()).getChildren(mapWork);
        if (children.size() != 1) {
            return null;
        }
        if (!(children.get(0) instanceof ReduceWork)) {
            return null;
        }
        return ((ReduceWork)children.get(0)).getReducer();
    }

    public SparkCounters getSparkCounters() {
        return this.sparkCounters;
    }

    private void printConfigInfo() throws IOException {
        this.console.printInfo("In order to change the average load for a reducer (in bytes):");
        this.console.printInfo("  set " + HiveConf.ConfVars.BYTESPERREDUCER.varname + "=<number>");
        this.console.printInfo("In order to limit the maximum number of reducers:");
        this.console.printInfo("  set " + HiveConf.ConfVars.MAXREDUCERS.varname + "=<number>");
        this.console.printInfo("In order to set a constant number of reducers:");
        this.console.printInfo("  set " + (Object)((Object)HiveConf.ConfVars.HADOOPNUMREDUCERS) + "=<number>");
    }

    private Map<String, List<String>> getCounterPrefixes() throws HiveException, MetaException {
        Map<String, List<String>> counters = this.getOperatorCounters();
        StatsTask statsTask = SparkTask.getStatsTaskInChildTasks(this);
        String statsImpl = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVESTATSDBCLASS);
        if (statsImpl.equalsIgnoreCase("counter") && statsTask != null) {
            List<String> prefixes = this.getRequiredCounterPrefix(statsTask);
            for (String prefix : prefixes) {
                List<String> counterGroup = counters.get(prefix);
                if (counterGroup == null) {
                    counterGroup = new LinkedList<String>();
                    counters.put(prefix, counterGroup);
                }
                counterGroup.add("numRows");
                counterGroup.add("rawDataSize");
            }
        }
        return counters;
    }

    private List<String> getRequiredCounterPrefix(StatsTask statsTask) throws HiveException, MetaException {
        LinkedList<String> prefixs = new LinkedList<String>();
        StatsWork statsWork = (StatsWork)statsTask.getWork();
        String tablePrefix = this.getTablePrefix(statsWork);
        List<Map<String, String>> partitionSpecs = this.getPartitionSpecs(statsWork);
        int maxPrefixLength = StatsFactory.getMaxPrefixLength(this.conf);
        if (partitionSpecs == null) {
            prefixs.add(Utilities.getHashedStatsPrefix(tablePrefix, maxPrefixLength));
        } else {
            for (Map<String, String> partitionSpec : partitionSpecs) {
                String prefixWithPartition = Utilities.join(tablePrefix, Warehouse.makePartPath(partitionSpec));
                prefixs.add(Utilities.getHashedStatsPrefix(prefixWithPartition, maxPrefixLength));
            }
        }
        return prefixs;
    }

    private String getTablePrefix(StatsWork work) throws HiveException {
        Table table;
        String tableName = work.getLoadTableDesc() != null ? work.getLoadTableDesc().getTable().getTableName() : (work.getTableSpecs() != null ? work.getTableSpecs().tableName : work.getLoadFileDesc().getDestinationCreateTable());
        try {
            table = this.db.getTable(tableName);
        }
        catch (HiveException e) {
            LOG.warn((Object)("Failed to get table:" + tableName));
            return tableName.toLowerCase();
        }
        return table.getDbName() + "." + table.getTableName();
    }

    private static StatsTask getStatsTaskInChildTasks(Task<? extends Serializable> rootTask) {
        List<Task<Serializable>> childTasks = rootTask.getChildTasks();
        if (childTasks == null) {
            return null;
        }
        for (Task<Serializable> task : childTasks) {
            if (task instanceof StatsTask) {
                return (StatsTask)task;
            }
            StatsTask childTask = SparkTask.getStatsTaskInChildTasks(task);
            if (!(childTask instanceof StatsTask)) continue;
            return childTask;
        }
        return null;
    }

    private List<Map<String, String>> getPartitionSpecs(StatsWork work) throws HiveException {
        if (work.getLoadFileDesc() != null) {
            return null;
        }
        ArrayList<Map<String, String>> partitionSpecs = new ArrayList<Map<String, String>>();
        if (work.getTableSpecs() != null) {
            BaseSemanticAnalyzer.tableSpec tblSpec = work.getTableSpecs();
            Table table = tblSpec.tableHandle;
            if (!table.isPartitioned()) {
                return null;
            }
            List<Partition> partitions = tblSpec.partitions;
            if (partitions != null) {
                for (Partition partition : partitions) {
                    partitionSpecs.add(partition.getSpec());
                }
            }
        } else if (work.getLoadTableDesc() != null) {
            LoadTableDesc tbd = work.getLoadTableDesc();
            Table table = this.db.getTable(tbd.getTable().getTableName());
            if (!table.isPartitioned()) {
                return null;
            }
            DynamicPartitionCtx dpCtx = tbd.getDPCtx();
            if (dpCtx == null || dpCtx.getNumDPCols() <= 0) {
                partitionSpecs.add(tbd.getPartitionSpec());
            }
        }
        return partitionSpecs;
    }

    private Map<String, List<String>> getOperatorCounters() {
        String groupName = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVECOUNTERGROUP);
        HashMap<String, List<String>> counters = new HashMap<String, List<String>>();
        LinkedList<String> hiveCounters = new LinkedList<String>();
        counters.put(groupName, hiveCounters);
        hiveCounters.add("CREATED_FILES");
        for (MapOperator.Counter counter : MapOperator.Counter.values()) {
            hiveCounters.add(counter.toString());
        }
        SparkWork sparkWork = (SparkWork)this.getWork();
        for (BaseWork work : sparkWork.getAllWork()) {
            for (Operator<?> operator : work.getAllOperators()) {
                if (operator instanceof FileSinkOperator) {
                    for (Enum enum_ : FileSinkOperator.Counter.values()) {
                        hiveCounters.add(enum_.toString());
                    }
                    continue;
                }
                if (operator instanceof ReduceSinkOperator) {
                    for (Enum enum_ : ReduceSinkOperator.Counter.values()) {
                        hiveCounters.add(enum_.toString());
                    }
                    continue;
                }
                if (operator instanceof ScriptOperator) {
                    for (Enum enum_ : ScriptOperator.Counter.values()) {
                        hiveCounters.add(enum_.toString());
                    }
                    continue;
                }
                if (!(operator instanceof JoinOperator)) continue;
                for (Enum enum_ : JoinOperator.SkewkeyTableCounter.values()) {
                    hiveCounters.add(enum_.toString());
                }
            }
        }
        return counters;
    }
}

