/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManager;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.BytesWritable;
import org.apache.spark.SparkConf;

public class SparkUtilities {
    public static HiveKey copyHiveKey(HiveKey key) {
        HiveKey copy = new HiveKey();
        copy.setDistKeyLength(key.getDistKeyLength());
        copy.setHashCode(key.hashCode());
        copy.set(key);
        return copy;
    }

    public static BytesWritable copyBytesWritable(BytesWritable bw) {
        BytesWritable copy = new BytesWritable();
        copy.set(bw);
        return copy;
    }

    public static URI getURI(String path) throws URISyntaxException {
        if (path == null) {
            return null;
        }
        URI uri = new URI(path);
        if (uri.getScheme() == null) {
            uri = new File(path).toURI();
        }
        return uri;
    }

    public static URI uploadToHDFS(URI source, HiveConf conf) throws IOException {
        Path tmpDir = SessionState.getHDFSSessionPath(conf);
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        fileSystem.copyFromLocalFile(new Path(source.getPath()), tmpDir);
        String filePath = tmpDir + File.separator + SparkUtilities.getFileName(source);
        Path fullPath = fileSystem.getFileStatus(new Path(filePath)).getPath();
        return fullPath.toUri();
    }

    public static boolean needUploadToHDFS(URI source, SparkConf sparkConf) {
        return sparkConf.get("spark.master").equals("yarn-cluster") && !source.getScheme().equals("hdfs");
    }

    private static String getFileName(URI uri) {
        if (uri == null) {
            return null;
        }
        String[] splits = uri.getPath().split(File.separator);
        return splits[splits.length - 1];
    }

    public static SparkSession getSparkSession(HiveConf conf, SparkSessionManager sparkSessionManager) throws HiveException {
        SparkSession sparkSession = SessionState.get().getSparkSession();
        if (!conf.getBoolVar(HiveConf.ConfVars.SPARK_ENABLED)) {
            throw new HiveException("Unsupported execution engine: Spark.  Please set hive.execution.engine=mr");
        }
        if (conf.getSparkConfigUpdated()) {
            sparkSessionManager.closeSession(sparkSession);
            sparkSession = null;
            conf.setSparkConfigUpdated(false);
        }
        sparkSession = sparkSessionManager.getSession(sparkSession, conf, true);
        SessionState.get().setSparkSession(sparkSession);
        return sparkSession;
    }
}

