/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.DataOutput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSerde;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;

public class VectorAppMasterEventOperator
extends AppMasterEventOperator {
    private static final long serialVersionUID = 1L;
    protected transient Object[] singleRow;
    protected transient VectorExpressionWriter[] valueWriters;

    public VectorAppMasterEventOperator(VectorizationContext context, OperatorDesc conf) {
        this.conf = (AppMasterEventDesc)conf;
    }

    public VectorAppMasterEventOperator() {
    }

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        this.valueWriters = VectorExpressionWriterFactory.getExpressionWriters((StructObjectInspector)this.inputObjInspectors[0]);
        this.singleRow = new Object[this.valueWriters.length];
    }

    @Override
    public void processOp(Object data, int tag) throws HiveException {
        VectorizedRowBatch vrg = (VectorizedRowBatch)data;
        Writable[] records = null;
        Writable recordValue = null;
        boolean vectorizedSerde = false;
        try {
            if (this.serializer instanceof VectorizedSerde) {
                recordValue = ((VectorizedSerde)((Object)this.serializer)).serializeVector(vrg, this.inputObjInspectors[0]);
                records = (Writable[])((ObjectWritable)recordValue).get();
                vectorizedSerde = true;
            }
        }
        catch (SerDeException e1) {
            throw new HiveException(e1);
        }
        for (int i = 0; i < vrg.size; ++i) {
            Writable row = null;
            if (vectorizedSerde) {
                row = records[i];
            } else {
                if (vrg.valueWriters == null) {
                    vrg.setValueWriters(this.valueWriters);
                }
                try {
                    row = this.serializer.serialize(this.getRowObject(vrg, i), this.inputObjInspectors[0]);
                }
                catch (SerDeException ex) {
                    throw new HiveException(ex);
                }
            }
            try {
                row.write((DataOutput)this.buffer);
                if ((long)this.buffer.getLength() <= this.MAX_SIZE) continue;
                this.LOG.info((Object)("Disabling AM events. Buffer size too large: " + this.buffer.getLength()));
                this.hasReachedMaxSize = true;
                this.buffer = null;
                continue;
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
    }

    private Object[] getRowObject(VectorizedRowBatch vrg, int rowIndex) throws HiveException {
        int batchIndex = rowIndex;
        if (vrg.selectedInUse) {
            batchIndex = vrg.selected[rowIndex];
        }
        for (int i = 0; i < vrg.projectionSize; ++i) {
            ColumnVector vectorColumn = vrg.cols[vrg.projectedColumns[i]];
            this.singleRow[i] = vrg.valueWriters[i].writeValue(vectorColumn, batchIndex);
        }
        return this.singleRow;
    }
}

