/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import parquet.hadoop.ParquetWriter;
import parquet.io.api.Binary;

@SerDeSpec(schemaProps={"columns", "columns.types", "parquet.compression"})
public class ParquetHiveSerDe
extends AbstractSerDe {
    public static final Text MAP_KEY = new Text("key");
    public static final Text MAP_VALUE = new Text("value");
    public static final Text MAP = new Text("map");
    public static final Text ARRAY = new Text("bag");
    private static final String DEFAULTCOMPRESSION = ParquetWriter.DEFAULT_COMPRESSION_CODEC_NAME.name();
    public static final int[] PRECISION_TO_BYTE_COUNT = new int[38];
    private SerDeStats stats;
    private ObjectInspector objInspector;
    private LAST_OPERATION status;
    private long serializedSize;
    private long deserializedSize;
    private String compressionType;

    @Override
    public final void initialize(Configuration conf, Properties tbl) throws SerDeException {
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        this.compressionType = tbl.getProperty("parquet.compression", DEFAULTCOMPRESSION);
        List<Object> columnNames = columnNameProperty.length() == 0 ? new ArrayList() : Arrays.asList(columnNameProperty.split(","));
        ArrayList<TypeInfo> columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalArgumentException("ParquetHiveSerde initialization failed. Number of column name and column type differs. columnNames = " + columnNames + ", columnTypes = " + columnTypes);
        }
        TypeInfo rowTypeInfo = TypeInfoFactory.getStructTypeInfo(columnNames, columnTypes);
        this.objInspector = new ArrayWritableObjectInspector((StructTypeInfo)rowTypeInfo);
        this.stats = new SerDeStats();
        this.serializedSize = 0L;
        this.deserializedSize = 0L;
        this.status = LAST_OPERATION.UNKNOWN;
    }

    @Override
    public Object deserialize(Writable blob) throws SerDeException {
        this.status = LAST_OPERATION.DESERIALIZE;
        this.deserializedSize = 0L;
        if (blob instanceof ArrayWritable) {
            this.deserializedSize = ((ArrayWritable)blob).get().length;
            return blob;
        }
        return null;
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objInspector;
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return ArrayWritable.class;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (!objInspector.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            throw new SerDeException("Cannot serialize " + (Object)((Object)objInspector.getCategory()) + ". Can only serialize a struct");
        }
        ArrayWritable serializeData = this.createStruct(obj, (StructObjectInspector)objInspector);
        this.serializedSize = serializeData.get().length;
        this.status = LAST_OPERATION.SERIALIZE;
        return serializeData;
    }

    private ArrayWritable createStruct(Object obj, StructObjectInspector inspector) throws SerDeException {
        List<? extends StructField> fields = inspector.getAllStructFieldRefs();
        Writable[] arr = new Writable[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            StructField field = fields.get(i);
            Object subObj = inspector.getStructFieldData(obj, field);
            ObjectInspector subInspector = field.getFieldObjectInspector();
            arr[i] = this.createObject(subObj, subInspector);
        }
        return new ArrayWritable(Writable.class, arr);
    }

    private Writable createMap(Object obj, MapObjectInspector inspector) throws SerDeException {
        Map<?, ?> sourceMap = inspector.getMap(obj);
        ObjectInspector keyInspector = inspector.getMapKeyObjectInspector();
        ObjectInspector valueInspector = inspector.getMapValueObjectInspector();
        ArrayList<ArrayWritable> array = new ArrayList<ArrayWritable>();
        if (sourceMap != null) {
            for (Map.Entry<?, ?> keyValue : sourceMap.entrySet()) {
                Writable key = this.createObject(keyValue.getKey(), keyInspector);
                Writable value = this.createObject(keyValue.getValue(), valueInspector);
                if (key == null) continue;
                Writable[] arr = new Writable[]{key, value};
                array.add(new ArrayWritable(Writable.class, arr));
            }
        }
        if (array.size() > 0) {
            ArrayWritable subArray = new ArrayWritable(ArrayWritable.class, (Writable[])array.toArray(new ArrayWritable[array.size()]));
            return new ArrayWritable(Writable.class, new Writable[]{subArray});
        }
        return null;
    }

    private ArrayWritable createArray(Object obj, ListObjectInspector inspector) throws SerDeException {
        List<?> sourceArray = inspector.getList(obj);
        ObjectInspector subInspector = inspector.getListElementObjectInspector();
        ArrayList<Writable> array = new ArrayList<Writable>();
        if (sourceArray != null) {
            for (Object curObj : sourceArray) {
                array.add(this.createObject(curObj, subInspector));
            }
        }
        if (array.size() > 0) {
            ArrayWritable subArray = new ArrayWritable(Writable.class, array.toArray(new Writable[array.size()]));
            return new ArrayWritable(Writable.class, new Writable[]{subArray});
        }
        return null;
    }

    private Writable createPrimitive(Object obj, PrimitiveObjectInspector inspector) throws SerDeException {
        if (obj == null) {
            return null;
        }
        switch (inspector.getPrimitiveCategory()) {
            case VOID: {
                return null;
            }
            case BOOLEAN: {
                return new BooleanWritable((((BooleanObjectInspector)inspector).get(obj) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
            }
            case BYTE: {
                return new ByteWritable(((ByteObjectInspector)inspector).get(obj));
            }
            case DOUBLE: {
                return new DoubleWritable(((DoubleObjectInspector)inspector).get(obj));
            }
            case FLOAT: {
                return new FloatWritable(((FloatObjectInspector)inspector).get(obj));
            }
            case INT: {
                return new IntWritable(((IntObjectInspector)inspector).get(obj));
            }
            case LONG: {
                return new LongWritable(((LongObjectInspector)inspector).get(obj));
            }
            case SHORT: {
                return new ShortWritable(((ShortObjectInspector)inspector).get(obj));
            }
            case STRING: {
                String v = ((StringObjectInspector)inspector).getPrimitiveJavaObject(obj);
                try {
                    return new BytesWritable(v.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new SerDeException("Failed to encode string in UTF-8", e);
                }
            }
            case DECIMAL: {
                HiveDecimal hd = (HiveDecimal)inspector.getPrimitiveJavaObject(obj);
                DecimalTypeInfo decTypeInfo = (DecimalTypeInfo)inspector.getTypeInfo();
                int prec = decTypeInfo.precision();
                int scale = decTypeInfo.scale();
                byte[] src = hd.setScale(scale).unscaledValue().toByteArray();
                int bytes = PRECISION_TO_BYTE_COUNT[prec - 1];
                if (bytes == src.length) {
                    return new BytesWritable(src);
                }
                byte[] tgt = new byte[bytes];
                if (hd.signum() == -1) {
                    int i = 0;
                    while (i < bytes) {
                        int n = i++;
                        tgt[n] = (byte)(tgt[n] | 0xFF);
                    }
                }
                System.arraycopy(src, 0, tgt, bytes - src.length, src.length);
                return new BytesWritable(tgt);
            }
            case TIMESTAMP: {
                return new TimestampWritable(((TimestampObjectInspector)inspector).getPrimitiveJavaObject(obj));
            }
            case CHAR: {
                String strippedValue = ((HiveCharObjectInspector)inspector).getPrimitiveJavaObject(obj).getStrippedValue();
                return new BytesWritable(Binary.fromString(strippedValue).getBytes());
            }
            case VARCHAR: {
                String value = ((HiveVarcharObjectInspector)inspector).getPrimitiveJavaObject(obj).getValue();
                return new BytesWritable(Binary.fromString(value).getBytes());
            }
            case BINARY: {
                return new BytesWritable(((BinaryObjectInspector)inspector).getPrimitiveJavaObject(obj));
            }
        }
        throw new SerDeException("Unknown primitive : " + (Object)((Object)inspector.getPrimitiveCategory()));
    }

    private Writable createObject(Object obj, ObjectInspector inspector) throws SerDeException {
        if (obj == null) {
            return null;
        }
        switch (inspector.getCategory()) {
            case STRUCT: {
                return this.createStruct(obj, (StructObjectInspector)inspector);
            }
            case LIST: {
                return this.createArray(obj, (ListObjectInspector)inspector);
            }
            case MAP: {
                return this.createMap(obj, (MapObjectInspector)inspector);
            }
            case PRIMITIVE: {
                return this.createPrimitive(obj, (PrimitiveObjectInspector)inspector);
            }
        }
        throw new SerDeException("Unknown data type" + (Object)((Object)inspector.getCategory()));
    }

    @Override
    public SerDeStats getSerDeStats() {
        assert (this.status != LAST_OPERATION.UNKNOWN);
        if (this.status == LAST_OPERATION.SERIALIZE) {
            this.stats.setRawDataSize(this.serializedSize);
        } else {
            this.stats.setRawDataSize(this.deserializedSize);
        }
        return this.stats;
    }

    static {
        for (int prec = 1; prec <= 38; ++prec) {
            ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1] = (int)Math.ceil((Math.log(Math.pow(10.0, prec) - 1.0) / Math.log(2.0) + 1.0) / 8.0);
        }
    }

    private static enum LAST_OPERATION {
        SERIALIZE,
        DESERIALIZE,
        UNKNOWN;

    }
}

