/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewForwardOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDTFOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.ColumnPrunerProcCtx;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.ptf.Noop;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public final class ColumnPrunerProcFactory {
    protected static final Log LOG = LogFactory.getLog((String)ColumnPrunerProcFactory.class.getName());

    private ColumnPrunerProcFactory() {
    }

    public static ColumnPrunerFilterProc getFilterProc() {
        return new ColumnPrunerFilterProc();
    }

    public static ColumnPrunerGroupByProc getGroupByProc() {
        return new ColumnPrunerGroupByProc();
    }

    public static ColumnPrunerLimitProc getLimitProc() {
        return new ColumnPrunerLimitProc();
    }

    public static ColumnPrunerScriptProc getScriptProc() {
        return new ColumnPrunerScriptProc();
    }

    public static ColumnPrunerPTFProc getPTFProc() {
        return new ColumnPrunerPTFProc();
    }

    public static ColumnPrunerDefaultProc getDefaultProc() {
        return new ColumnPrunerDefaultProc();
    }

    public static void setupNeededColumns(TableScanOperator scanOp, RowResolver inputRR, List<String> cols) throws SemanticException {
        ArrayList<Integer> neededColumnIds = new ArrayList<Integer>();
        ArrayList<String> neededColumnNames = new ArrayList<String>();
        ArrayList<String> referencedColumnNames = new ArrayList<String>();
        TableScanDesc desc = (TableScanDesc)scanOp.getConf();
        List<VirtualColumn> virtualCols = desc.getVirtualCols();
        ArrayList<VirtualColumn> newVirtualCols = new ArrayList<VirtualColumn>();
        if (((TableScanDesc)scanOp.getConf()).isGatherStats()) {
            cols.add(VirtualColumn.RAWDATASIZE.getName());
        }
        for (String column : cols) {
            String[] tabCol = inputRR.reverseLookup(column);
            if (tabCol == null) continue;
            referencedColumnNames.add(column);
            ColumnInfo colInfo = inputRR.get(tabCol[0], tabCol[1]);
            if (colInfo.getIsVirtualCol()) {
                for (int j = 0; j < virtualCols.size(); ++j) {
                    VirtualColumn vc = virtualCols.get(j);
                    if (!vc.getName().equals(colInfo.getInternalName())) continue;
                    newVirtualCols.add(vc);
                }
                continue;
            }
            int position = inputRR.getPosition(column);
            if (position < 0) continue;
            neededColumnIds.add(position);
            neededColumnNames.add(column);
        }
        desc.setVirtualCols(newVirtualCols);
        scanOp.setNeededColumnIDs(neededColumnIds);
        scanOp.setNeededColumns(neededColumnNames);
        scanOp.setReferencedColumns(referencedColumnNames);
    }

    public static ColumnPrunerTableScanProc getTableScanProc() {
        return new ColumnPrunerTableScanProc();
    }

    public static ColumnPrunerReduceSinkProc getReduceSinkProc() {
        return new ColumnPrunerReduceSinkProc();
    }

    private static boolean[] getPruneReduceSinkOpRetainFlags(List<String> retainedParentOpOutputCols, ReduceSinkOperator reduce) {
        ReduceSinkDesc reduceConf = (ReduceSinkDesc)reduce.getConf();
        ArrayList<ExprNodeDesc> originalValueEval = reduceConf.getValueCols();
        boolean[] flags = new boolean[originalValueEval.size()];
        block0: for (int i = 0; i < originalValueEval.size(); ++i) {
            flags[i] = false;
            List<String> current = originalValueEval.get(i).getCols();
            if (current == null || current.size() == 0) {
                flags[i] = true;
                continue;
            }
            for (int j = 0; j < current.size(); ++j) {
                if (!retainedParentOpOutputCols.contains(current.get(j))) continue;
                flags[i] = true;
                continue block0;
            }
        }
        return flags;
    }

    private static void pruneReduceSinkOperator(boolean[] retainFlags, ReduceSinkOperator reduce, ColumnPrunerProcCtx cppCtx) throws SemanticException {
        ReduceSinkDesc reduceConf = (ReduceSinkDesc)reduce.getConf();
        Map<String, ExprNodeDesc> oldMap = reduce.getColumnExprMap();
        LOG.info((Object)("RS " + reduce.getIdentifier() + " oldColExprMap: " + oldMap));
        RowResolver oldRR = cppCtx.getOpToParseCtxMap().get(reduce).getRowResolver();
        ArrayList<ColumnInfo> old_signature = oldRR.getRowSchema().getSignature();
        ArrayList<ColumnInfo> signature = new ArrayList<ColumnInfo>(old_signature);
        ArrayList<String> valueColNames = reduceConf.getOutputValueColumnNames();
        ArrayList<String> newValueColNames = new ArrayList<String>();
        ArrayList<ExprNodeDesc> keyExprs = reduceConf.getKeyCols();
        ArrayList<ExprNodeDesc> valueExprs = reduceConf.getValueCols();
        ArrayList<ExprNodeDesc> newValueExprs = new ArrayList<ExprNodeDesc>();
        for (int i = 0; i < retainFlags.length; ++i) {
            String outputCol = (String)valueColNames.get(i);
            ExprNodeDesc outputColExpr = (ExprNodeDesc)valueExprs.get(i);
            if (!retainFlags[i]) {
                String[] nm = oldRR.reverseLookup(outputCol);
                if (nm == null) {
                    outputCol = Utilities.ReduceField.VALUE.toString() + "." + outputCol;
                    nm = oldRR.reverseLookup(outputCol);
                }
                if (nm == null || ExprNodeDescUtils.indexOf(outputColExpr, keyExprs) != -1) continue;
                ColumnInfo colInfo = oldRR.getFieldMap(nm[0]).remove(nm[1]);
                oldRR.getInvRslvMap().remove(colInfo.getInternalName());
                oldMap.remove(outputCol);
                signature.remove(colInfo);
                continue;
            }
            newValueColNames.add(outputCol);
            newValueExprs.add(outputColExpr);
        }
        oldRR.getRowSchema().setSignature(signature);
        reduce.getSchema().setSignature(signature);
        reduceConf.setOutputValueColumnNames(newValueColNames);
        reduceConf.setValueCols(newValueExprs);
        TableDesc newValueTable = PlanUtils.getReduceValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(reduceConf.getValueCols(), newValueColNames, 0, ""));
        reduceConf.setValueSerializeInfo(newValueTable);
        LOG.info((Object)("RS " + reduce.getIdentifier() + " newColExprMap: " + oldMap));
    }

    public static ColumnPrunerSelectProc getSelectProc() {
        return new ColumnPrunerSelectProc();
    }

    public static ColumnPrunerLateralViewJoinProc getLateralViewJoinProc() {
        return new ColumnPrunerLateralViewJoinProc();
    }

    public static ColumnPrunerLateralViewForwardProc getLateralViewForwardProc() {
        return new ColumnPrunerLateralViewForwardProc();
    }

    public static ColumnPrunerJoinProc getJoinProc() {
        return new ColumnPrunerJoinProc();
    }

    private static void pruneOperator(NodeProcessorCtx ctx, Operator<? extends OperatorDesc> op, List<String> cols) throws SemanticException {
        RowSchema inputSchema = op.getSchema();
        if (inputSchema != null) {
            ArrayList<ColumnInfo> rs = new ArrayList<ColumnInfo>();
            RowResolver oldRR = ((ColumnPrunerProcCtx)ctx).getOpToParseCtxMap().get(op).getRowResolver();
            RowResolver newRR = new RowResolver();
            for (ColumnInfo i : oldRR.getRowSchema().getSignature()) {
                if (!cols.contains(i.getInternalName())) continue;
                String[] nm = oldRR.reverseLookup(i.getInternalName());
                newRR.put(nm[0], nm[1], i);
                rs.add(i);
            }
            ((ColumnPrunerProcCtx)ctx).getOpToParseCtxMap().get(op).setRowResolver(newRR);
            op.getSchema().setSignature(rs);
        }
    }

    private static List<String> preserveColumnOrder(Operator<? extends OperatorDesc> op, List<String> cols) throws SemanticException {
        RowSchema inputSchema = op.getSchema();
        if (inputSchema != null) {
            ArrayList<String> rs = new ArrayList<String>();
            ArrayList<ColumnInfo> inputCols = inputSchema.getSignature();
            for (ColumnInfo i : inputCols) {
                if (!cols.contains(i.getInternalName())) continue;
                rs.add(i.getInternalName());
            }
            return rs;
        }
        return cols;
    }

    private static void pruneJoinOperator(NodeProcessorCtx ctx, CommonJoinOperator op, JoinDesc conf, Map<String, ExprNodeDesc> columnExprMap, Map<Byte, List<Integer>> retainMap, boolean mapJoin) throws SemanticException {
        String internalName;
        ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
        List<Operator<OperatorDesc>> childOperators = op.getChildOperators();
        LOG.info((Object)("JOIN " + op.getIdentifier() + " oldExprs: " + conf.getExprs()));
        List<String> childColLists = cppCtx.genColLists(op);
        if (childColLists == null) {
            return;
        }
        HashMap<Byte, List<Object>> prunedColLists = new HashMap<Byte, List<Object>>();
        Byte[] arr$ = conf.getTagOrder();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte tag = arr$[i$];
            prunedColLists.put(tag, new ArrayList());
        }
        Set<Map.Entry<Byte, List<ExprNodeDesc>>> filters = conf.getFilters().entrySet();
        for (Map.Entry<Byte, List<ExprNodeDesc>> entry : filters) {
            Byte tag = entry.getKey();
            for (ExprNodeDesc desc : entry.getValue()) {
                List<String> cols = (List<String>)prunedColLists.get(tag);
                cols = Utilities.mergeUniqElems(cols, desc.getCols());
                prunedColLists.put(tag, cols);
            }
        }
        RowResolver joinRR = cppCtx.getOpToParseCtxMap().get(op).getRowResolver();
        RowResolver newJoinRR = new RowResolver();
        ArrayList<String> outputCols = new ArrayList<String>();
        ArrayList<ColumnInfo> rs = new ArrayList<ColumnInfo>();
        HashMap<String, ExprNodeDesc> newColExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < conf.getOutputColumnNames().size(); ++i) {
            internalName = conf.getOutputColumnNames().get(i);
            ExprNodeDesc desc = columnExprMap.get(internalName);
            Byte tag = conf.getReversedExprs().get(internalName);
            if (!childColLists.contains(internalName)) {
                int index = conf.getExprs().get(tag).indexOf(desc);
                if (index < 0) continue;
                conf.getExprs().get(tag).remove(desc);
                if (retainMap == null) continue;
                retainMap.get(tag).remove(index);
                continue;
            }
            List<String> prunedRSList = (ArrayList<String>)prunedColLists.get(tag);
            if (prunedRSList == null) {
                prunedRSList = new ArrayList<String>();
                prunedColLists.put(tag, prunedRSList);
            }
            prunedRSList = Utilities.mergeUniqElems(prunedRSList, desc.getCols());
            outputCols.add(internalName);
            newColExprMap.put(internalName, desc);
        }
        if (mapJoin) {
            ArrayList<TableDesc> valueTableDescs = new ArrayList<TableDesc>();
            for (int pos = 0; pos < op.getParentOperators().size(); ++pos) {
                List<ExprNodeDesc> valueCols = conf.getExprs().get((byte)pos);
                StringBuilder keyOrder = new StringBuilder();
                for (int i = 0; i < valueCols.size(); ++i) {
                    keyOrder.append("+");
                }
                TableDesc valueTableDesc = PlanUtils.getMapJoinValueTableDesc(PlanUtils.getFieldSchemasFromColumnList(valueCols, "mapjoinvalue"));
                valueTableDescs.add(valueTableDesc);
            }
            ((MapJoinDesc)conf).setValueTblDescs(valueTableDescs);
            Set<Map.Entry<Byte, List<ExprNodeDesc>>> exprs = ((MapJoinDesc)conf).getKeys().entrySet();
            for (Map.Entry<Byte, List<ExprNodeDesc>> entry : exprs) {
                List<ExprNodeDesc> lists = entry.getValue();
                for (int j = 0; j < lists.size(); ++j) {
                    ExprNodeDesc desc = lists.get(j);
                    Byte tag = entry.getKey();
                    List<String> cols = (List<String>)prunedColLists.get(tag);
                    cols = Utilities.mergeUniqElems(cols, desc.getCols());
                    prunedColLists.put(tag, cols);
                }
            }
        }
        for (Operator<OperatorDesc> child : childOperators) {
            if (!(child instanceof ReduceSinkOperator)) continue;
            boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(childColLists, (ReduceSinkOperator)child);
            ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)child, cppCtx);
        }
        for (int i = 0; i < outputCols.size(); ++i) {
            internalName = (String)outputCols.get(i);
            String[] nm = joinRR.reverseLookup(internalName);
            ColumnInfo col = joinRR.get(nm[0], nm[1]);
            newJoinRR.put(nm[0], nm[1], col);
            rs.add(col);
        }
        LOG.info((Object)("JOIN " + op.getIdentifier() + " newExprs: " + conf.getExprs()));
        op.setColumnExprMap(newColExprMap);
        conf.setOutputColumnNames(outputCols);
        op.getSchema().setSignature(rs);
        cppCtx.getOpToParseCtxMap().get(op).setRowResolver(newJoinRR);
        cppCtx.getJoinPrunedColLists().put(op, prunedColLists);
    }

    public static ColumnPrunerMapJoinProc getMapJoinProc() {
        return new ColumnPrunerMapJoinProc();
    }

    public static class ColumnPrunerMapJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            AbstractMapJoinOperator op = (AbstractMapJoinOperator)nd;
            ColumnPrunerProcFactory.pruneJoinOperator(ctx, op, (JoinDesc)op.getConf(), op.getColumnExprMap(), ((MapJoinDesc)op.getConf()).getRetainList(), true);
            return null;
        }
    }

    public static class ColumnPrunerJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator op = (JoinOperator)nd;
            ColumnPrunerProcFactory.pruneJoinOperator(ctx, op, (JoinDesc)op.getConf(), op.getColumnExprMap(), null, false);
            return null;
        }
    }

    public static class ColumnPrunerSelectProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator op = (SelectOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            if (op.getChildOperators() != null) {
                for (Operator<OperatorDesc> child : op.getChildOperators()) {
                    if (!(child instanceof UDTFOperator)) continue;
                    cppCtx.getPrunedColLists().put(op, cppCtx.getColsFromSelectExpr(op));
                    return null;
                }
            }
            LateralViewJoinOperator lvJoin = null;
            if (((SelectDesc)op.getConf()).isSelStarNoCompute()) {
                Operator<OperatorDesc> child;
                assert (op.getNumChild() == 1);
                child = op.getChildOperators().get(0);
                if (child instanceof LateralViewJoinOperator) {
                    lvJoin = (LateralViewJoinOperator)child;
                }
            }
            List<String> cols = cppCtx.genColLists(op);
            SelectDesc conf = (SelectDesc)op.getConf();
            if (lvJoin != null) {
                if (cols != null) {
                    RowResolver rr = cppCtx.getOpToParseCtxMap().get(op).getRowResolver();
                    cppCtx.getPrunedColLists().put(op, cppCtx.getSelectColsFromLVJoin(rr, cols));
                }
                return null;
            }
            cppCtx.getPrunedColLists().put(op, cppCtx.getSelectColsFromChildren(op, cols));
            if (cols == null || conf.isSelStarNoCompute()) {
                return null;
            }
            List<ExprNodeDesc> originalColList = ((SelectDesc)op.getConf()).getColList();
            List<String> originalOutputColumnNames = conf.getOutputColumnNames();
            if (cols.size() < originalOutputColumnNames.size()) {
                ArrayList<ExprNodeDesc> newColList = new ArrayList<ExprNodeDesc>();
                ArrayList<String> newOutputColumnNames = new ArrayList<String>();
                ArrayList<ColumnInfo> rs_oldsignature = op.getSchema().getSignature();
                ArrayList<ColumnInfo> rs_newsignature = new ArrayList<ColumnInfo>();
                RowResolver old_rr = cppCtx.getOpToParseCtxMap().get(op).getRowResolver();
                RowResolver new_rr = new RowResolver();
                for (String col : cols) {
                    int index = originalOutputColumnNames.indexOf(col);
                    newOutputColumnNames.add(col);
                    newColList.add(originalColList.get(index));
                    rs_newsignature.add(rs_oldsignature.get(index));
                    String[] tabcol = old_rr.reverseLookup(col);
                    ColumnInfo columnInfo = old_rr.get(tabcol[0], tabcol[1]);
                    new_rr.put(tabcol[0], tabcol[1], columnInfo);
                }
                cppCtx.getOpToParseCtxMap().get(op).setRowResolver(new_rr);
                op.getSchema().setSignature(rs_newsignature);
                conf.setColList(newColList);
                conf.setOutputColumnNames(newOutputColumnNames);
                this.handleChildren(op, cols, cppCtx);
            }
            return null;
        }

        private void handleChildren(SelectOperator op, List<String> retainedSelOutputCols, ColumnPrunerProcCtx cppCtx) throws SemanticException {
            for (Operator<OperatorDesc> child : op.getChildOperators()) {
                if (child instanceof ReduceSinkOperator) {
                    boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(retainedSelOutputCols, (ReduceSinkOperator)child);
                    ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)child, cppCtx);
                    continue;
                }
                if (!(child instanceof FilterOperator)) continue;
                for (Operator<OperatorDesc> filterChild : child.getChildOperators()) {
                    if (!(filterChild instanceof ReduceSinkOperator)) continue;
                    boolean[] flags = ColumnPrunerProcFactory.getPruneReduceSinkOpRetainFlags(retainedSelOutputCols, (ReduceSinkOperator)filterChild);
                    ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, (ReduceSinkOperator)filterChild, cppCtx);
                }
            }
        }
    }

    public static class ColumnPrunerLateralViewForwardProc
    extends ColumnPrunerDefaultProc {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            super.process(nd, stack, ctx, nodeOutputs);
            LateralViewForwardOperator op = (LateralViewForwardOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            Operator<OperatorDesc> select = op.getChildOperators().get(0);
            List<String> cols = cppCtx.getPrunedColList(select);
            RowResolver rr = cppCtx.getOpToParseCtxMap().get(op).getRowResolver();
            ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
            ArrayList<String> outputColNames = new ArrayList<String>();
            for (String col : cols) {
                String[] tabcol = rr.reverseLookup(col);
                ColumnInfo colInfo = rr.get(tabcol[0], tabcol[1]);
                ExprNodeColumnDesc colExpr = new ExprNodeColumnDesc(colInfo);
                colList.add(colExpr);
                outputColNames.add(col);
            }
            ((SelectDesc)select.getConf()).setSelStarNoCompute(false);
            ((SelectDesc)select.getConf()).setColList(colList);
            ((SelectDesc)select.getConf()).setOutputColumnNames(outputColNames);
            ColumnPrunerProcFactory.pruneOperator(ctx, select, outputColNames);
            Operator<OperatorDesc> udtfPath = op.getChildOperators().get(1);
            List<String> lvFCols = new ArrayList<String>((Collection)cppCtx.getPrunedColLists().get(udtfPath));
            lvFCols = Utilities.mergeUniqElems(lvFCols, outputColNames);
            ColumnPrunerProcFactory.pruneOperator(ctx, op, lvFCols);
            return null;
        }
    }

    public static class ColumnPrunerLateralViewJoinProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            LateralViewJoinOperator op = (LateralViewJoinOperator)nd;
            List<String> cols = cppCtx.genColLists(op);
            if (cols == null) {
                return null;
            }
            Map<String, ExprNodeDesc> colExprMap = op.getColumnExprMap();
            ArrayList<String> outputCols = ((LateralViewJoinDesc)op.getConf()).getOutputInternalColNames();
            int numSelColumns = ((LateralViewJoinDesc)op.getConf()).getNumSelColumns();
            ArrayList<String> colsAfterReplacement = new ArrayList<String>();
            ArrayList<String> newColNames = new ArrayList<String>();
            for (String col : cols) {
                int index = outputCols.indexOf(col);
                if (index < 0 || index >= numSelColumns) continue;
                ExprNodeDesc transformed = colExprMap.get(col);
                Utilities.mergeUniqElems(colsAfterReplacement, transformed.getCols());
                newColNames.add(col);
            }
            ((LateralViewJoinDesc)op.getConf()).setNumSelColumns(newColNames.size());
            newColNames.addAll(outputCols.subList(numSelColumns, outputCols.size()));
            ((LateralViewJoinDesc)op.getConf()).setOutputInternalColNames(newColNames);
            ColumnPrunerProcFactory.pruneOperator(ctx, op, newColNames);
            cppCtx.getPrunedColLists().put(op, colsAfterReplacement);
            return null;
        }
    }

    public static class ColumnPrunerReduceSinkProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator op = (ReduceSinkOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            RowResolver resolver = cppCtx.getOpToParseCtxMap().get(op).getRowResolver();
            ReduceSinkDesc conf = (ReduceSinkDesc)op.getConf();
            List<String> colLists = new ArrayList<String>();
            ArrayList<ExprNodeDesc> keys = conf.getKeyCols();
            LOG.debug((Object)("Reduce Sink Operator " + op.getIdentifier() + " key:" + keys));
            for (ExprNodeDesc key : keys) {
                colLists = Utilities.mergeUniqElems(colLists, key.getCols());
            }
            for (ExprNodeDesc key : conf.getPartitionCols()) {
                colLists = Utilities.mergeUniqElems(colLists, key.getCols());
            }
            assert (op.getNumChild() == 1);
            Operator<OperatorDesc> child = op.getChildOperators().get(0);
            List<String> childCols = child instanceof CommonJoinOperator ? cppCtx.getJoinPrunedColLists().get(child).get((byte)conf.getTag()) : cppCtx.getPrunedColList(child);
            ArrayList<ExprNodeDesc> valCols = conf.getValueCols();
            ArrayList<String> valColNames = conf.getOutputValueColumnNames();
            if (childCols != null) {
                boolean[] flags = new boolean[valCols.size()];
                for (String childCol : childCols) {
                    int index = valColNames.indexOf(Utilities.removeValueTag(childCol));
                    if (index < 0) continue;
                    flags[index] = true;
                    colLists = Utilities.mergeUniqElems(colLists, ((ExprNodeDesc)valCols.get(index)).getCols());
                }
                Collections.sort(colLists);
                ColumnPrunerProcFactory.pruneReduceSinkOperator(flags, op, cppCtx);
                cppCtx.getPrunedColLists().put(op, colLists);
                return null;
            }
            for (ExprNodeDesc val : valCols) {
                colLists = Utilities.mergeUniqElems(colLists, val.getCols());
            }
            cppCtx.getPrunedColLists().put(op, colLists);
            return null;
        }
    }

    public static class ColumnPrunerTableScanProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator scanOp = (TableScanOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            ArrayList<String> cols = cppCtx.genColLists((Operator)nd);
            if (cols == null && !((TableScanDesc)scanOp.getConf()).isGatherStats()) {
                scanOp.setNeededColumnIDs(null);
                return null;
            }
            cols = cols == null ? new ArrayList<String>() : cols;
            cppCtx.getPrunedColLists().put((Operator)nd, cols);
            RowResolver inputRR = cppCtx.getOpToParseCtxMap().get(scanOp).getRowResolver();
            ColumnPrunerProcFactory.setupNeededColumns(scanOp, inputRR, cols);
            return null;
        }
    }

    public static class ColumnPrunerDefaultProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            cppCtx.getPrunedColLists().put((Operator)nd, cppCtx.genColLists((Operator)nd));
            return null;
        }
    }

    public static class ColumnPrunerPTFProc
    extends ColumnPrunerScriptProc {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            PTFOperator op = (PTFOperator)nd;
            PTFDesc conf = (PTFDesc)op.getConf();
            if (!conf.forWindowing() && !Noop.class.isInstance(conf.getFuncDef().getTFunction())) {
                return super.process(nd, stack, cppCtx, nodeOutputs);
            }
            List<String> prunedCols = cppCtx.getPrunedColList(op.getChildOperators().get(0));
            RowResolver oldRR = cppCtx.getOpToParseCtxMap().get(op).getRowResolver();
            WindowTableFunctionDef def = null;
            if (conf.forWindowing()) {
                def = (WindowTableFunctionDef)conf.getFuncDef();
                prunedCols = Utilities.mergeUniqElems(this.getWindowFunctionColumns(def), prunedCols);
                prunedCols = this.prunedColumnsList(prunedCols, def);
            }
            ArrayList<ColumnInfo> sig = new ArrayList<ColumnInfo>();
            RowResolver newRR = this.buildPrunedRR(prunedCols, oldRR, sig);
            cppCtx.getOpToParseCtxMap().get(op).setRowResolver(newRR);
            op.getSchema().setSignature(sig);
            prunedCols = def == null ? prunedCols : this.prunedInputList(prunedCols, def);
            cppCtx.getPrunedColLists().put(op, prunedCols);
            return null;
        }

        private RowResolver buildPrunedRR(List<String> prunedCols, RowResolver oldRR, ArrayList<ColumnInfo> sig) throws SemanticException {
            RowResolver newRR = new RowResolver();
            HashSet<String> prunedColsSet = new HashSet<String>(prunedCols);
            for (ColumnInfo cInfo : oldRR.getRowSchema().getSignature()) {
                if (!prunedColsSet.contains(cInfo.getInternalName())) continue;
                String[] nm = oldRR.reverseLookup(cInfo.getInternalName());
                newRR.put(nm[0], nm[1], cInfo);
                sig.add(cInfo);
            }
            return newRR;
        }

        private List<String> getWindowFunctionColumns(WindowTableFunctionDef tDef) {
            ArrayList<String> columns = new ArrayList<String>();
            if (tDef.getWindowFunctions() != null) {
                for (WindowFunctionDef wDef : tDef.getWindowFunctions()) {
                    columns.add(wDef.getAlias());
                }
            }
            return columns;
        }

        private ArrayList<String> prunedColumnsList(List<String> prunedCols, WindowTableFunctionDef tDef) {
            ExprNodeDesc exprNode;
            ArrayList<String> mergedColList = new ArrayList<String>(prunedCols);
            if (tDef.getWindowFunctions() != null) {
                for (WindowFunctionDef windowFunctionDef : tDef.getWindowFunctions()) {
                    if (windowFunctionDef.getArgs() == null) continue;
                    for (PTFExpressionDef arg : windowFunctionDef.getArgs()) {
                        ExprNodeDesc exprNode2 = arg.getExprNode();
                        Utilities.mergeUniqElems(mergedColList, exprNode2.getCols());
                    }
                }
            }
            if (tDef.getPartition() != null) {
                for (PTFExpressionDef pTFExpressionDef : tDef.getPartition().getExpressions()) {
                    exprNode = pTFExpressionDef.getExprNode();
                    Utilities.mergeUniqElems(mergedColList, exprNode.getCols());
                }
            }
            if (tDef.getOrder() != null) {
                for (PTFExpressionDef pTFExpressionDef : tDef.getOrder().getExpressions()) {
                    exprNode = pTFExpressionDef.getExprNode();
                    Utilities.mergeUniqElems(mergedColList, exprNode.getCols());
                }
            }
            return mergedColList;
        }

        private ArrayList<String> prunedInputList(List<String> prunedCols, WindowTableFunctionDef tDef) {
            ArrayList<String> prunedInputCols = new ArrayList<String>();
            StructObjectInspector OI = tDef.getInput().getOutputShape().getOI();
            for (StructField structField : OI.getAllStructFieldRefs()) {
                String fName = structField.getFieldName();
                if (!prunedCols.contains(fName)) continue;
                prunedInputCols.add(fName);
            }
            return prunedInputCols;
        }
    }

    public static class ColumnPrunerLimitProc
    extends ColumnPrunerDefaultProc {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            super.process(nd, stack, ctx, nodeOutputs);
            List<String> cols = ((ColumnPrunerProcCtx)ctx).getPrunedColLists().get(nd);
            if (null != cols) {
                ColumnPrunerProcFactory.pruneOperator(ctx, (LimitOperator)nd, cols);
            }
            return null;
        }
    }

    public static class ColumnPrunerScriptProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            Operator op = (Operator)nd;
            RowResolver inputRR = cppCtx.getParseContext().getOpParseCtx().get(op).getRowResolver();
            List<String> prunedCols = cppCtx.getPrunedColList(op.getChildOperators().get(0));
            Operator<OperatorDesc> parent = op.getParentOperators().get(0);
            RowResolver parentRR = cppCtx.getParseContext().getOpParseCtx().get(parent).getRowResolver();
            ArrayList<ColumnInfo> sig = parentRR.getRowSchema().getSignature();
            ArrayList<String> colList = new ArrayList<String>();
            for (ColumnInfo cI : sig) {
                colList.add(cI.getInternalName());
            }
            if (prunedCols.size() != inputRR.getRowSchema().getSignature().size() && !(op.getChildOperators().get(0) instanceof SelectOperator)) {
                ArrayList<ExprNodeDesc> exprs = new ArrayList<ExprNodeDesc>();
                ArrayList<String> outputs = new ArrayList<String>();
                HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
                RowResolver outputRS = new RowResolver();
                for (String internalName : prunedCols) {
                    String[] nm = inputRR.reverseLookup(internalName);
                    ColumnInfo valueInfo = inputRR.get(nm[0], nm[1]);
                    ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc(valueInfo.getType(), valueInfo.getInternalName(), nm[0], valueInfo.getIsVirtualCol());
                    exprs.add(colDesc);
                    outputs.add(internalName);
                    outputRS.put(nm[0], nm[1], new ColumnInfo(internalName, valueInfo.getType(), nm[0], valueInfo.getIsVirtualCol(), valueInfo.isHiddenVirtualCol()));
                    colExprMap.put(internalName, colDesc);
                }
                SelectDesc select = new SelectDesc(exprs, outputs, false);
                Operator<OperatorDesc> child = op.getChildOperators().get(0);
                op.removeChild(child);
                SelectOperator sel = (SelectOperator)OperatorFactory.getAndMakeChild(select, new RowSchema(outputRS.getColumnInfos()), op);
                OperatorFactory.makeChild(sel, child);
                OpParseContext parseCtx = new OpParseContext(outputRS);
                cppCtx.getParseContext().getOpParseCtx().put(sel, parseCtx);
                sel.setColumnExprMap(colExprMap);
            }
            cppCtx.getPrunedColLists().put(op, colList);
            return null;
        }
    }

    public static class ColumnPrunerGroupByProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            String groupingColumn;
            List<String> cols;
            GroupByOperator op = (GroupByOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            List<String> colLists = new ArrayList<String>();
            GroupByDesc conf = (GroupByDesc)op.getConf();
            ArrayList<ExprNodeDesc> keys = conf.getKeys();
            for (ExprNodeDesc key : keys) {
                colLists = Utilities.mergeUniqElems(colLists, key.getCols());
            }
            ArrayList<AggregationDesc> aggrs = conf.getAggregators();
            for (AggregationDesc aggr : aggrs) {
                ArrayList<ExprNodeDesc> params = aggr.getParameters();
                for (ExprNodeDesc param : params) {
                    colLists = Utilities.mergeUniqElems(colLists, param.getCols());
                }
            }
            int groupingSetPosition = conf.getGroupingSetPosition();
            if (groupingSetPosition >= 0 && !(cols = cppCtx.genColLists(op)).contains(groupingColumn = conf.getOutputColumnNames().get(groupingSetPosition))) {
                conf.getOutputColumnNames().remove(groupingSetPosition);
                if (op.getSchema() != null) {
                    op.getSchema().getSignature().remove(groupingSetPosition);
                }
            }
            cppCtx.getPrunedColLists().put(op, colLists);
            return null;
        }
    }

    public static class ColumnPrunerFilterProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx ctx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator op = (FilterOperator)nd;
            ColumnPrunerProcCtx cppCtx = (ColumnPrunerProcCtx)ctx;
            ExprNodeDesc condn = ((FilterDesc)op.getConf()).getPredicate();
            List<String> cl = condn.getCols();
            List<String> filterOpPrunedColLists = Utilities.mergeUniqElems(cppCtx.genColLists(op), cl);
            List filterOpPrunedColListsOrderPreserved = ColumnPrunerProcFactory.preserveColumnOrder(op, filterOpPrunedColLists);
            cppCtx.getPrunedColLists().put(op, filterOpPrunedColListsOrderPreserved);
            ColumnPrunerProcFactory.pruneOperator(cppCtx, op, cppCtx.getPrunedColLists().get(op));
            return null;
        }
    }
}

