/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.ReadOption;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.io.ByteBufferPool;
import org.apache.hadoop.io.compress.DirectDecompressor;
import org.apache.hadoop.io.compress.snappy.SnappyDecompressor;
import org.apache.hadoop.io.compress.zlib.ZlibDecompressor;

class ZeroCopyShims {
    ZeroCopyShims() {
    }

    public static HadoopShims.ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream in, HadoopShims.ByteBufferPoolShim pool) throws IOException {
        return new ZeroCopyAdapter(in, pool);
    }

    public static HadoopShims.DirectDecompressorShim getDirectDecompressor(HadoopShims.DirectCompressionType codec) {
        ZlibDecompressor.ZlibDirectDecompressor decompressor = null;
        switch (codec) {
            case ZLIB: {
                decompressor = new ZlibDecompressor.ZlibDirectDecompressor();
                break;
            }
            case ZLIB_NOHEADER: {
                decompressor = new ZlibDecompressor.ZlibDirectDecompressor(ZlibDecompressor.CompressionHeader.NO_HEADER, 0);
                break;
            }
            case SNAPPY: {
                decompressor = new SnappyDecompressor.SnappyDirectDecompressor();
            }
        }
        if (decompressor != null) {
            return new DirectDecompressorAdapter((DirectDecompressor)decompressor);
        }
        return null;
    }

    private static final class DirectDecompressorAdapter
    implements HadoopShims.DirectDecompressorShim {
        private final DirectDecompressor decompressor;

        public DirectDecompressorAdapter(DirectDecompressor decompressor) {
            this.decompressor = decompressor;
        }

        @Override
        public void decompress(ByteBuffer src, ByteBuffer dst) throws IOException {
            this.decompressor.decompress(src, dst);
        }
    }

    private static final class ZeroCopyAdapter
    implements HadoopShims.ZeroCopyReaderShim {
        private final FSDataInputStream in;
        private final ByteBufferPoolAdapter pool;
        private static final EnumSet<ReadOption> CHECK_SUM = EnumSet.noneOf(ReadOption.class);
        private static final EnumSet<ReadOption> NO_CHECK_SUM = EnumSet.of(ReadOption.SKIP_CHECKSUMS);

        public ZeroCopyAdapter(FSDataInputStream in, HadoopShims.ByteBufferPoolShim poolshim) {
            this.in = in;
            this.pool = poolshim != null ? new ByteBufferPoolAdapter(poolshim) : null;
        }

        @Override
        public final ByteBuffer readBuffer(int maxLength, boolean verifyChecksums) throws IOException {
            EnumSet<ReadOption> options = NO_CHECK_SUM;
            if (verifyChecksums) {
                options = CHECK_SUM;
            }
            return this.in.read((ByteBufferPool)this.pool, maxLength, options);
        }

        @Override
        public final void releaseBuffer(ByteBuffer buffer) {
            this.in.releaseBuffer(buffer);
        }
    }

    private static final class ByteBufferPoolAdapter
    implements ByteBufferPool {
        private HadoopShims.ByteBufferPoolShim pool;

        public ByteBufferPoolAdapter(HadoopShims.ByteBufferPoolShim pool) {
            this.pool = pool;
        }

        public final ByteBuffer getBuffer(boolean direct, int length) {
            return this.pool.getBuffer(direct, length);
        }

        public final void putBuffer(ByteBuffer buffer) {
            this.pool.putBuffer(buffer);
        }
    }
}

