/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.jobhistory.FileNameIndexUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobIndexInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.ApplicationId;

@InterfaceAudience.Private
public class KilledHistoryService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(KilledHistoryService.class);
    private static final Pattern FLAG_FILE_PATTERN = Pattern.compile("(\\S+)_appattempt_(\\d+)_(\\d+)_(\\d+)");
    private static final Pattern SUBMIT_TIME_PATTERN = Pattern.compile("submitTime=(\\d+)");
    private static final Pattern FINISH_TIME_PATTERN = Pattern.compile("finishTime=(\\d+)");
    private static final Pattern JOB_NAME_PATTERN = Pattern.compile("jobName=([^,]+)");
    private static final Pattern NUM_MAPS_PATTERN = Pattern.compile("numMaps=(\\d+)");
    private static final Pattern NUM_REDUCES_PATTERN = Pattern.compile("numReduces=(\\d+)");
    private static final Pattern STATUS_PATTERN = Pattern.compile("status=([^,]+)");
    private static final Pattern QUEUE_PATTERN = Pattern.compile("queue=([^,]+)");
    private Timer timer = null;
    private long checkIntervalMsecs;

    protected void serviceInit(Configuration conf) throws Exception {
        this.checkIntervalMsecs = conf.getLong("mapreduce.jobhistory.move.interval-ms", 180000L);
        super.serviceInit(conf);
    }

    public KilledHistoryService() {
        super(KilledHistoryService.class.getName());
    }

    protected void serviceStart() throws Exception {
        this.scheduleFlagHandlerTask();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopTimer();
        super.serviceStop();
    }

    private void scheduleFlagHandlerTask() throws IOException {
        Configuration conf = this.getConfig();
        FlagFileHandler task = new FlagFileHandler(conf);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)task, 0L, this.checkIntervalMsecs);
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    static class FlagFileHandler
    extends TimerTask {
        private final Configuration conf;
        private Path failDir = null;
        private String intermediateDirPrefix = null;

        public FlagFileHandler(Configuration conf) throws IOException {
            this.conf = conf;
            this.failDir = new Path(conf.get("yarn.am-failure.flag.dir", "/tmp/hadoop-yarn/fail"));
            this.intermediateDirPrefix = JobHistoryUtils.getConfiguredHistoryIntermediateDoneDirPrefix((Configuration)conf);
        }

        @Override
        public void run() {
            try {
                FileSystem failDirFS = this.failDir.getFileSystem(this.conf);
                if (failDirFS.exists(this.failDir)) {
                    for (FileStatus flagFileStatus : failDirFS.listStatus(this.failDir)) {
                        String flagFileName = flagFileStatus.getPath().getName();
                        Matcher m = FLAG_FILE_PATTERN.matcher(flagFileName);
                        if (m.matches()) {
                            final String user = m.group(1);
                            long timestamp = Long.parseLong(m.group(2));
                            int appId = Integer.parseInt(m.group(3));
                            final int attempt = Integer.parseInt(m.group(4));
                            ApplicationId applicationId = ApplicationId.newInstance((long)timestamp, (int)appId);
                            final JobId jobId = TypeConverter.toYarn((JobID)TypeConverter.fromYarn((ApplicationId)applicationId));
                            final Path intermediateDir = new Path(this.intermediateDirPrefix, user);
                            final Path stagingDirForJob = new Path(MRApps.getStagingAreaDir((Configuration)this.conf, (String)user), jobId.toString());
                            try {
                                final Path inSummaryFile = new Path(stagingDirForJob, JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobId));
                                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getCurrentUser());
                                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public Void run() throws IOException {
                                        FileSystem fromFs = null;
                                        FileSystem toFs = null;
                                        try {
                                            fromFs = stagingDirForJob.getFileSystem(FlagFileHandler.this.conf);
                                            toFs = intermediateDir.getFileSystem(FlagFileHandler.this.conf);
                                            JobIndexInfo jobIndexInfo = FlagFileHandler.this.buildJobIndexInfo(fromFs, inSummaryFile, jobId, user);
                                            String historyFilename = FileNameIndexUtils.getDoneFileName((JobIndexInfo)jobIndexInfo);
                                            FlagFileHandler.this.copy(fromFs, toFs, JobHistoryUtils.getStagingConfFile((Path)stagingDirForJob, (JobId)jobId, (int)attempt), new Path(intermediateDir, JobHistoryUtils.getIntermediateConfFileName((JobId)jobId)));
                                            FlagFileHandler.this.copy(fromFs, toFs, inSummaryFile, new Path(intermediateDir, JobHistoryUtils.getIntermediateSummaryFileName((JobId)jobId)));
                                            FlagFileHandler.this.copy(fromFs, toFs, JobHistoryUtils.getStagingJobHistoryFile((Path)stagingDirForJob, (JobId)jobId, (int)attempt), new Path(intermediateDir, historyFilename));
                                            Void void_ = null;
                                            return void_;
                                        }
                                        finally {
                                            if (fromFs != null) {
                                                fromFs.close();
                                            }
                                            if (toFs != null) {
                                                toFs.close();
                                            }
                                        }
                                    }
                                });
                                failDirFS.delete(flagFileStatus.getPath(), false);
                            }
                            catch (IOException ioe) {
                                this.removeFlagFileWithMessage(failDirFS, flagFileStatus.getPath(), "Could not process job files", ioe);
                            }
                            catch (InterruptedException ie) {
                                this.removeFlagFileWithMessage(failDirFS, flagFileStatus.getPath(), "Could not process job files", ie);
                            }
                            continue;
                        }
                        this.removeFlagFileWithMessage(failDirFS, flagFileStatus.getPath(), "Could not process fail flag file", null);
                    }
                }
            }
            catch (IOException ioe) {
                LOG.info((Object)"Could not access fail flag dir", (Throwable)ioe);
            }
        }

        private void removeFlagFileWithMessage(FileSystem failDirFS, Path flagFile, String message, Exception ex) {
            if (ex == null) {
                LOG.warn((Object)message);
            } else {
                LOG.warn((Object)message, (Throwable)ex);
            }
            try {
                failDirFS.delete(flagFile, false);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }

        private void copy(FileSystem fromFs, FileSystem toFs, Path fromPath, Path toPath) throws IOException {
            LOG.info((Object)("Copying " + fromPath.toString() + " to " + toPath.toString()));
            boolean copied = FileUtil.copy((FileSystem)toFs, (Path)fromPath, (FileSystem)fromFs, (Path)toPath, (boolean)false, (Configuration)this.conf);
            if (copied) {
                LOG.info((Object)("Copied to done location: " + toPath));
            } else {
                LOG.info((Object)"copy failed");
            }
            toFs.setPermission(toPath, new FsPermission(JobHistoryUtils.HISTORY_INTERMEDIATE_FILE_PERMISSIONS));
        }

        private JobIndexInfo buildJobIndexInfo(FileSystem fs, Path summaryFile, JobId jobId, String user) throws IOException {
            String jobStatus;
            int numReduces;
            FSDataInputStream in = fs.open(summaryFile);
            String summaryString = in.readUTF();
            in.close();
            long submitTime = this.extractLong(SUBMIT_TIME_PATTERN, summaryString, "submitTime");
            long finishTime = this.extractLong(FINISH_TIME_PATTERN, summaryString, "finishTime");
            if (finishTime == 0L) {
                finishTime = submitTime;
            }
            String jobName = this.extractString(JOB_NAME_PATTERN, summaryString, "jobName");
            int numMaps = this.extractInt(NUM_MAPS_PATTERN, summaryString, "numMaps");
            if (numMaps == 0) {
                numMaps = -1;
            }
            if ((numReduces = this.extractInt(NUM_REDUCES_PATTERN, summaryString, "numReduces")) == 0) {
                numReduces = -1;
            }
            if ((jobStatus = this.extractString(STATUS_PATTERN, summaryString, "status")).equals("null")) {
                jobStatus = "FAILED";
            }
            String queue = this.extractString(QUEUE_PATTERN, summaryString, "queue");
            JobIndexInfo info = new JobIndexInfo(submitTime, finishTime, user, jobName, jobId, numMaps, numReduces, jobStatus);
            info.setQueueName(queue);
            return info;
        }

        private String extractString(Pattern pattern, String str, String type) throws IOException {
            String result = null;
            Matcher m = pattern.matcher(str);
            if (!m.find()) {
                throw new IOException("Could not extract " + type + " field from summary file");
            }
            result = m.group(1);
            return result;
        }

        private long extractLong(Pattern pattern, String str, String type) throws IOException {
            String result = this.extractString(pattern, str, type);
            return result == null ? -1L : Long.parseLong(result);
        }

        private int extractInt(Pattern pattern, String str, String type) throws IOException {
            String result = this.extractString(pattern, str, type);
            return result == null ? -1 : Integer.parseInt(result);
        }
    }
}

