/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.internal.Lists;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.kitesdk.cli.commands.BaseCommand;
import org.kitesdk.data.Datasets;
import org.kitesdk.data.URIBuilder;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.DatasetRepositories;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.Registration;
import org.slf4j.Logger;

abstract class BaseDatasetCommand
extends BaseCommand {
    @Parameter(names={"-d", "--directory"}, hidden=true, description="Storage directory for datasets, required for HDFS")
    String directory = null;
    @Parameter(names={"--namespace"}, hidden=true, description="Namespace for datasets")
    String namespace = "default";
    @Parameter(names={"--use-local"}, hidden=true, description="Store data in local files")
    boolean local = false;
    @Parameter(names={"--use-hdfs"}, hidden=true, description="Store data in HDFS files")
    boolean hdfs = false;
    @Parameter(names={"--use-hive"}, hidden=true, description="Store data in Hive managed tables (default)")
    boolean hive = false;
    @Parameter(names={"--use-hbase"}, hidden=true, description="Store data in HBase tables")
    boolean hbase = false;
    @Parameter(names={"--zookeeper", "--zk"}, hidden=true, description="ZooKeeper host list as host or host:port")
    List<String> zookeeper = Lists.newArrayList((Object[])new String[]{"localhost"});
    @Parameter(names={"-r", "--repo"}, hidden=true, description="The repository URI to open")
    @VisibleForTesting
    String repoURI = null;
    protected final Logger console;
    private DatasetRepository repo = null;

    public BaseDatasetCommand(Logger console) {
        this.console = console;
    }

    protected DatasetRepository getDatasetRepository() {
        if (this.repo == null) {
            this.repo = DatasetRepositories.repositoryFor((String)this.buildRepoURI());
        }
        return this.repo;
    }

    protected static Map<String, String> optionsForUri(URI uri) {
        Preconditions.checkArgument((boolean)BaseDatasetCommand.isDatasetOrViewUri(uri.toString()), (Object)("Must be a dataset or view URI: " + uri));
        return (Map)Registration.lookupDatasetUri((URI)URI.create(uri.getSchemeSpecificPart())).second();
    }

    protected static boolean isViewUri(String uriOrName) {
        return uriOrName.startsWith("view:");
    }

    protected static boolean isDatasetUri(String uriOrName) {
        return uriOrName.startsWith("dataset:");
    }

    protected static boolean isDatasetOrViewUri(String uriOrName) {
        return BaseDatasetCommand.isDatasetUri(uriOrName) || BaseDatasetCommand.isViewUri(uriOrName);
    }

    protected static boolean isRepoUri(String uriOrName) {
        return uriOrName.startsWith("repo:");
    }

    protected <E> View<E> load(String uriOrName, Class<E> type) {
        if (BaseDatasetCommand.isDatasetOrViewUri(uriOrName)) {
            return Datasets.load((String)uriOrName, type);
        }
        return this.getDatasetRepository().load(this.namespace, uriOrName, type);
    }

    protected View<GenericRecord> load(String uriOrName) {
        if (BaseDatasetCommand.isDatasetOrViewUri(uriOrName)) {
            return Datasets.load((String)uriOrName);
        }
        return this.getDatasetRepository().load(this.namespace, uriOrName);
    }

    @VisibleForTesting
    public String buildRepoURI() {
        String uri;
        if (this.repoURI != null) {
            if (this.repoURI.startsWith("repo:")) {
                return this.repoURI;
            }
            return "repo:" + this.repoURI;
        }
        if (this.local) {
            Preconditions.checkArgument((!this.hdfs && !this.hive && !this.hbase ? 1 : 0) != 0, (Object)"Only one storage implementation can be selected");
            Preconditions.checkArgument((this.directory != null ? 1 : 0) != 0, (Object)"--directory is required when using local files");
            uri = "repo:file:" + this.directory;
        } else if (this.hdfs) {
            Preconditions.checkArgument((!this.hive && !this.hbase ? 1 : 0) != 0, (Object)"Only one storage implementation can be selected");
            Preconditions.checkArgument((this.directory != null ? 1 : 0) != 0, (Object)"--directory is required when using HDFS");
            uri = "repo:hdfs:" + this.directory;
        } else if (this.hbase) {
            Preconditions.checkArgument((!this.hive ? 1 : 0) != 0, (Object)"Only one storage implementation can be selected");
            Preconditions.checkArgument((this.zookeeper != null && !this.zookeeper.isEmpty() ? 1 : 0) != 0, (Object)"--zookeeper is required when using HBase");
            uri = "repo:hbase:" + Joiner.on((String)",").join(this.zookeeper);
        } else {
            uri = "repo:hive" + (this.directory != null ? ":" + this.directory : "");
        }
        this.console.trace("Repository URI: " + uri);
        return uri;
    }

    String buildDatasetUri(String uriOrName) {
        if (BaseDatasetCommand.isDatasetOrViewUri(uriOrName)) {
            return uriOrName;
        }
        return new URIBuilder(this.buildRepoURI(), this.namespace, uriOrName).build().toString();
    }

    @VisibleForTesting
    static boolean viewMatches(URI view, String requested) {
        Map<String, String> requestedOptions = BaseDatasetCommand.optionsForUri(URI.create(requested));
        Map<String, String> finalOptions = BaseDatasetCommand.optionsForUri(view);
        for (Map.Entry<String, String> entry : requestedOptions.entrySet()) {
            if (finalOptions.containsKey(entry.getKey()) && finalOptions.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

