/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.crunch.PipelineResult;
import org.apache.crunch.Target;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.View;
import org.kitesdk.tools.CopyTask;
import org.slf4j.Logger;

@Parameters(commandDescription="Copy records from one Dataset to another")
public class CopyCommand
extends BaseDatasetCommand {
    @Parameter(description="<source dataset> <destination dataset>")
    List<String> datasets;
    @Parameter(names={"--no-compaction"}, description="Copy to output directly, without compacting the data")
    boolean noCompaction = false;
    @Parameter(names={"--num-writers"}, description="The number of writer processes to use")
    int numWriters = -1;
    @Parameter(names={"--files-per-partition"}, description="The number of files per partition to create")
    int filesPerPartition = -1;
    @Parameter(names={"--overwrite"}, description="Remove any data already in the target view or dataset")
    boolean overwrite = false;

    public CopyCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        PipelineResult result;
        Preconditions.checkArgument((this.datasets != null && this.datasets.size() > 1 ? 1 : 0) != 0, (Object)"Source and target datasets are required");
        Preconditions.checkArgument((this.datasets.size() == 2 ? 1 : 0) != 0, (Object)"Cannot copy multiple datasets");
        View<GenericRecord> dest = this.load(this.datasets.get(1));
        View source = this.load(this.datasets.get(0)).asSchema(dest.getSchema());
        CopyTask<GenericRecord> task = new CopyTask<GenericRecord>(source, dest);
        task.setConf(this.getConf());
        if (this.noCompaction) {
            task.noCompaction();
        }
        if (this.numWriters >= 0) {
            task.setNumWriters(this.numWriters);
        }
        if (this.filesPerPartition > 0) {
            task.setFilesPerPartition(this.filesPerPartition);
        }
        if (this.overwrite) {
            task.setWriteMode(Target.WriteMode.OVERWRITE);
        }
        if ((result = task.run()).succeeded()) {
            this.console.info("Added {} records to \"{}\"", (Object)task.getCount(), (Object)this.datasets.get(1));
            return 0;
        }
        return 1;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Copy the contents of movies_avro to movies_parquet", "movies_avro movies_parquet", "# Copy the movies dataset into HBase in a map-only job", "movies dataset:hbase:zk-host/movies --no-compaction"});
    }
}

