/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Maps;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import org.apache.avro.Schema;
import org.apache.crunch.DoFn;
import org.apache.crunch.PipelineResult;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.compat.DynConstructors;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.DatasetException;
import org.kitesdk.data.Formats;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.ColumnMappingParser;
import org.kitesdk.data.spi.PartitionStrategyParser;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.filesystem.InputFormatUtil;
import org.kitesdk.data.spi.filesystem.TemporaryFileSystemDatasetRepository;
import org.kitesdk.tools.CopyTask;
import org.kitesdk.tools.TaskUtil;
import org.kitesdk.tools.TransformTask;
import org.slf4j.Logger;

@Parameters(commandDescription="Import records into a Dataset using an existing InputFormat")
public class InputFormatImportCommand
extends BaseDatasetCommand {
    @Parameter(description="<data path> <dataset>")
    List<String> targets;
    @Parameter(names={"--format"}, description="An InputFormat class")
    String inFormatClass = null;
    @Parameter(names={"--record-type"}, description="InputFormat argument to use as the record (key or value)")
    String recordType = InputFormatUtil.RecordType.VALUE.toString();
    @DynamicParameter(names={"--set"}, description="Configuration settings")
    private Map<String, String> properties = Maps.newHashMap();
    @Parameter(names={"--no-compaction"}, description="Copy to output directly, without compacting the data")
    boolean noCompaction = false;
    @Parameter(names={"--num-writers"}, description="The number of writer processes to use")
    int numWriters = -1;
    @Parameter(names={"--transform"}, description="A transform DoFn class name")
    String transform = null;
    @Parameter(names={"--jar"}, description="Add a jar to the runtime classpath")
    List<String> jars;

    public InputFormatImportCommand(Logger console) {
        super(console);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"DM_CONVERT_CASE"}, justification="For record types only")
    public int run() throws IOException {
        Preconditions.checkArgument((this.targets != null && this.targets.size() == 2 ? 1 : 0) != 0, (Object)"Data path and target dataset are required.");
        Path source = this.qualifiedPath(this.targets.get(0));
        FileSystem sourceFS = source.getFileSystem(this.getConf());
        Preconditions.checkArgument((boolean)sourceFS.exists(source), (Object)("Data path does not exist: " + source));
        InputFormatUtil.RecordType.valueOf((String)this.recordType.trim().toUpperCase());
        String dataset = this.targets.get(1);
        View<Object> target = this.load(dataset, Object.class);
        Schema schema = target.getDataset().getDescriptor().getSchema();
        DatasetDescriptor.Builder descriptorBuilder = new DatasetDescriptor.Builder().location(source.toUri()).property("kite.inputformat.class", this.inFormatClass).property("kite.inputformat.record-type", this.recordType).format(Formats.INPUTFORMAT).schema(ColumnMappingParser.removeEmbeddedMapping((Schema)PartitionStrategyParser.removeEmbeddedStrategy((Schema)schema)));
        for (Map.Entry<String, String> prop : this.properties.entrySet()) {
            descriptorBuilder.property(prop.getKey(), prop.getValue());
        }
        DatasetDescriptor inDescriptor = descriptorBuilder.build();
        TemporaryFileSystemDatasetRepository repo = new TemporaryFileSystemDatasetRepository(this.getConf(), sourceFS.makeQualified(new Path("/tmp")), target.getDataset().getNamespace(), UUID.randomUUID().toString());
        ClassLoader loader = InputFormatImportCommand.loaderForJars(this.jars);
        try {
            PipelineResult result;
            TransformTask task;
            FileSystemDataset inDataset = (FileSystemDataset)repo.create("import", "inputformat", inDescriptor);
            Iterator iter = inDataset.pathIterator().iterator();
            Preconditions.checkArgument((boolean)iter.hasNext(), (Object)("Data path has no data files: " + source));
            TaskUtil.configure(this.getConf()).addJars(this.jars);
            if (this.transform != null) {
                DoFn transformFn;
                try {
                    DynConstructors.Ctor ctor = new DynConstructors.Builder(DoFn.class).loader(loader).impl(this.transform, new Class[0]).buildChecked();
                    transformFn = (DoFn)ctor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new DatasetException("Cannot find no-arg constructor for class: " + this.transform, (Throwable)e);
                }
                task = new TransformTask(inDataset, target, transformFn);
            } else {
                task = new CopyTask<Object>((View<Object>)inDataset, target);
            }
            task.setConf(this.getConf());
            if (this.noCompaction) {
                task.noCompaction();
            }
            if (this.numWriters >= 0) {
                task.setNumWriters(this.numWriters);
            }
            try {
                result = InputFormatImportCommand.runTaskWithClassLoader(task, loader);
            }
            catch (InterruptedException e) {
                int n = 1;
                repo.delete();
                return n;
            }
            if (result.succeeded()) {
                long count = task.getCount();
                if (count > 0L) {
                    this.console.info("Added {} records to \"{}\"", (Object)count, (Object)dataset);
                }
                int n = 0;
                return n;
            }
            int n = 1;
            return n;
        }
        finally {
            repo.delete();
        }
    }

    @Override
    public List<String> getExamples() {
        return ImmutableList.of((Object)"# Import the keys of a custom input format", (Object)"file.sequence target_table --jar tr.jar --record-type key --format com.company.InFormat --transform com.company.Transform");
    }

    private static PipelineResult runTaskWithClassLoader(final TransformTask task, final ClassLoader loader) throws IOException, InterruptedException {
        FutureTask<PipelineResult> future = new FutureTask<PipelineResult>(new Callable<PipelineResult>(){

            @Override
            public PipelineResult call() throws Exception {
                return task.run();
            }
        });
        Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread taskThread = new Thread(r, "transform-task");
                taskThread.setContextClassLoader(loader);
                return taskThread;
            }
        }).execute(future);
        try {
            return (PipelineResult)future.get();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e.getCause(), IOException.class);
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }
}

