/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Lists;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.avro.Schema;
import org.kitesdk.cli.commands.BaseCommand;
import org.kitesdk.data.spi.JsonUtil;
import org.slf4j.Logger;

@Parameters(commandDescription="Build a schema from a JSON data sample")
public class JSONSchemaCommand
extends BaseCommand {
    @VisibleForTesting
    static final Charset SCHEMA_CHARSET = Charset.forName("utf8");
    private final Logger console;
    @Parameter(description="<sample json path>")
    List<String> samplePaths;
    @Parameter(names={"-o", "--output"}, description="Save schema avsc to path")
    @SuppressWarnings(value={"UWF_NULL_FIELD"}, justification="Field set by JCommander")
    String outputPath = null;
    @Parameter(names={"--class", "--record-name"}, required=true, description="A name or class for the result schema")
    @SuppressWarnings(value={"UWF_NULL_FIELD"}, justification="Field set by JCommander")
    String recordName = null;
    @Parameter(names={"--minimize"}, description="Minimize schema file size by eliminating white space")
    boolean minimize = false;

    public JSONSchemaCommand(Logger console) {
        this.console = console;
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.samplePaths != null && !this.samplePaths.isEmpty() ? 1 : 0) != 0, (Object)"Sample JSON path is required");
        Preconditions.checkArgument((this.samplePaths.size() == 1 ? 1 : 0) != 0, (Object)"Only one JSON sample can be given");
        Schema sampleSchema = JsonUtil.inferSchema((InputStream)this.open(this.samplePaths.get(0)), (String)this.recordName, (int)10);
        if (sampleSchema != null) {
            this.output(sampleSchema.toString(!this.minimize), this.console, this.outputPath);
            return 0;
        }
        this.console.error("Sample file did not contain any records");
        return 1;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Print the schema for samples.json to standard out:", "samples.json --record-name Sample", "# Write schema to sample.avsc:", "samples.json -o sample.avsc --record-name Sample"});
    }
}

