/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.kitesdk.cli.commands.BaseDatasetCommand;
import org.kitesdk.data.Datasets;
import org.slf4j.Logger;

@Parameters(commandDescription="Find dataset URIs")
public class ListCommand
extends BaseDatasetCommand {
    @Parameter(description="[repository-uris]")
    List<String> repos;

    public ListCommand(Logger console) {
        super(console);
    }

    @Override
    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="Null case checked by precondition")
    public int run() throws IOException {
        if (this.repos == null || this.repos.isEmpty()) {
            ListCommand.printDatasetUris(this.console, this.getDatasetRepository().getUri());
        } else {
            for (String repo : this.repos) {
                ListCommand.printDatasetUris(this.console, URI.create(repo));
            }
        }
        return 0;
    }

    private static void printDatasetUris(Logger console, URI repoUri) {
        for (URI datasetUri : Datasets.list((URI)repoUri)) {
            console.info(datasetUri.toString());
        }
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Print all Hive dataset URIs", "", "# Print all URIs in a HDFS repository", "repo:hdfs:/data"});
    }
}

