/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.tools;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.crunch.PipelineResult;
import org.apache.crunch.Target;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.View;
import org.kitesdk.data.spi.Replaceable;
import org.kitesdk.tools.CopyTask;

public class CompactionTask<T>
implements Configurable {
    private final CopyTask<T> task;

    public CompactionTask(View<T> view) {
        this.checkCompactable(view);
        this.task = new CopyTask<T>(view, view);
        this.task.setWriteMode(Target.WriteMode.OVERWRITE);
    }

    public long getCount() {
        return this.task.getCount();
    }

    public CompactionTask setNumWriters(int numWriters) {
        this.task.setNumWriters(numWriters);
        return this;
    }

    public PipelineResult run() throws IOException {
        return this.task.run();
    }

    public void setConf(Configuration configuration) {
        this.task.setConf(configuration);
    }

    public Configuration getConf() {
        return this.task.getConf();
    }

    public void setFilesPerPartition(int filesPerPartition) {
        this.task.setFilesPerPartition(filesPerPartition);
    }

    private void checkCompactable(View<T> view) {
        Dataset dataset = view.getDataset();
        if (!(dataset instanceof Replaceable)) {
            throw new IllegalArgumentException("Cannot compact dataset: " + dataset);
        }
        Replaceable replaceable = (Replaceable)dataset;
        Preconditions.checkArgument((boolean)replaceable.canReplace(view), (Object)("Cannot compact view: " + view));
    }
}

