/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.boundedint;

import parquet.Log;
import parquet.bytes.BytesInput;
import parquet.bytes.CapacityByteArrayOutputStream;

class BitWriter {
    private static final Log LOG = Log.getLog(BitWriter.class);
    private static final boolean DEBUG = false;
    private CapacityByteArrayOutputStream baos;
    private int currentByte = 0;
    private int currentBytePosition = 0;
    private static final int[] byteToTrueMask = new int[8];
    private static final int[] byteToFalseMask = new int[8];
    private boolean finished = false;

    public BitWriter(int initialCapacity, int pageSize) {
        this.baos = new CapacityByteArrayOutputStream(initialCapacity, pageSize);
    }

    public void writeBit(boolean bit) {
        this.currentByte = BitWriter.setBytePosition(this.currentByte, this.currentBytePosition++, bit);
        if (this.currentBytePosition == 8) {
            this.baos.write(this.currentByte);
            this.currentByte = 0;
            this.currentBytePosition = 0;
        }
    }

    public void writeByte(int val) {
        this.currentByte |= (val & 0xFF) << this.currentBytePosition;
        this.baos.write(this.currentByte);
        this.currentByte >>>= 8;
    }

    public void writeNBitInteger(int val, int bitsToWrite) {
        int upperByte = this.currentBytePosition + bitsToWrite;
        this.currentByte |= (val <<= this.currentBytePosition);
        while (upperByte >= 8) {
            this.baos.write(this.currentByte);
            upperByte -= 8;
            this.currentByte >>>= 8;
        }
        this.currentBytePosition = (this.currentBytePosition + bitsToWrite) % 8;
    }

    private String toBinary(int val, int alignTo) {
        String result = Integer.toBinaryString(val);
        while (result.length() < alignTo) {
            result = "0" + result;
        }
        return result;
    }

    private String toBinary(int val) {
        return this.toBinary(val, 8);
    }

    public BytesInput finish() {
        if (!this.finished && this.currentBytePosition > 0) {
            this.baos.write(this.currentByte);
        }
        this.finished = true;
        return BytesInput.from(this.baos);
    }

    public void reset() {
        this.baos.reset();
        this.currentByte = 0;
        this.currentBytePosition = 0;
        this.finished = false;
    }

    private static int setBytePosition(int currentByte, int bitOffset, boolean newBitValue) {
        currentByte = newBitValue ? (currentByte |= byteToTrueMask[bitOffset]) : (currentByte &= byteToFalseMask[bitOffset]);
        return currentByte;
    }

    public void writeUnsignedVarint(int value) {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            this.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        this.writeByte(value & 0x7F);
    }

    public int getMemSize() {
        return 32 + (int)this.baos.size();
    }

    public int getCapacity() {
        return this.baos.getCapacity();
    }

    public String memUsageString(String prefix) {
        return this.baos.memUsageString(prefix);
    }

    static {
        int currentMask = 1;
        for (int i = 0; i < byteToTrueMask.length; ++i) {
            BitWriter.byteToTrueMask[i] = currentMask;
            BitWriter.byteToFalseMask[i] = ~currentMask;
            currentMask <<= 1;
        }
    }
}

