/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import parquet.column.ColumnDescriptor;
import parquet.column.Encoding;
import parquet.column.statistics.Statistics;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.HiddenFileFilter;
import parquet.io.ParquetDecodingException;
import parquet.schema.MessageType;

public class PrintFooter {
    private static Map<ColumnDescriptor, ColStats> stats = new LinkedHashMap<ColumnDescriptor, ColStats>();
    private static int blockCount = 0;
    private static long recordCount = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("usage PrintFooter <path>");
            return;
        }
        Path path = new Path(new URI(args[0]));
        final Configuration configuration = new Configuration();
        FileSystem fs = path.getFileSystem(configuration);
        FileStatus fileStatus = fs.getFileStatus(path);
        Path summary = new Path(fileStatus.getPath(), "_metadata");
        if (fileStatus.isDir() && fs.exists(summary)) {
            System.out.println("reading summary file");
            FileStatus summaryStatus = fs.getFileStatus(summary);
            List<Footer> readSummaryFile = ParquetFileReader.readSummaryFile(configuration, summaryStatus);
            for (Footer footer : readSummaryFile) {
                PrintFooter.add(footer.getParquetMetadata());
            }
        } else {
            List<Object> statuses;
            if (fileStatus.isDir()) {
                System.out.println("listing files in " + fileStatus.getPath());
                statuses = Arrays.asList(fs.listStatus(fileStatus.getPath(), (PathFilter)HiddenFileFilter.INSTANCE));
            } else {
                statuses = new ArrayList<FileStatus>();
                statuses.add(fileStatus);
            }
            System.out.println("opening " + statuses.size() + " files");
            int i = 0;
            ExecutorService threadPool = Executors.newFixedThreadPool(5);
            try {
                int j;
                long t0 = System.currentTimeMillis();
                LinkedBlockingDeque<Future> footers = new LinkedBlockingDeque<Future>();
                for (final FileStatus fileStatus2 : statuses) {
                    footers.add(threadPool.submit(new Callable<ParquetMetadata>(){

                        @Override
                        public ParquetMetadata call() throws Exception {
                            try {
                                ParquetMetadata footer = ParquetFileReader.readFooter(configuration, fileStatus2, ParquetMetadataConverter.NO_FILTER);
                                return footer;
                            }
                            catch (Exception e) {
                                throw new ParquetDecodingException("could not read footer", e);
                            }
                        }
                    }));
                }
                int previousPercent = 0;
                int n = 60;
                System.out.print("0% [");
                for (j = 0; j < n; ++j) {
                    System.out.print(" ");
                }
                System.out.print("] 100%");
                for (j = 0; j < n + 6; ++j) {
                    System.out.print('\b');
                }
                while (!footers.isEmpty()) {
                    Future futureFooter = (Future)footers.removeFirst();
                    if (!futureFooter.isDone()) {
                        footers.addLast(futureFooter);
                        continue;
                    }
                    ParquetMetadata footer = (ParquetMetadata)futureFooter.get();
                    int currentPercent = ++i * n / statuses.size();
                    while (currentPercent > previousPercent) {
                        System.out.print("*");
                        ++previousPercent;
                    }
                    PrintFooter.add(footer);
                }
                System.out.println("");
                long t1 = System.currentTimeMillis();
                System.out.println("read all footers in " + (t1 - t0) + " ms");
            }
            finally {
                threadPool.shutdownNow();
            }
        }
        Set<Map.Entry<ColumnDescriptor, ColStats>> entries = stats.entrySet();
        long total = 0L;
        long totalUnc = 0L;
        for (Map.Entry<ColumnDescriptor, ColStats> entry : entries) {
            ColStats colStats = entry.getValue();
            total += colStats.allStats.total;
            totalUnc += colStats.uncStats.total;
        }
        for (Map.Entry<ColumnDescriptor, ColStats> entry : entries) {
            ColStats colStats = entry.getValue();
            System.out.println(entry.getKey() + " " + PrintFooter.percent(colStats.allStats.total, total) + "% of all space " + colStats);
        }
        System.out.println("number of blocks: " + blockCount);
        System.out.println("total data size: " + PrintFooter.humanReadable(total) + " (raw " + PrintFooter.humanReadable(totalUnc) + ")");
        System.out.println("total record: " + PrintFooter.humanReadable(recordCount));
        System.out.println("average block size: " + PrintFooter.humanReadable(total / (long)blockCount) + " (raw " + PrintFooter.humanReadable(totalUnc / (long)blockCount) + ")");
        System.out.println("average record count: " + PrintFooter.humanReadable(recordCount / (long)blockCount));
    }

    private static void add(ParquetMetadata footer) {
        for (BlockMetaData blockMetaData : footer.getBlocks()) {
            ++blockCount;
            MessageType schema = footer.getFileMetaData().getSchema();
            recordCount += blockMetaData.getRowCount();
            List<ColumnChunkMetaData> columns = blockMetaData.getColumns();
            for (ColumnChunkMetaData columnMetaData : columns) {
                ColumnDescriptor desc = schema.getColumnDescription(columnMetaData.getPath().toArray());
                PrintFooter.add(desc, columnMetaData.getValueCount(), columnMetaData.getTotalSize(), columnMetaData.getTotalUncompressedSize(), columnMetaData.getEncodings(), columnMetaData.getStatistics());
            }
        }
    }

    private static void printTotalString(String message, long total, long totalUnc) {
        System.out.println("total " + message + ": " + PrintFooter.humanReadable(total) + " (raw " + PrintFooter.humanReadable(totalUnc) + " saved " + PrintFooter.percentComp(totalUnc, total) + "%)");
    }

    private static float percentComp(long raw, long compressed) {
        return PrintFooter.percent(raw - compressed, raw);
    }

    private static float percent(long numerator, long denominator) {
        return (float)(numerator * 1000L / denominator) / 10.0f;
    }

    private static String humanReadable(long size) {
        if (size < 1000L) {
            return String.valueOf(size);
        }
        long currentSize = size;
        long previousSize = size * 1000L;
        int count = 0;
        String[] unit = new String[]{"", "K", "M", "G", "T", "P"};
        while (currentSize >= 1000L) {
            previousSize = currentSize;
            currentSize /= 1000L;
            ++count;
        }
        return (float)previousSize / 1000.0f + unit[count];
    }

    private static void add(ColumnDescriptor desc, long valueCount, long size, long uncSize, Collection<Encoding> encodings, Statistics colValuesStats) {
        ColStats colStats = stats.get(desc);
        if (colStats == null) {
            colStats = new ColStats();
            stats.put(desc, colStats);
        }
        colStats.add(valueCount, size, uncSize, encodings, colValuesStats);
    }

    private static class ColStats {
        Stats valueCountStats = new Stats();
        Stats allStats = new Stats();
        Stats uncStats = new Stats();
        Set<Encoding> encodings = new TreeSet<Encoding>();
        Statistics colValuesStats = null;
        int blocks = 0;

        private ColStats() {
        }

        public void add(long valueCount, long size, long uncSize, Collection<Encoding> encodings, Statistics colValuesStats) {
            ++this.blocks;
            this.valueCountStats.add(valueCount);
            this.allStats.add(size);
            this.uncStats.add(uncSize);
            this.encodings.addAll(encodings);
            this.colValuesStats = colValuesStats;
        }

        public String toString() {
            long raw = this.uncStats.total;
            long compressed = this.allStats.total;
            return this.encodings + " " + this.allStats.toString(this.blocks) + " (raw data: " + PrintFooter.humanReadable(raw) + (raw == 0L ? "" : " saving " + (raw - compressed) * 100L / raw + "%") + ")\n" + "  values: " + this.valueCountStats.toString(this.blocks) + "\n" + "  uncompressed: " + this.uncStats.toString(this.blocks) + "\n" + "  column values statistics: " + this.colValuesStats.toString();
        }
    }

    private static class Stats {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        long total = 0L;

        private Stats() {
        }

        public void add(long length) {
            this.min = Math.min(length, this.min);
            this.max = Math.max(length, this.max);
            this.total += length;
        }

        public String toString(int blocks) {
            return "min: " + PrintFooter.humanReadable(this.min) + " max: " + PrintFooter.humanReadable(this.max) + " average: " + PrintFooter.humanReadable(this.total / (long)blocks) + " total: " + PrintFooter.humanReadable(this.total);
        }
    }
}

