/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.predicate;

import parquet.common.schema.ColumnPath;
import parquet.filter2.predicate.FilterPredicate;
import parquet.filter2.predicate.Operators;
import parquet.filter2.predicate.UserDefinedPredicate;

public final class FilterApi {
    private FilterApi() {
    }

    public static Operators.IntColumn intColumn(String columnPath) {
        return new Operators.IntColumn(ColumnPath.fromDotString(columnPath));
    }

    public static Operators.LongColumn longColumn(String columnPath) {
        return new Operators.LongColumn(ColumnPath.fromDotString(columnPath));
    }

    public static Operators.FloatColumn floatColumn(String columnPath) {
        return new Operators.FloatColumn(ColumnPath.fromDotString(columnPath));
    }

    public static Operators.DoubleColumn doubleColumn(String columnPath) {
        return new Operators.DoubleColumn(ColumnPath.fromDotString(columnPath));
    }

    public static Operators.BooleanColumn booleanColumn(String columnPath) {
        return new Operators.BooleanColumn(ColumnPath.fromDotString(columnPath));
    }

    public static Operators.BinaryColumn binaryColumn(String columnPath) {
        return new Operators.BinaryColumn(ColumnPath.fromDotString(columnPath));
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.Eq<T> eq(C column, T value) {
        return new Operators.Eq<T>(column, value);
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.NotEq<T> notEq(C column, T value) {
        return new Operators.NotEq<T>(column, value);
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.Lt<T> lt(C column, T value) {
        return new Operators.Lt<T>(column, value);
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.LtEq<T> ltEq(C column, T value) {
        return new Operators.LtEq<T>(column, value);
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.Gt<T> gt(C column, T value) {
        return new Operators.Gt<T>(column, value);
    }

    public static <T extends Comparable<T>, C extends Operators.Column<T>> Operators.GtEq<T> gtEq(C column, T value) {
        return new Operators.GtEq<T>(column, value);
    }

    public static <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Operators.UserDefined<T, U> userDefined(Operators.Column<T> column, Class<U> clazz) {
        return new Operators.UserDefinedByClass<T, U>(column, clazz);
    }

    public static <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Operators.UserDefined<T, U> userDefined(Operators.Column<T> column, U udp) {
        return new Operators.UserDefinedByInstance<T, U>(column, udp);
    }

    public static FilterPredicate and(FilterPredicate left, FilterPredicate right) {
        return new Operators.And(left, right);
    }

    public static FilterPredicate or(FilterPredicate left, FilterPredicate right) {
        return new Operators.Or(left, right);
    }

    public static FilterPredicate not(FilterPredicate predicate) {
        return new Operators.Not(predicate);
    }
}

