/*
 * Decompiled with CFR 0.152.
 */
package parquet.org.codehaus.jackson.map.jsontype.impl;

import java.io.IOException;
import parquet.org.codehaus.jackson.JsonParser;
import parquet.org.codehaus.jackson.JsonProcessingException;
import parquet.org.codehaus.jackson.JsonToken;
import parquet.org.codehaus.jackson.annotate.JsonTypeInfo;
import parquet.org.codehaus.jackson.map.BeanProperty;
import parquet.org.codehaus.jackson.map.DeserializationContext;
import parquet.org.codehaus.jackson.map.JsonDeserializer;
import parquet.org.codehaus.jackson.map.jsontype.TypeIdResolver;
import parquet.org.codehaus.jackson.map.jsontype.impl.AsArrayTypeDeserializer;
import parquet.org.codehaus.jackson.type.JavaType;
import parquet.org.codehaus.jackson.util.JsonParserSequence;
import parquet.org.codehaus.jackson.util.TokenBuffer;

public class AsPropertyTypeDeserializer
extends AsArrayTypeDeserializer {
    protected final String _typePropertyName;

    public AsPropertyTypeDeserializer(JavaType bt, TypeIdResolver idRes, BeanProperty property, String typePropName) {
        super(bt, idRes, property);
        this._typePropertyName = typePropName;
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.PROPERTY;
    }

    public String getPropertyName() {
        return this._typePropertyName;
    }

    public Object deserializeTypedFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        } else if (t != JsonToken.FIELD_NAME) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "need JSON Object to contain As.PROPERTY type information (for class " + this.baseTypeName() + ")");
        }
        TokenBuffer tb = null;
        while (t == JsonToken.FIELD_NAME) {
            String name = jp.getCurrentName();
            jp.nextToken();
            if (this._typePropertyName.equals(name)) {
                String typeId = jp.getText();
                JsonDeserializer<Object> deser = this._findDeserializer(ctxt, typeId);
                if (tb != null) {
                    jp = JsonParserSequence.createFlattened(tb.asParser(jp), jp);
                }
                jp.nextToken();
                return deser.deserialize(jp, ctxt);
            }
            if (tb == null) {
                tb = new TokenBuffer(null);
            }
            tb.writeFieldName(name);
            tb.copyCurrentStructure(jp);
            t = jp.nextToken();
        }
        throw ctxt.wrongTokenException(jp, JsonToken.FIELD_NAME, "missing property '" + this._typePropertyName + "' that is to contain type id  (for class " + this.baseTypeName() + ")");
    }

    public Object deserializeTypedFromAny(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
            return super.deserializeTypedFromArray(jp, ctxt);
        }
        return this.deserializeTypedFromObject(jp, ctxt);
    }
}

