/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Append
extends Mutation {
    private static final String RETURN_RESULTS = "_rr_";

    public void setReturnResults(boolean returnResults) {
        this.setAttribute(RETURN_RESULTS, Bytes.toBytes((boolean)returnResults));
    }

    public boolean isReturnResults() {
        byte[] v = this.getAttribute(RETURN_RESULTS);
        return v == null ? true : Bytes.toBoolean((byte[])v);
    }

    public Append(byte[] row) {
        this(row, 0, row.length);
    }

    public Append(Append a) {
        this.row = a.getRow();
        this.ts = a.getTimeStamp();
        this.familyMap.putAll(a.getFamilyCellMap());
        for (Map.Entry<String, byte[]> entry : a.getAttributesMap().entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public Append(byte[] rowArray, int rowOffset, int rowLength) {
        Append.checkRow(rowArray, rowOffset, rowLength);
        this.row = Bytes.copy((byte[])rowArray, (int)rowOffset, (int)rowLength);
    }

    public Append add(byte[] family, byte[] qualifier, byte[] value) {
        KeyValue kv = new KeyValue(this.row, family, qualifier, this.ts, KeyValue.Type.Put, value);
        return this.add((Cell)kv);
    }

    public Append add(Cell cell) {
        byte[] family = CellUtil.cloneFamily((Cell)cell);
        ArrayList<Cell> list = (ArrayList<Cell>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<Cell>();
        }
        list.add(cell);
        this.familyMap.put(family, list);
        return this;
    }
}

