/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.Registry;
import org.apache.hadoop.hbase.client.ZooKeeperKeepAliveConnection;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKTableStateClientSideReader;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;

class ZooKeeperRegistry
implements Registry {
    static final Log LOG = LogFactory.getLog(ZooKeeperRegistry.class);
    ConnectionManager.HConnectionImplementation hci;
    private String clusterId = null;

    ZooKeeperRegistry() {
    }

    @Override
    public void init(Connection connection) {
        if (!(connection instanceof ConnectionManager.HConnectionImplementation)) {
            throw new RuntimeException("This registry depends on HConnectionImplementation");
        }
        this.hci = (ConnectionManager.HConnectionImplementation)connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionLocations getMetaRegionLocation() throws IOException {
        try (ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();){
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Looking up meta region location in ZK, connection=" + this));
            }
            ServerName servername = new MetaTableLocator().blockUntilAvailable(zkw, this.hci.rpcTimeout);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Looked up meta region location, connection=" + this + "; serverName=" + (servername == null ? "null" : servername)));
            }
            if (servername == null) {
                RegionLocations regionLocations = null;
                return regionLocations;
            }
            HRegionLocation loc = new HRegionLocation(HRegionInfo.FIRST_META_REGIONINFO, servername, 0L);
            RegionLocations regionLocations = new RegionLocations(loc);
            return regionLocations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClusterId() {
        if (this.clusterId != null) {
            return this.clusterId;
        }
        try (ZooKeeperKeepAliveConnection zkw = null;){
            zkw = this.hci.getKeepAliveZooKeeperWatcher();
            this.clusterId = ZKClusterId.readClusterIdZNode(zkw);
            if (this.clusterId == null) {
                LOG.info((Object)"ClusterId read in ZooKeeper is null");
            }
        }
        return this.clusterId;
    }

    @Override
    public boolean isTableOnlineState(TableName tableName, boolean enabled) throws IOException {
        try (ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();){
            if (enabled) {
                boolean bl = ZKTableStateClientSideReader.isEnabledTable(zkw, tableName);
                return bl;
            }
            boolean bl = ZKTableStateClientSideReader.isDisabledTable(zkw, tableName);
            return bl;
        }
    }

    @Override
    public int getCurrentNrHRS() throws IOException {
        try (ZooKeeperKeepAliveConnection zkw = this.hci.getKeepAliveZooKeeperWatcher();){
            int n = ZKUtil.getNumberOfChildren(zkw, zkw.rsZNode);
            return n;
        }
    }
}

