/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStorageLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.VolumeId;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.BlockStorageLocationUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.web.HftpFileSystem;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestDistributedFileSystem {
    private static final Random RAN = new Random();
    private boolean dualPortTesting;
    private boolean noXmlDefaults;

    public TestDistributedFileSystem() {
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.ALL);
        this.dualPortTesting = false;
        this.noXmlDefaults = false;
    }

    private HdfsConfiguration getTestConfiguration() {
        HdfsConfiguration conf;
        if (this.noXmlDefaults) {
            conf = new HdfsConfiguration(false);
            String namenodeDir = new File(MiniDFSCluster.getBaseDirectory(), "name").getAbsolutePath();
            conf.set("dfs.namenode.name.dir", namenodeDir);
            conf.set("dfs.namenode.edits.dir", namenodeDir);
        } else {
            conf = new HdfsConfiguration();
        }
        if (this.dualPortTesting) {
            conf.set("dfs.namenode.servicerpc-address", "localhost:0");
        }
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 0L);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyDelegationToken() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            fileSys.getDelegationToken("");
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileSystemCloseAll() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).build();
        URI address = FileSystem.getDefaultUri((Configuration)conf);
        try {
            FileSystem.closeAll();
            conf = this.getTestConfiguration();
            FileSystem.setDefaultUri((Configuration)conf, (URI)address);
            FileSystem.get((Configuration)conf);
            FileSystem.get((Configuration)conf);
            FileSystem.closeAll();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSClose() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            fileSys.create(new Path("/test/dfsclose/file-0"));
            fileSys.create(new Path("/test/dfsclose/file-1"));
            Path p = new Path("/non-empty-file");
            DFSTestUtil.createFile((FileSystem)fileSys, p, 1L, (short)1, 0L);
            DFSTestUtil.readFile((FileSystem)fileSys, p);
            fileSys.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testDFSCloseOrdering() throws Exception {
        MyDistributedFileSystem fs = new MyDistributedFileSystem();
        Path path = new Path("/a");
        fs.deleteOnExit(path);
        fs.close();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{fs.dfs});
        ((DFSClient)inOrder.verify((Object)fs.dfs)).closeOutputStreams(Matchers.eq((boolean)false));
        ((DFSClient)inOrder.verify((Object)fs.dfs)).delete((String)Matchers.eq((Object)path.toString()), Matchers.eq((boolean)true));
        ((DFSClient)inOrder.verify((Object)fs.dfs)).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSSeekExceptions() throws IOException {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            String file = "/test/fileclosethenseek/file-0";
            Path path = new Path(file);
            FSDataOutputStream output = fileSys.create(path);
            output.writeBytes("Some test data to write longer than 10 bytes");
            output.close();
            FSDataInputStream input = fileSys.open(path);
            input.seek(10L);
            boolean threw = false;
            try {
                input.seek(100L);
            }
            catch (IOException e) {
                threw = true;
            }
            Assert.assertTrue((String)"Failed to throw IOE when seeking past end", (boolean)threw);
            input.close();
            threw = false;
            try {
                input.seek(1L);
            }
            catch (IOException e) {
                threw = true;
            }
            Assert.assertTrue((String)"Failed to throw IOE when seeking after close", (boolean)threw);
            fileSys.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSClient() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        long grace = 1000L;
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            String filepathstring = "/test/LeaseChecker/foo";
            Path[] filepaths = new Path[4];
            for (int i = 0; i < filepaths.length; ++i) {
                filepaths[i] = new Path("/test/LeaseChecker/foo" + i);
            }
            long millis = Time.now();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.dfs.getLeaseRenewer().setGraceSleepPeriod(1000L);
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            FSDataOutputStream out = dfs.create(filepaths[0]);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out.writeLong(millis);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out.close();
            Thread.sleep(750L);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            for (int i = 0; i < 3; ++i) {
                if (!dfs.dfs.getLeaseRenewer().isRunning()) continue;
                Thread.sleep(500L);
            }
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            FSDataOutputStream out1 = dfs.create(filepaths[1]);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            FSDataOutputStream out2 = dfs.create(filepaths[2]);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out1.writeLong(millis);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out1.close();
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out2.writeLong(millis);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out2.close();
            Thread.sleep(750L);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            FSDataOutputStream out3 = dfs.create(filepaths[3]);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            Thread.sleep(750L);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out3.writeLong(millis);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            out3.close();
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            Thread.sleep(750L);
            Assert.assertTrue((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            for (int i = 0; i < 3; ++i) {
                if (!dfs.dfs.getLeaseRenewer().isRunning()) continue;
                Thread.sleep(500L);
            }
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            dfs.close();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path("/wrwelkj");
            Assert.assertFalse((String)"File should not exist for test.", (boolean)fs.exists(dir));
            try {
                FSDataInputStream in = fs.open(dir);
                try {
                    in.close();
                    fs.close();
                }
                finally {
                    Assert.assertTrue((String)"Did not get a FileNotFoundException for non-existing file.", (boolean)false);
                }
            }
            catch (FileNotFoundException fnf) {
                // empty catch block
            }
            dfs = cluster.getFileSystem();
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            FSDataInputStream in = dfs.open(filepaths[0]);
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            Assert.assertEquals((long)millis, (long)in.readLong());
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            in.close();
            Assert.assertFalse((boolean)dfs.dfs.getLeaseRenewer().isRunning());
            dfs.close();
            String uri = "hdfs://127.0.0.1:" + cluster.getNameNodePort() + "/test/ipAddress/file";
            Path path = new Path(uri);
            FileSystem fs2 = FileSystem.get((URI)path.toUri(), (Configuration)conf);
            FSDataOutputStream out4 = fs2.create(path);
            byte[] buf = new byte[1024];
            out4.write(buf);
            out4.close();
            FSDataInputStream in2 = fs2.open(path);
            in2.readFully(buf);
            in2.close();
            fs2.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStatistics() throws Exception {
        int lsLimit = 2;
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setInt("dfs.ls.limit", lsLimit);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path("/test");
            Path file = new Path(dir, "file");
            int readOps = DFSTestUtil.getStatistics((FileSystem)fs).getReadOps();
            int writeOps = DFSTestUtil.getStatistics((FileSystem)fs).getWriteOps();
            int largeReadOps = DFSTestUtil.getStatistics((FileSystem)fs).getLargeReadOps();
            fs.mkdirs(dir);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            FSDataOutputStream out = fs.create(file, (short)1);
            out.close();
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            FileStatus status = fs.getFileStatus(file);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            fs.getFileBlockLocations(file, 0L, 0L);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            fs.getFileBlockLocations(status, 0L, 0L);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            FSDataInputStream in = fs.open(file);
            in.close();
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            fs.setReplication(file, (short)2);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            Path file1 = new Path(dir, "file1");
            fs.rename(file, file1);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            fs.getContentSummary(file1);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            for (int i = 0; i < 10; ++i) {
                Path p = new Path(dir, Integer.toString(i));
                fs.mkdirs(p);
                FileStatus[] list = fs.listStatus(dir);
                if (list.length > lsLimit) {
                    int iterations = (int)Math.ceil((double)list.length / (double)lsLimit);
                    largeReadOps += iterations;
                    readOps += iterations;
                } else {
                    ++readOps;
                }
                this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            }
            fs.getStatus(file1);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            fs.getFileChecksum(file1);
            this.checkStatistics((FileSystem)fs, ++readOps, writeOps, largeReadOps);
            fs.setPermission(file1, new FsPermission(511));
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            fs.setTimes(file1, 0L, 0L);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            fs.setOwner(file1, ugi.getUserName(), ugi.getGroupNames()[0]);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
            fs.delete(dir, true);
            this.checkStatistics((FileSystem)fs, readOps, ++writeOps, largeReadOps);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void checkStatistics(FileSystem fs, int readOps, int writeOps, int largeReadOps) {
        Assert.assertEquals((long)readOps, (long)DFSTestUtil.getStatistics(fs).getReadOps());
        Assert.assertEquals((long)writeOps, (long)DFSTestUtil.getStatistics(fs).getWriteOps());
        Assert.assertEquals((long)largeReadOps, (long)DFSTestUtil.getStatistics(fs).getLargeReadOps());
    }

    @Test
    public void testFileChecksum() throws Exception {
        ((Log4JLogger)HftpFileSystem.LOG).getLogger().setLevel(Level.ALL);
        long seed = RAN.nextLong();
        System.out.println("seed=" + seed);
        RAN.setSeed(seed);
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("dfs.webhdfs.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem hdfs = cluster.getFileSystem();
        String nnAddr = conf.get("dfs.namenode.http-address");
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)(current.getShortUserName() + "x"), (String[])new String[]{"user"});
        try {
            hdfs.getFileChecksum(new Path("/test/TestNonExistingFile"));
            Assert.fail((String)"Expecting FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((String)"Not throwing the intended exception message", (boolean)e.getMessage().contains("File does not exist: /test/TestNonExistingFile"));
        }
        try {
            Path path = new Path("/test/TestExistingDir/");
            hdfs.mkdirs(path);
            hdfs.getFileChecksum(path);
            Assert.fail((String)"Expecting FileNotFoundException");
        }
        catch (FileNotFoundException e) {
            Assert.assertTrue((String)"Not throwing the intended exception message", (boolean)e.getMessage().contains("Path is not a file: /test/TestExistingDir"));
        }
        final String hftpuri = "hftp://" + nnAddr;
        System.out.println("hftpuri=" + hftpuri);
        FileSystem hftp = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>((Configuration)conf){
            final /* synthetic */ Configuration val$conf;
            {
                this.val$conf = configuration;
            }

            @Override
            public FileSystem run() throws Exception {
                return new Path(hftpuri).getFileSystem(this.val$conf);
            }
        });
        final String webhdfsuri = "webhdfs://" + nnAddr;
        System.out.println("webhdfsuri=" + webhdfsuri);
        FileSystem webhdfs = (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>((Configuration)conf){
            final /* synthetic */ Configuration val$conf;
            {
                this.val$conf = configuration;
            }

            @Override
            public FileSystem run() throws Exception {
                return new Path(webhdfsuri).getFileSystem(this.val$conf);
            }
        });
        Path dir = new Path("/filechecksum");
        int block_size = 1024;
        int buffer_size = conf.getInt("io.file.buffer.size", 4096);
        conf.setInt("dfs.bytes-per-checksum", 512);
        for (int n = 0; n < 5; ++n) {
            byte[] data = new byte[RAN.nextInt(511) + n * 1024 + 1];
            RAN.nextBytes(data);
            System.out.println("data.length=" + data.length);
            Path foo = new Path(dir, "foo" + n);
            FSDataOutputStream out = hdfs.create(foo, false, buffer_size, (short)2, 1024L);
            out.write(data);
            out.close();
            FileChecksum hdfsfoocs = hdfs.getFileChecksum(foo);
            System.out.println("hdfsfoocs=" + hdfsfoocs);
            FileChecksum hftpfoocs = hftp.getFileChecksum(foo);
            System.out.println("hftpfoocs=" + hftpfoocs);
            Path qualified = new Path(hftpuri + dir, "foo" + n);
            FileChecksum qfoocs = hftp.getFileChecksum(qualified);
            System.out.println("qfoocs=" + qfoocs);
            FileChecksum webhdfsfoocs = webhdfs.getFileChecksum(foo);
            System.out.println("webhdfsfoocs=" + webhdfsfoocs);
            Path webhdfsqualified = new Path(webhdfsuri + dir, "foo" + n);
            FileChecksum webhdfs_qfoocs = webhdfs.getFileChecksum(webhdfsqualified);
            System.out.println("webhdfs_qfoocs=" + webhdfs_qfoocs);
            Path zeroByteFile = new Path(dir, "zeroByteFile" + n);
            FSDataOutputStream out2 = hdfs.create(zeroByteFile, false, buffer_size, (short)2, 1024L);
            out2.close();
            FileChecksum zeroChecksum = hdfs.getFileChecksum(zeroByteFile);
            Assert.assertEquals((Object)zeroChecksum.toString(), (Object)"MD5-of-0MD5-of-0CRC32:70bc8f4b72a86921468bf8e8441dce51");
            Path bar = new Path(dir, "bar" + n);
            FSDataOutputStream out3 = hdfs.create(bar, false, buffer_size, (short)2, 1024L);
            out3.write(data);
            out3.close();
            FileChecksum barcs = hdfs.getFileChecksum(bar);
            int barhashcode = barcs.hashCode();
            Assert.assertEquals((long)hdfsfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)hdfsfoocs, (Object)barcs);
            Assert.assertEquals((long)hftpfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)hftpfoocs, (Object)barcs);
            Assert.assertEquals((long)qfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)qfoocs, (Object)barcs);
            Assert.assertEquals((long)webhdfsfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)webhdfsfoocs, (Object)barcs);
            Assert.assertEquals((long)webhdfs_qfoocs.hashCode(), (long)barhashcode);
            Assert.assertEquals((Object)webhdfs_qfoocs, (Object)barcs);
            hdfs.setPermission(dir, new FsPermission(0));
            try {
                hftp.getFileChecksum(qualified);
                Assert.fail();
            }
            catch (IOException ioe) {
                FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
            }
            try {
                webhdfs.getFileChecksum(webhdfsqualified);
                Assert.fail();
            }
            catch (IOException ioe) {
                FileSystem.LOG.info((Object)"GOOD: getting an exception", (Throwable)ioe);
            }
            hdfs.setPermission(dir, new FsPermission(511));
        }
        cluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllWithDualPort() throws Exception {
        this.dualPortTesting = true;
        try {
            this.testFileSystemCloseAll();
            this.testDFSClose();
            this.testDFSClient();
            this.testFileChecksum();
        }
        finally {
            this.dualPortTesting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllWithNoXmlDefaults() throws Exception {
        this.noXmlDefaults = true;
        try {
            this.testFileSystemCloseAll();
            this.testDFSClose();
            this.testDFSClient();
            this.testFileChecksum();
        }
        finally {
            this.noXmlDefaults = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testGetFileBlockStorageLocationsBatching() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        ((Log4JLogger)ProtobufRpcEngine.LOG).getLogger().setLevel(Level.TRACE);
        ((Log4JLogger)BlockStorageLocationUtil.LOG).getLogger().setLevel(Level.TRACE);
        ((Log4JLogger)DFSClient.LOG).getLogger().setLevel(Level.TRACE);
        conf.setBoolean("dfs.datanode.hdfs-blocks-metadata.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            String name;
            VolumeId id;
            int i;
            final DistributedFileSystem fs = cluster.getFileSystem();
            final Path tmpFile1 = new Path("/tmpfile1.dat");
            final Path tmpFile2 = new Path("/tmpfile2.dat");
            DFSTestUtil.createFile((FileSystem)fs, tmpFile1, 1024L, (short)2, 0xDEADDEADL);
            DFSTestUtil.createFile((FileSystem)fs, tmpFile2, 1024L, (short)2, 0xDEADDEADL);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        ArrayList list = Lists.newArrayList();
                        list.addAll(Arrays.asList(fs.getFileBlockLocations(tmpFile1, 0L, 1024L)));
                        list.addAll(Arrays.asList(fs.getFileBlockLocations(tmpFile2, 0L, 1024L)));
                        int totalRepl = 0;
                        for (BlockLocation loc : list) {
                            totalRepl += loc.getHosts().length;
                        }
                        if (totalRepl == 4) {
                            return true;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return false;
                }
            }, (int)500, (int)30000);
            Object[] blockLocs1 = fs.getFileBlockLocations(tmpFile1, 0L, 1024L);
            Object[] blockLocs2 = fs.getFileBlockLocations(tmpFile2, 0L, 1024L);
            BlockLocation[] blockLocs = (BlockLocation[])ArrayUtils.addAll((Object[])blockLocs1, (Object[])blockLocs2);
            BlockStorageLocation[] locs = fs.getFileBlockStorageLocations(Arrays.asList(blockLocs));
            int counter = 0;
            for (BlockStorageLocation l : locs) {
                for (i = 0; i < l.getVolumeIds().length; ++i) {
                    id = l.getVolumeIds()[i];
                    name = l.getNames()[i];
                    if (id == null) continue;
                    System.out.println("Datanode " + name + " has block " + counter + " on volume id " + id.toString());
                }
                ++counter;
            }
            Assert.assertEquals((String)"Expected two HdfsBlockLocations for two 1-block files", (long)2L, (long)locs.length);
            for (BlockStorageLocation l : locs) {
                Assert.assertEquals((String)"Expected two replicas for each block", (long)2L, (long)l.getVolumeIds().length);
                for (i = 0; i < l.getVolumeIds().length; ++i) {
                    id = l.getVolumeIds()[i];
                    name = l.getNames()[i];
                    Assert.assertTrue((String)("Expected block to be valid on datanode " + name), (id != null ? 1 : 0) != 0);
                }
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testGetFileBlockStorageLocationsError() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        conf.setBoolean("dfs.datanode.hdfs-blocks-metadata.enabled", true);
        conf.setInt("dfs.client.file-block-storage-locations.timeout.millis", 1500);
        conf.setInt("ipc.client.connect.max.retries", 0);
        MiniDFSCluster cluster = null;
        try {
            BlockStorageLocation[] locs;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
            cluster.getDataNodes();
            final DistributedFileSystem fs = cluster.getFileSystem();
            final Path tmpFile1 = new Path("/errorfile1.dat");
            final Path tmpFile2 = new Path("/errorfile2.dat");
            DFSTestUtil.createFile((FileSystem)fs, tmpFile1, 1024L, (short)2, 0xDEADDEADL);
            DFSTestUtil.createFile((FileSystem)fs, tmpFile2, 1024L, (short)2, 0xDEADDEADL);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    try {
                        ArrayList list = Lists.newArrayList();
                        list.addAll(Arrays.asList(fs.getFileBlockLocations(tmpFile1, 0L, 1024L)));
                        list.addAll(Arrays.asList(fs.getFileBlockLocations(tmpFile2, 0L, 1024L)));
                        int totalRepl = 0;
                        for (BlockLocation loc : list) {
                            totalRepl += loc.getHosts().length;
                        }
                        if (totalRepl == 4) {
                            return true;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return false;
                }
            }, (int)500, (int)30000);
            BlockLocation[] blockLocs1 = fs.getFileBlockLocations(tmpFile1, 0L, 1024L);
            BlockLocation[] blockLocs2 = fs.getFileBlockLocations(tmpFile2, 0L, 1024L);
            ArrayList allLocs = Lists.newArrayList();
            allLocs.addAll(Arrays.asList(blockLocs1));
            allLocs.addAll(Arrays.asList(blockLocs2));
            DataNodeFaultInjector injector = (DataNodeFaultInjector)Mockito.mock(DataNodeFaultInjector.class);
            ((DataNodeFaultInjector)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    Thread.sleep(3000L);
                    return null;
                }
            }).when((Object)injector)).getHdfsBlocksMetadata();
            DataNodeFaultInjector.instance = injector;
            for (BlockStorageLocation loc : locs = fs.getFileBlockStorageLocations((List)allLocs)) {
                Assert.assertEquals((String)"Found more than 0 cached hosts although RPCs supposedly timed out", (long)0L, (long)loc.getCachedHosts().length);
            }
            DataNodeFaultInjector.instance = new DataNodeFaultInjector();
            MiniDFSCluster.DataNodeProperties stoppedNode = cluster.stopDataNode(0);
            locs = fs.getFileBlockStorageLocations((List)allLocs);
            Assert.assertEquals((String)"Expected two HdfsBlockLocation for two 1-block files", (long)2L, (long)locs.length);
            for (BlockStorageLocation l : locs) {
                Assert.assertEquals((String)"Expected two replicas for each block", (long)2L, (long)l.getHosts().length);
                Assert.assertEquals((String)"Expected two VolumeIDs for each block", (long)2L, (long)l.getVolumeIds().length);
                Assert.assertTrue((String)"Expected one valid and one invalid volume", (boolean)(l.getVolumeIds()[0] == null ^ l.getVolumeIds()[1] == null));
            }
            cluster.restartDataNode(stoppedNode, true);
            cluster.waitActive();
            fs.delete(tmpFile2, true);
            HATestUtil.waitForNNToIssueDeletions(cluster.getNameNode());
            cluster.triggerHeartbeats();
            HATestUtil.waitForDNDeletions(cluster);
            locs = fs.getFileBlockStorageLocations((List)allLocs);
            Assert.assertEquals((String)"Expected two HdfsBlockLocations for two 1-block files", (long)2L, (long)locs.length);
            Assert.assertNotNull((Object)locs[0].getVolumeIds()[0]);
            Assert.assertNotNull((Object)locs[0].getVolumeIds()[1]);
            Assert.assertNull((Object)locs[1].getVolumeIds()[0]);
            Assert.assertNull((Object)locs[1].getVolumeIds()[1]);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateWithCustomChecksum() throws Exception {
        HdfsConfiguration conf = this.getTestConfiguration();
        MiniDFSCluster cluster = null;
        Path testBasePath = new Path("/test/csum");
        Path path1 = new Path(testBasePath, "file_wtih_crc1");
        Path path2 = new Path(testBasePath, "file_with_crc2");
        Options.ChecksumOpt opt1 = new Options.ChecksumOpt(DataChecksum.Type.CRC32C, 512);
        Options.ChecksumOpt opt2 = new Options.ChecksumOpt(DataChecksum.Type.CRC32, 512);
        FsPermission perm = FsPermission.getDefault().applyUMask(FsPermission.getUMask((Configuration)conf));
        EnumSet<CreateFlag> flags = EnumSet.of(CreateFlag.OVERWRITE, CreateFlag.CREATE);
        short repl = 1;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(testBasePath);
            FSDataOutputStream out1 = dfs.create(path1, perm, flags, 4096, repl, 131072L, null, opt1);
            FSDataOutputStream out2 = dfs.create(path2, perm, flags, 4096, repl, 131072L, null, opt2);
            for (int i = 0; i < 1024; ++i) {
                out1.write(i);
                out2.write(i);
            }
            out1.close();
            out2.close();
            MD5MD5CRC32FileChecksum sum1 = (MD5MD5CRC32FileChecksum)dfs.getFileChecksum(path1);
            MD5MD5CRC32FileChecksum sum2 = (MD5MD5CRC32FileChecksum)dfs.getFileChecksum(path2);
            Assert.assertFalse((boolean)sum1.equals((Object)sum2));
            Assert.assertEquals((Object)DataChecksum.Type.CRC32C, (Object)sum1.getCrcType());
            Assert.assertEquals((Object)DataChecksum.Type.CRC32, (Object)sum2.getCrcType());
        }
        finally {
            if (cluster != null) {
                cluster.getFileSystem().delete(testBasePath, true);
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testFileCloseStatus() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            Path file = new Path("/simpleFlush.dat");
            FSDataOutputStream output = fs.create(file);
            output.writeBytes("Some test data");
            output.flush();
            Assert.assertFalse((String)"File status should be open", (boolean)fs.isFileClosed(file));
            output.close();
            Assert.assertTrue((String)"File status should be closed", (boolean)fs.isFileClosed(file));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testListFiles() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path relative = new Path("relative");
            fs.create(new Path(relative, "foo")).close();
            ArrayList<Object> retVal = new ArrayList<Object>();
            RemoteIterator iter = fs.listFiles(relative, true);
            while (iter.hasNext()) {
                retVal.add(iter.next());
            }
            System.out.println("retVal = " + retVal);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testDFSClientPeerTimeout() throws IOException {
        int timeout = 1000;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.client.socket-timeout", 1000);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            ServerSocket socket = new ServerSocket(0);
            Peer peer = dfs.getClient().newConnectedPeer((InetSocketAddress)socket.getLocalSocketAddress(), null, null);
            long start = Time.now();
            try {
                peer.getInputStream().read();
                Assert.fail((String)"should timeout");
            }
            catch (SocketTimeoutException ste) {
                long delta = Time.now() - start;
                Assert.assertTrue((String)"timedout too soon", ((double)delta >= 900.0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"timedout too late", ((double)delta <= 1100.0 ? 1 : 0) != 0);
            }
            catch (Throwable t) {
                Assert.fail((String)("wrong exception:" + t));
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    private static class MyDistributedFileSystem
    extends DistributedFileSystem {
        MyDistributedFileSystem() {
            this.statistics = new FileSystem.Statistics("myhdfs");
            this.dfs = (DFSClient)Mockito.mock(DFSClient.class);
        }

        public boolean exists(Path p) {
            return true;
        }
    }
}

