/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.protocol.InterDatanodeProtocol;
import org.apache.hadoop.io.IOUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;

public class TestFileCreationClient {
    static final String DIR = "/" + TestFileCreationClient.class.getSimpleName() + "/";

    public TestFileCreationClient() {
        ((Log4JLogger)DataNode.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LeaseManager.LOG).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)LogFactory.getLog(FSNamesystem.class)).getLogger().setLevel(Level.ALL);
        ((Log4JLogger)InterDatanodeProtocol.LOG).getLogger().setLevel(Level.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientTriggeredLeaseRecovery() throws Exception {
        int REPLICATION = 3;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.datanode.handler.count", 1);
        conf.setInt("dfs.replication", 3);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        try {
            int i;
            DistributedFileSystem fs = cluster.getFileSystem();
            Path dir = new Path("/wrwelkj");
            SlowWriter[] slowwriters = new SlowWriter[10];
            for (i = 0; i < slowwriters.length; ++i) {
                slowwriters[i] = new SlowWriter((FileSystem)fs, new Path(dir, "file" + i));
            }
            try {
                for (i = 0; i < slowwriters.length; ++i) {
                    slowwriters[i].start();
                }
                Thread.sleep(1000L);
                cluster.stopDataNode(AppendTestUtil.nextInt(3));
                System.out.println("Wait a few seconds");
                Thread.sleep(5000L);
            }
            catch (Throwable throwable) {
                int i2;
                for (i2 = 0; i2 < slowwriters.length; ++i2) {
                    if (slowwriters[i2] == null) continue;
                    slowwriters[i2].running = false;
                    slowwriters[i2].interrupt();
                }
                for (i2 = 0; i2 < slowwriters.length; ++i2) {
                    if (slowwriters[i2] == null) continue;
                    slowwriters[i2].join();
                }
                throw throwable;
            }
            for (i = 0; i < slowwriters.length; ++i) {
                if (slowwriters[i] == null) continue;
                slowwriters[i].running = false;
                slowwriters[i].interrupt();
            }
            for (i = 0; i < slowwriters.length; ++i) {
                if (slowwriters[i] == null) continue;
                slowwriters[i].join();
            }
            System.out.println("Verify the file");
            for (i = 0; i < slowwriters.length; ++i) {
                System.out.println(slowwriters[i].filepath + ": length=" + fs.getFileStatus(slowwriters[i].filepath).getLen());
                FSDataInputStream in = null;
                try {
                    int x;
                    in = fs.open(slowwriters[i].filepath);
                    int j = 0;
                    while ((x = in.read()) != -1) {
                        Assert.assertEquals((long)j, (long)x);
                        ++j;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(in);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)in);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    static class SlowWriter
    extends Thread {
        final FileSystem fs;
        final Path filepath;
        boolean running = true;

        SlowWriter(FileSystem fs, Path filepath) {
            super(SlowWriter.class.getSimpleName() + ":" + filepath);
            this.fs = fs;
            this.filepath = filepath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FSDataOutputStream out = null;
            int i = 0;
            try {
                out = this.fs.create(this.filepath);
                while (this.running) {
                    System.out.println(this.getName() + " writes " + i);
                    out.write(i);
                    out.hflush();
                    SlowWriter.sleep(100L);
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println(this.getName() + " dies: e=" + e);
            }
            finally {
                System.out.println(this.getName() + ": i=" + i);
                IOUtils.closeStream((Closeable)out);
            }
        }
    }
}

