/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.qjournal.QJMTestUtil;
import org.apache.hadoop.hdfs.qjournal.protocol.JournalOutOfSyncException;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.hdfs.qjournal.protocol.RequestInfo;
import org.apache.hadoop.hdfs.qjournal.server.Journal;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageErrorReporter;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestJournal {
    private static final NamespaceInfo FAKE_NSINFO = new NamespaceInfo(12345, "mycluster", "my-bp", 0L);
    private static final NamespaceInfo FAKE_NSINFO_2 = new NamespaceInfo(6789, "mycluster", "my-bp", 0L);
    private static final String JID = "test-journal";
    private static final File TEST_LOG_DIR = new File(new File(MiniDFSCluster.getBaseDirectory()), "TestJournal");
    private final StorageErrorReporter mockErrorReporter = (StorageErrorReporter)Mockito.mock(StorageErrorReporter.class);
    private Configuration conf;
    private Journal journal;

    @Before
    public void setup() throws Exception {
        FileUtil.fullyDelete((File)TEST_LOG_DIR);
        this.conf = new Configuration();
        this.journal = new Journal(this.conf, TEST_LOG_DIR, JID, HdfsServerConstants.StartupOption.REGULAR, this.mockErrorReporter);
        this.journal.format(FAKE_NSINFO);
    }

    @After
    public void verifyNoStorageErrors() throws Exception {
        ((StorageErrorReporter)Mockito.verify((Object)this.mockErrorReporter, (VerificationMode)Mockito.never())).reportErrorOnFile((File)Mockito.any());
    }

    @After
    public void cleanup() {
        IOUtils.closeStream((Closeable)this.journal);
    }

    @Test
    public void testScanEditLog() throws Exception {
        this.journal.startLogSegment(TestJournal.makeRI(1), 1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION - 1);
        int numTxns = 5;
        byte[] ops = QJMTestUtil.createGabageTxns(1L, 5);
        this.journal.journal(TestJournal.makeRI(2), 1L, 1L, 5, ops);
        QJournalProtocolProtos.SegmentStateProto segmentState = this.journal.getSegmentInfo(1L);
        Assert.assertTrue((boolean)segmentState.getIsInProgress());
        Assert.assertEquals((long)5L, (long)segmentState.getEndTxId());
        Assert.assertEquals((long)1L, (long)segmentState.getStartTxId());
        this.journal.finalizeLogSegment(TestJournal.makeRI(3), 1L, 5L);
        segmentState = this.journal.getSegmentInfo(1L);
        Assert.assertFalse((boolean)segmentState.getIsInProgress());
        Assert.assertEquals((long)5L, (long)segmentState.getEndTxId());
        Assert.assertEquals((long)1L, (long)segmentState.getStartTxId());
    }

    @Test(timeout=10000L)
    public void testEpochHandling() throws Exception {
        Assert.assertEquals((long)0L, (long)this.journal.getLastPromisedEpoch());
        QJournalProtocolProtos.NewEpochResponseProto newEpoch = this.journal.newEpoch(FAKE_NSINFO, 1L);
        Assert.assertFalse((boolean)newEpoch.hasLastSegmentTxId());
        Assert.assertEquals((long)1L, (long)this.journal.getLastPromisedEpoch());
        this.journal.newEpoch(FAKE_NSINFO, 3L);
        Assert.assertFalse((boolean)newEpoch.hasLastSegmentTxId());
        Assert.assertEquals((long)3L, (long)this.journal.getLastPromisedEpoch());
        try {
            this.journal.newEpoch(FAKE_NSINFO, 3L);
            Assert.fail((String)"Should have failed to promise same epoch twice");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Proposed epoch 3 <= last promise 3", (Throwable)ioe);
        }
        try {
            this.journal.startLogSegment(TestJournal.makeRI(1), 12345L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            Assert.fail((String)"Should have rejected call from prior epoch");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"epoch 1 is less than the last promised epoch 3", (Throwable)ioe);
        }
        try {
            this.journal.journal(TestJournal.makeRI(1), 12345L, 100L, 0, new byte[0]);
            Assert.fail((String)"Should have rejected call from prior epoch");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"epoch 1 is less than the last promised epoch 3", (Throwable)ioe);
        }
    }

    @Test(timeout=10000L)
    public void testMaintainCommittedTxId() throws Exception {
        this.journal.newEpoch(FAKE_NSINFO, 1L);
        this.journal.startLogSegment(TestJournal.makeRI(1), 1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        this.journal.journal(new RequestInfo(JID, 1L, 2L, 0L), 1L, 1L, 3, QJMTestUtil.createTxnData(1, 3));
        Assert.assertEquals((long)0L, (long)this.journal.getCommittedTxnIdForTests());
        this.journal.journal(new RequestInfo(JID, 1L, 3L, 3L), 1L, 4L, 3, QJMTestUtil.createTxnData(4, 6));
        Assert.assertEquals((long)3L, (long)this.journal.getCommittedTxnIdForTests());
    }

    @Test(timeout=10000L)
    public void testRestartJournal() throws Exception {
        this.journal.newEpoch(FAKE_NSINFO, 1L);
        this.journal.startLogSegment(TestJournal.makeRI(1), 1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        this.journal.journal(TestJournal.makeRI(2), 1L, 1L, 2, QJMTestUtil.createTxnData(1, 2));
        String storageString = this.journal.getStorage().toColonSeparatedString();
        System.err.println("storage string: " + storageString);
        this.journal.close();
        this.journal = new Journal(this.conf, TEST_LOG_DIR, JID, HdfsServerConstants.StartupOption.REGULAR, this.mockErrorReporter);
        Assert.assertEquals((Object)storageString, (Object)this.journal.getStorage().toColonSeparatedString());
        Assert.assertEquals((long)1L, (long)this.journal.getLastPromisedEpoch());
        QJournalProtocolProtos.NewEpochResponseProto newEpoch = this.journal.newEpoch(FAKE_NSINFO, 2L);
        Assert.assertEquals((long)1L, (long)newEpoch.getLastSegmentTxId());
    }

    @Test(timeout=10000L)
    public void testFormatResetsCachedValues() throws Exception {
        this.journal.newEpoch(FAKE_NSINFO, 12345L);
        this.journal.startLogSegment(new RequestInfo(JID, 12345L, 1L, 0L), 1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        Assert.assertEquals((long)12345L, (long)this.journal.getLastPromisedEpoch());
        Assert.assertEquals((long)12345L, (long)this.journal.getLastWriterEpoch());
        Assert.assertTrue((boolean)this.journal.isFormatted());
        this.journal.close();
        this.journal.format(FAKE_NSINFO_2);
        Assert.assertEquals((long)0L, (long)this.journal.getLastPromisedEpoch());
        Assert.assertEquals((long)0L, (long)this.journal.getLastWriterEpoch());
        Assert.assertTrue((boolean)this.journal.isFormatted());
    }

    @Test(timeout=10000L)
    public void testNewEpochAtBeginningOfSegment() throws Exception {
        this.journal.newEpoch(FAKE_NSINFO, 1L);
        this.journal.startLogSegment(TestJournal.makeRI(1), 1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        this.journal.journal(TestJournal.makeRI(2), 1L, 1L, 2, QJMTestUtil.createTxnData(1, 2));
        this.journal.finalizeLogSegment(TestJournal.makeRI(3), 1L, 2L);
        this.journal.startLogSegment(TestJournal.makeRI(4), 3L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        QJournalProtocolProtos.NewEpochResponseProto resp = this.journal.newEpoch(FAKE_NSINFO, 2L);
        Assert.assertEquals((long)1L, (long)resp.getLastSegmentTxId());
    }

    @Test(timeout=10000L)
    public void testJournalLocking() throws Exception {
        Assume.assumeTrue((boolean)this.journal.getStorage().getStorageDir(0).isLockSupported());
        Storage.StorageDirectory sd = this.journal.getStorage().getStorageDir(0);
        File lockFile = new File(sd.getRoot(), "in_use.lock");
        GenericTestUtils.assertExists((File)lockFile);
        this.journal.newEpoch(FAKE_NSINFO, 1L);
        try {
            new Journal(this.conf, TEST_LOG_DIR, JID, HdfsServerConstants.StartupOption.REGULAR, this.mockErrorReporter);
            Assert.fail((String)"Did not fail to create another journal in same dir");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Cannot lock storage", (Throwable)ioe);
        }
        this.journal.close();
        Journal journal2 = new Journal(this.conf, TEST_LOG_DIR, JID, HdfsServerConstants.StartupOption.REGULAR, this.mockErrorReporter);
        journal2.newEpoch(FAKE_NSINFO, 2L);
        journal2.close();
    }

    @Test(timeout=10000L)
    public void testFinalizeWhenEditsAreMissed() throws Exception {
        this.journal.newEpoch(FAKE_NSINFO, 1L);
        this.journal.startLogSegment(TestJournal.makeRI(1), 1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        this.journal.journal(TestJournal.makeRI(2), 1L, 1L, 3, QJMTestUtil.createTxnData(1, 3));
        try {
            this.journal.finalizeLogSegment(TestJournal.makeRI(3), 1L, 6L);
            Assert.fail((String)"did not fail to finalize");
        }
        catch (JournalOutOfSyncException e) {
            GenericTestUtils.assertExceptionContains((String)"but only written up to txid 3", (Throwable)e);
        }
        this.journal.close();
        this.journal = new Journal(this.conf, TEST_LOG_DIR, JID, HdfsServerConstants.StartupOption.REGULAR, this.mockErrorReporter);
        try {
            this.journal.finalizeLogSegment(TestJournal.makeRI(4), 1L, 6L);
            Assert.fail((String)"did not fail to finalize");
        }
        catch (JournalOutOfSyncException e) {
            GenericTestUtils.assertExceptionContains((String)"disk only contains up to txid 3", (Throwable)e);
        }
    }

    @Test(timeout=10000L)
    public void testFinalizeMissingSegment() throws Exception {
        this.journal.newEpoch(FAKE_NSINFO, 1L);
        try {
            this.journal.finalizeLogSegment(TestJournal.makeRI(1), 1000L, 1001L);
            Assert.fail((String)"did not fail to finalize");
        }
        catch (JournalOutOfSyncException e) {
            GenericTestUtils.assertExceptionContains((String)"No log file to finalize at transaction ID 1000", (Throwable)e);
        }
    }

    @Test(timeout=10000L)
    public void testAbortOldSegmentIfFinalizeIsMissed() throws Exception {
        this.journal.newEpoch(FAKE_NSINFO, 1L);
        this.journal.startLogSegment(TestJournal.makeRI(1), 1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        this.journal.journal(TestJournal.makeRI(2), 1L, 1L, 3, QJMTestUtil.createTxnData(1, 3));
        GenericTestUtils.assertExists((File)this.journal.getStorage().getInProgressEditLog(1L));
        this.journal.startLogSegment(TestJournal.makeRI(3), 6L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        this.journal.journal(TestJournal.makeRI(4), 6L, 6L, 3, QJMTestUtil.createTxnData(6, 3));
        GenericTestUtils.assertExists((File)this.journal.getStorage().getInProgressEditLog(1L));
        GenericTestUtils.assertExists((File)this.journal.getStorage().getInProgressEditLog(6L));
    }

    @Test(timeout=10000L)
    public void testStartLogSegmentWhenAlreadyExists() throws Exception {
        this.journal.newEpoch(FAKE_NSINFO, 1L);
        this.journal.startLogSegment(TestJournal.makeRI(1), 1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        this.journal.journal(TestJournal.makeRI(2), 1L, 1L, 1, QJMTestUtil.createTxnData(1, 1));
        this.journal.startLogSegment(TestJournal.makeRI(3), 1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        this.journal.journal(TestJournal.makeRI(4), 1L, 1L, 1, QJMTestUtil.createTxnData(1, 1));
        this.journal.journal(TestJournal.makeRI(5), 1L, 2L, 3, QJMTestUtil.createTxnData(2, 3));
        try {
            this.journal.startLogSegment(TestJournal.makeRI(6), 1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            Assert.fail((String)"Did not fail to start log segment which would overwrite an existing one");
        }
        catch (IllegalStateException ise) {
            GenericTestUtils.assertExceptionContains((String)"seems to contain valid transactions", (Throwable)ise);
        }
        this.journal.finalizeLogSegment(TestJournal.makeRI(7), 1L, 4L);
        try {
            this.journal.startLogSegment(TestJournal.makeRI(8), 1L, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            Assert.fail((String)"Did not fail to start log segment which would overwrite an existing one");
        }
        catch (IllegalStateException ise) {
            GenericTestUtils.assertExceptionContains((String)"have a finalized segment", (Throwable)ise);
        }
    }

    private static RequestInfo makeRI(int serial) {
        return new RequestInfo(JID, 1L, (long)serial, 0L);
    }

    @Test(timeout=10000L)
    public void testNamespaceVerification() throws Exception {
        this.journal.newEpoch(FAKE_NSINFO, 1L);
        try {
            this.journal.newEpoch(FAKE_NSINFO_2, 2L);
            Assert.fail((String)"Did not fail newEpoch() when namespaces mismatched");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Incompatible namespaceID", (Throwable)ioe);
        }
    }
}

