/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.TestDNFencing;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class TestRBWBlockInvalidation {
    private static final Log LOG = LogFactory.getLog(TestRBWBlockInvalidation.class);

    private static NumberReplicas countReplicas(FSNamesystem namesystem, ExtendedBlock block) {
        return namesystem.getBlockManager().countNodes(block.getLocalBlock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testBlockInvalidationWhenRBWReplicaMissedInDN() throws IOException, InterruptedException {
        Assume.assumeTrue((!Path.WINDOWS ? 1 : 0) != 0);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.replication", 2);
        conf.setLong("dfs.blockreport.intervalMsec", 300L);
        conf.setLong("dfs.datanode.directoryscan.interval", 1L);
        conf.setLong("dfs.heartbeat.interval", 1L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        FSDataOutputStream out = null;
        try {
            FSNamesystem namesystem = cluster.getNamesystem();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testPath = new Path("/tmp/TestRBWBlockInvalidation", "foo1");
            out = fs.create(testPath, (short)2);
            out.writeBytes("HDFS-3157: " + testPath);
            out.hsync();
            cluster.startDataNodes((Configuration)conf, 1, true, null, null, null);
            String bpid = namesystem.getBlockPoolId();
            ExtendedBlock blk = DFSTestUtil.getFirstBlock((FileSystem)fs, testPath);
            Block block = blk.getLocalBlock();
            DataNode dn = cluster.getDataNodes().get(0);
            File blockFile = DataNodeTestUtils.getBlockFile(dn, bpid, block);
            File metaFile = DataNodeTestUtils.getMetaFile(dn, bpid, block);
            Assert.assertTrue((String)"Could not delete the block file from the RBW folder", (boolean)blockFile.delete());
            Assert.assertTrue((String)"Could not delete the block meta file from the RBW folder", (boolean)metaFile.delete());
            out.close();
            int liveReplicas = 0;
            while (true) {
                if ((liveReplicas = TestRBWBlockInvalidation.countReplicas(namesystem, blk).liveReplicas()) < 2) break;
                Thread.sleep(100L);
            }
            LOG.info((Object)("Live Replicas after corruption: " + liveReplicas));
            Assert.assertEquals((String)"There should be less than 2 replicas in the liveReplicasMap", (long)1L, (long)liveReplicas);
            while (true) {
                if ((liveReplicas = TestRBWBlockInvalidation.countReplicas(namesystem, blk).liveReplicas()) > 1) break;
                Thread.sleep(100L);
            }
            LOG.info((Object)("Live Replicas after Rereplication: " + liveReplicas));
            Assert.assertEquals((String)"There should be two live replicas", (long)2L, (long)liveReplicas);
            do {
                Thread.sleep(100L);
            } while (TestRBWBlockInvalidation.countReplicas(namesystem, blk).corruptReplicas() != 0);
            LOG.info((Object)"Corrupt Replicas becomes 0");
        }
        finally {
            if (out != null) {
                out.close();
            }
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testRWRInvalidation() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setClass("dfs.block.replicator.classname", TestDNFencing.RandomDeleterPolicy.class, BlockPlacementPolicy.class);
        conf.setInt("dfs.heartbeat.interval", 1);
        ArrayList testPaths = Lists.newArrayList();
        for (int i = 0; i < 10; ++i) {
            testPaths.add(new Path("/test" + i));
        }
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            ArrayList streams = Lists.newArrayList();
            try {
                for (Path path : testPaths) {
                    FSDataOutputStream out = cluster.getFileSystem().create(path, (short)2);
                    streams.add(out);
                    out.writeBytes("old gs data\n");
                    out.hflush();
                }
                MiniDFSCluster.DataNodeProperties oldGenstampNode = cluster.stopDataNode(0);
                for (int i = 0; i < streams.size(); ++i) {
                    Path path = (Path)testPaths.get(i);
                    FSDataOutputStream out = (FSDataOutputStream)streams.get(i);
                    out.writeBytes("new gs data\n");
                    out.hflush();
                    cluster.getFileSystem().setReplication(path, (short)1);
                    out.close();
                }
                LOG.info((Object)"=========================== restarting cluster");
                MiniDFSCluster.DataNodeProperties otherNode = cluster.stopDataNode(0);
                cluster.restartNameNode(new String[0]);
                cluster.restartDataNode(oldGenstampNode);
                cluster.waitActive();
                cluster.restartDataNode(otherNode);
                cluster.waitActive();
                cluster.getNameNode().getNamesystem().getBlockManager().computeInvalidateWork(2);
                cluster.triggerHeartbeats();
                HATestUtil.waitForDNDeletions(cluster);
                cluster.triggerDeletionReports();
                for (Path path : testPaths) {
                    String ret = DFSTestUtil.readFile((FileSystem)cluster.getFileSystem(), path);
                    Assert.assertEquals((Object)"old gs data\nnew gs data\n", (Object)ret);
                }
            }
            finally {
                IOUtils.cleanup((Log)LOG, (Closeable[])streams.toArray(new Closeable[0]));
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

