/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;

public class FsDatasetTestUtil {
    public static File getFile(FsDatasetSpi<?> fsd, String bpid, long bid) {
        return ((FsDatasetImpl)fsd).getFile(bpid, bid, false);
    }

    public static File getBlockFile(FsDatasetSpi<?> fsd, String bpid, Block b) throws IOException {
        return ((FsDatasetImpl)fsd).getBlockFile(bpid, b.getBlockId());
    }

    public static File getMetaFile(FsDatasetSpi<?> fsd, String bpid, Block b) throws IOException {
        return FsDatasetUtil.getMetaFile((File)FsDatasetTestUtil.getBlockFile(fsd, bpid, b), (long)b.getGenerationStamp());
    }

    public static boolean unlinkBlock(FsDatasetSpi<?> fsd, ExtendedBlock block, int numLinks) throws IOException {
        ReplicaInfo info = ((FsDatasetImpl)fsd).getReplicaInfo(block);
        return info.unlinkBlock(numLinks);
    }

    public static ReplicaInfo fetchReplicaInfo(FsDatasetSpi<?> fsd, String bpid, long blockId) {
        return ((FsDatasetImpl)fsd).fetchReplicaInfo(bpid, blockId);
    }

    public static long getPendingAsyncDeletions(FsDatasetSpi<?> fsd) {
        return ((FsDatasetImpl)fsd).asyncDiskService.countPendingDeletions();
    }

    public static Collection<ReplicaInfo> getReplicas(FsDatasetSpi<?> fsd, String bpid) {
        return ((FsDatasetImpl)fsd).volumeMap.replicas(bpid);
    }

    public static void stopLazyWriter(DataNode dn) {
        FsDatasetImpl fsDataset = (FsDatasetImpl)dn.getFSDataset();
        ((FsDatasetImpl.LazyWriter)fsDataset.lazyWriter.getRunnable()).stop();
    }
}

