/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.schema.naming;

import org.datanucleus.NucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.store.schema.naming.AbstractNamingFactory;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.naming.SchemaComponent;

public class DN2NamingFactory
extends AbstractNamingFactory {
    public DN2NamingFactory(NucleusContext nucCtx) {
        super(nucCtx);
    }

    @Override
    public String getTableName(AbstractMemberMetaData mmd) {
        int maxLength;
        String name = null;
        AbstractMemberMetaData[] relatedMmds = null;
        if (mmd.hasContainer()) {
            if (mmd.getTable() != null) {
                name = mmd.getTable();
            } else {
                relatedMmds = mmd.getRelatedMemberMetaData(this.clr);
                if (relatedMmds != null && relatedMmds[0].getTable() != null) {
                    name = relatedMmds[0].getTable();
                }
            }
        }
        if (name == null) {
            String ownerClass = mmd.getClassName(false);
            name = ownerClass + this.wordSeparator + mmd.getName();
        }
        if ((maxLength = this.getMaximumLengthForComponent(SchemaComponent.TABLE)) > 0 && name.length() > maxLength) {
            name = DN2NamingFactory.truncate(name, maxLength);
        }
        name = this.getNameInRequiredCase(name);
        return name;
    }

    @Override
    public String getColumnName(AbstractClassMetaData cmd, ColumnType type) {
        String name = null;
        if (type == ColumnType.DISCRIMINATOR_COLUMN) {
            name = cmd.getDiscriminatorColumnName();
            if (name == null) {
                name = "DISCRIMINATOR";
            }
        } else if (type == ColumnType.VERSION_COLUMN) {
            ColumnMetaData colmd;
            VersionMetaData vermd = cmd.getVersionMetaData();
            if (vermd != null && (colmd = vermd.getColumnMetaData()) != null && colmd.getName() != null) {
                name = colmd.getName();
            }
            if (name == null) {
                name = "VERSION";
            }
        } else if (type == ColumnType.DATASTOREID_COLUMN) {
            ColumnMetaData idcolmds;
            if (cmd.getIdentityMetaData() != null && (idcolmds = cmd.getIdentityMetaData().getColumnMetaData()) != null) {
                name = idcolmds.getName();
            }
            if (name == null) {
                name = cmd.getName() + this.wordSeparator + "ID";
            }
        } else if (type == ColumnType.MULTITENANCY_COLUMN) {
            if (cmd.hasExtension("multitenancy-column-name")) {
                name = cmd.getValueForExtension("multitenancy-column-name");
            }
            if (name == null) {
                name = "TENANT" + this.wordSeparator + "ID";
            }
        } else {
            throw new NucleusException("This method does not support columns of type " + (Object)((Object)type));
        }
        return this.prepareColumnNameForUse(name);
    }

    @Override
    public String getColumnName(AbstractMemberMetaData mmd, ColumnType type, int position) {
        String name = null;
        if (type == ColumnType.COLUMN) {
            ColumnMetaData[] colmds = mmd.getColumnMetaData();
            if (colmds != null && colmds.length > position) {
                name = colmds[position].getName();
            }
            if (name == null) {
                name = mmd.getName();
            }
        } else if (type == ColumnType.INDEX_COLUMN) {
            ColumnMetaData[] colmds;
            if (mmd.getOrderMetaData() != null && (colmds = mmd.getOrderMetaData().getColumnMetaData()) != null && colmds.length > position) {
                name = colmds[position].getName();
            }
            if (name == null) {
                name = "IDX";
            }
        } else if (type == ColumnType.ADAPTER_COLUMN) {
            name = "IDX";
        } else {
            if (type == ColumnType.FK_COLUMN) {
                throw new NucleusException("This method does not support columns of type " + (Object)((Object)type));
            }
            if (type == ColumnType.JOIN_OWNER_COLUMN) {
                ColumnMetaData[] colmds;
                if (mmd.hasContainer() && mmd.getJoinMetaData() != null && (colmds = mmd.getJoinMetaData().getColumnMetaData()) != null && colmds.length > position) {
                    name = colmds[position].getName();
                }
                if (name == null && mmd.hasContainer()) {
                    name = mmd.getName() + this.wordSeparator + "ID_OID";
                }
            } else {
                throw new NucleusException("This method does not support columns of type " + (Object)((Object)type));
            }
        }
        return this.prepareColumnNameForUse(name);
    }
}

