/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch;

import com.google.common.base.Preconditions;

public class CachingOptions {
    private final boolean useDisk;
    private final boolean useMemory;
    private final boolean deserialized;
    private final int replicas;
    public static final CachingOptions DEFAULT = CachingOptions.builder().build();

    private CachingOptions(boolean useDisk, boolean useMemory, boolean deserialized, int replicas) {
        this.useDisk = useDisk;
        this.useMemory = useMemory;
        this.deserialized = deserialized;
        this.replicas = replicas;
    }

    public boolean useDisk() {
        return this.useDisk;
    }

    public boolean useMemory() {
        return this.useMemory;
    }

    public boolean deserialized() {
        return this.deserialized;
    }

    public int replicas() {
        return this.replicas;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean useDisk = false;
        private boolean useMemory = true;
        private boolean deserialized = true;
        private int replicas = 1;

        public Builder useMemory(boolean useMemory) {
            this.useMemory = useMemory;
            return this;
        }

        public Builder useDisk(boolean useDisk) {
            this.useDisk = useDisk;
            return this;
        }

        public Builder deserialized(boolean deserialized) {
            this.deserialized = deserialized;
            return this;
        }

        public Builder replicas(int replicas) {
            Preconditions.checkArgument((replicas > 0 ? 1 : 0) != 0);
            this.replicas = replicas;
            return this;
        }

        public CachingOptions build() {
            return new CachingOptions(this.useDisk, this.useMemory, this.deserialized, this.replicas);
        }
    }
}

