/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch;

import java.io.Serializable;
import org.apache.crunch.Emitter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public abstract class DoFn<S, T>
implements Serializable {
    private transient TaskInputOutputContext<?, ?, ?, ?> context;
    private transient Configuration conf;

    public void configure(Configuration conf) {
    }

    public void initialize() {
    }

    public abstract void process(S var1, Emitter<T> var2);

    public void cleanup(Emitter<T> emitter) {
    }

    public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
        this.context = context;
    }

    public void setConfiguration(Configuration conf) {
        this.conf = conf;
    }

    public float scaleFactor() {
        return 0.99f;
    }

    public boolean disableDeepCopy() {
        return false;
    }

    protected TaskInputOutputContext<?, ?, ?, ?> getContext() {
        return this.context;
    }

    protected Configuration getConfiguration() {
        if (this.conf != null) {
            return this.conf;
        }
        if (this.context != null) {
            return this.context.getConfiguration();
        }
        return null;
    }

    @Deprecated
    protected Counter getCounter(Enum<?> counterName) {
        return this.context.getCounter(counterName);
    }

    @Deprecated
    protected Counter getCounter(String groupName, String counterName) {
        return this.context.getCounter(groupName, counterName);
    }

    protected void increment(String groupName, String counterName) {
        this.increment(groupName, counterName, 1L);
    }

    protected void increment(String groupName, String counterName, long value) {
        this.context.getCounter(groupName, counterName).increment(value);
    }

    protected void increment(Enum<?> counterName) {
        this.increment(counterName, 1L);
    }

    protected void increment(Enum<?> counterName, long value) {
        this.context.getCounter(counterName).increment(value);
    }

    protected void progress() {
        this.context.progress();
    }

    protected TaskAttemptID getTaskAttemptID() {
        return this.context.getTaskAttemptID();
    }

    protected void setStatus(String status) {
        this.context.setStatus(status);
    }

    protected String getStatus() {
        return this.context.getStatus();
    }
}

