/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.crunch.PipelineExecution;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;

public class PipelineResult {
    public static final PipelineResult EMPTY = new PipelineResult((List<StageResult>)ImmutableList.of(), PipelineExecution.Status.READY);
    public static final PipelineResult DONE = new PipelineResult((List<StageResult>)ImmutableList.of(), PipelineExecution.Status.SUCCEEDED);
    private final List<StageResult> stageResults;
    public PipelineExecution.Status status;

    public PipelineResult(List<StageResult> stageResults, PipelineExecution.Status status) {
        this.stageResults = ImmutableList.copyOf(stageResults);
        this.status = status;
    }

    public boolean succeeded() {
        return this.status == PipelineExecution.Status.SUCCEEDED;
    }

    public List<StageResult> getStageResults() {
        return this.stageResults;
    }

    public static class StageResult {
        private final String stageName;
        private final String stageId;
        private final Counters counters;
        private final long startTimeMsec;
        private final long jobStartTimeMsec;
        private final long jobEndTimeMsec;
        private final long endTimeMsec;

        public StageResult(String stageName, Counters counters) {
            this(stageName, counters, System.currentTimeMillis(), System.currentTimeMillis());
        }

        public StageResult(String stageName, Counters counters, long startTimeMsec, long endTimeMsec) {
            this(stageName, stageName, counters, startTimeMsec, startTimeMsec, endTimeMsec, endTimeMsec);
        }

        public StageResult(String stageName, String stageId, Counters counters, long startTimeMsec, long jobStartTimeMsec, long jobEndTimeMsec, long endTimeMsec) {
            this.stageName = stageName;
            this.stageId = stageId;
            this.counters = counters;
            this.startTimeMsec = startTimeMsec;
            this.jobStartTimeMsec = jobStartTimeMsec;
            this.jobEndTimeMsec = jobEndTimeMsec;
            this.endTimeMsec = endTimeMsec;
        }

        public String getStageName() {
            return this.stageName;
        }

        public String getStageId() {
            return this.stageId;
        }

        public long getStartTimeMsec() {
            return this.startTimeMsec;
        }

        public long getJobStartTimeMsec() {
            return this.jobStartTimeMsec;
        }

        public long getJobEndTimeMsec() {
            return this.jobEndTimeMsec;
        }

        public long getEndTimeMsec() {
            return this.endTimeMsec;
        }

        @Deprecated
        public Counters getCounters() {
            return this.counters;
        }

        public Map<String, Set<String>> getCounterNames() {
            if (this.counters == null) {
                return ImmutableMap.of();
            }
            HashMap names = Maps.newHashMap();
            for (CounterGroup counterGroup : this.counters) {
                HashSet counterNames = Sets.newHashSet();
                for (Counter counter : counterGroup) {
                    counterNames.add(counter.getName());
                }
                names.put(counterGroup.getName(), counterNames);
            }
            return names;
        }

        @Deprecated
        public Counter findCounter(Enum<?> key) {
            if (this.counters == null) {
                return null;
            }
            return this.counters.findCounter(key);
        }

        public long getCounterValue(String groupName, String counterName) {
            if (this.counters == null) {
                return 0L;
            }
            return this.counters.findCounter(groupName, counterName).getValue();
        }

        public String getCounterDisplayName(String groupName, String counterName) {
            if (this.counters == null) {
                return null;
            }
            return this.counters.findCounter(groupName, counterName).getDisplayName();
        }

        public long getCounterValue(Enum<?> key) {
            if (this.counters == null) {
                return 0L;
            }
            return this.counters.findCounter(key).getValue();
        }

        public String getCounterDisplayName(Enum<?> key) {
            if (this.counters == null) {
                return null;
            }
            return this.counters.findCounter(key).getDisplayName();
        }
    }
}

