/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch;

import java.util.Collection;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.crunch.MapFn;
import org.apache.crunch.Tuple;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;

public class Tuple3<V1, V2, V3>
implements Tuple {
    private final V1 first;
    private final V2 second;
    private final V3 third;

    public static <A, B, C> Tuple3<A, B, C> of(A a, B b, C c) {
        return new Tuple3<A, B, C>(a, b, c);
    }

    public Tuple3(V1 first, V2 second, V3 third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public V1 first() {
        return this.first;
    }

    public V2 second() {
        return this.second;
    }

    public V3 third() {
        return this.third;
    }

    @Override
    public Object get(int index) {
        switch (index) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
            case 2: {
                return this.third;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public int size() {
        return 3;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        return hcb.append(this.first).append(this.second).append(this.third).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple3 other = (Tuple3)obj;
        return (this.first == other.first || this.first != null && this.first.equals(other.first)) && (this.second == other.second || this.second != null && this.second.equals(other.second)) && (this.third == other.third || this.third != null && this.third.equals(other.third));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Tuple3[");
        sb.append(this.first).append(",").append(this.second).append(",").append(this.third);
        return sb.append("]").toString();
    }

    public static class Collect<V1, V2, V3>
    extends Tuple3<Collection<V1>, Collection<V2>, Collection<V3>> {
        public static <V1, V2, V3> PType<Collect<V1, V2, V3>> derived(PType<V1> first, PType<V2> second, PType<V3> third) {
            PTypeFamily tf = first.getFamily();
            PType<Tuple3<Collection<V1>, Collection<V2>, Collection<V3>>> pt = tf.triples(tf.collections(first), tf.collections(second), tf.collections(third));
            Class<Collect> clazz = Collect.class;
            return tf.derived(clazz, new MapFn<Tuple3<Collection<V1>, Collection<V2>, Collection<V3>>, Collect<V1, V2, V3>>(){

                @Override
                public Collect<V1, V2, V3> map(Tuple3<Collection<V1>, Collection<V2>, Collection<V3>> in) {
                    return new Collect(in.first(), in.second(), in.third());
                }
            }, new MapFn<Collect<V1, V2, V3>, Tuple3<Collection<V1>, Collection<V2>, Collection<V3>>>(){

                @Override
                public Tuple3<Collection<V1>, Collection<V2>, Collection<V3>> map(Collect<V1, V2, V3> in) {
                    return in;
                }
            }, pt);
        }

        public Collect(Collection<V1> first, Collection<V2> second, Collection<V3> third) {
            super(first, second, third);
        }
    }
}

