/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.fn;

import org.apache.crunch.Emitter;
import org.apache.crunch.MapFn;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class CompositeMapFn<R, S, T>
extends MapFn<R, T> {
    private final MapFn<R, S> first;
    private final MapFn<S, T> second;

    public CompositeMapFn(MapFn<R, S> first, MapFn<S, T> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this.first.setConfiguration(conf);
        this.second.setConfiguration(conf);
    }

    @Override
    public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
        this.first.setContext(context);
        this.second.setContext(context);
    }

    @Override
    public void initialize() {
        this.first.initialize();
        this.second.initialize();
    }

    public MapFn<R, S> getFirst() {
        return this.first;
    }

    public MapFn<S, T> getSecond() {
        return this.second;
    }

    @Override
    public T map(R input) {
        return this.second.map(this.first.map(input));
    }

    @Override
    public void cleanup(Emitter<T> emitter) {
        this.first.cleanup(null);
        this.second.cleanup(null);
    }

    @Override
    public void configure(Configuration conf) {
        this.first.configure(conf);
        this.second.configure(conf);
    }
}

