/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.hadoop.mapreduce.lib.jobcontrol;

import java.lang.reflect.Constructor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class TaskInputOutputContextFactory {
    private static final Log LOG = LogFactory.getLog(TaskInputOutputContextFactory.class);
    private static final TaskInputOutputContextFactory INSTANCE = new TaskInputOutputContextFactory();
    private Constructor<? extends TaskInputOutputContext> taskIOConstructor;
    private int arity;

    public static TaskInputOutputContext create(Configuration conf, TaskAttemptID taskAttemptId, StatusReporter reporter) {
        return INSTANCE.createInternal(conf, taskAttemptId, reporter);
    }

    private TaskInputOutputContextFactory() {
        String ic = TaskInputOutputContext.class.isInterface() ? "org.apache.hadoop.mapreduce.task.MapContextImpl" : "org.apache.hadoop.mapreduce.MapContext";
        try {
            Class<?> implClass = Class.forName(ic);
            this.taskIOConstructor = implClass.getConstructor(Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class);
            this.arity = 7;
        }
        catch (Exception e) {
            LOG.fatal((Object)"Could not access TaskInputOutputContext constructor, exiting", (Throwable)e);
        }
    }

    private TaskInputOutputContext createInternal(Configuration conf, TaskAttemptID taskAttemptId, StatusReporter reporter) {
        Object[] args = new Object[this.arity];
        args[0] = conf;
        args[1] = taskAttemptId;
        args[5] = reporter;
        try {
            return this.taskIOConstructor.newInstance(args);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not construct a TaskInputOutputContext instance", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

