/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.dist;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.MapFn;
import org.apache.crunch.PCollection;
import org.apache.crunch.PTable;
import org.apache.crunch.Pipeline;
import org.apache.crunch.PipelineResult;
import org.apache.crunch.Source;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.TableSource;
import org.apache.crunch.Target;
import org.apache.crunch.fn.IdentityFn;
import org.apache.crunch.impl.dist.collect.BaseGroupedTable;
import org.apache.crunch.impl.dist.collect.BaseInputCollection;
import org.apache.crunch.impl.dist.collect.BaseInputTable;
import org.apache.crunch.impl.dist.collect.BaseUnionCollection;
import org.apache.crunch.impl.dist.collect.BaseUnionTable;
import org.apache.crunch.impl.dist.collect.EmptyPCollection;
import org.apache.crunch.impl.dist.collect.EmptyPTable;
import org.apache.crunch.impl.dist.collect.PCollectionFactory;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.io.From;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.ReadableSourceTarget;
import org.apache.crunch.io.To;
import org.apache.crunch.materialize.MaterializableIterable;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.writable.Writables;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public abstract class DistributedPipeline
implements Pipeline {
    private static final Log LOG = LogFactory.getLog(DistributedPipeline.class);
    private static final Random RANDOM = new Random();
    private final String name;
    protected final PCollectionFactory factory;
    protected final Map<PCollectionImpl<?>, Set<Target>> outputTargets;
    protected final Map<PCollectionImpl<?>, MaterializableIterable<?>> outputTargetsToMaterialize;
    private Path tempDirectory;
    private int tempFileIndex;
    private int nextAnonymousStageId;
    private Configuration conf;

    public DistributedPipeline(String name, Configuration conf, PCollectionFactory factory) {
        this.name = name;
        this.factory = factory;
        this.outputTargets = Maps.newHashMap();
        this.outputTargetsToMaterialize = Maps.newHashMap();
        this.conf = conf;
        this.tempDirectory = DistributedPipeline.createTempDirectory(conf);
        this.tempFileIndex = 0;
        this.nextAnonymousStageId = 0;
    }

    public PCollectionFactory getFactory() {
        return this.factory;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this.conf = conf;
        this.tempDirectory = DistributedPipeline.createTempDirectory(conf);
    }

    @Override
    public PipelineResult done() {
        PipelineResult res = PipelineResult.DONE;
        if (!this.outputTargets.isEmpty()) {
            res = this.run();
        }
        this.cleanup();
        return res;
    }

    public <S> PCollection<S> read(Source<S> source) {
        return this.factory.createInputCollection(source, this);
    }

    @Override
    public <K, V> PTable<K, V> read(TableSource<K, V> source) {
        return this.factory.createInputTable(source, this);
    }

    @Override
    public PCollection<String> readTextFile(String pathName) {
        return this.read((Source)From.textFile(pathName));
    }

    @Override
    public void write(PCollection<?> pcollection, Target target) {
        this.write(pcollection, target, Target.WriteMode.DEFAULT);
    }

    @Override
    public void write(PCollection<?> pcollection, Target target, Target.WriteMode writeMode) {
        if (pcollection instanceof BaseGroupedTable) {
            pcollection = ((BaseGroupedTable)pcollection).ungroup();
        } else if (pcollection instanceof BaseUnionCollection || pcollection instanceof BaseUnionTable) {
            pcollection = pcollection.parallelDo("UnionCollectionWrapper", IdentityFn.getInstance(), pcollection.getPType());
        }
        boolean exists = target.handleExisting(writeMode, ((PCollectionImpl)pcollection).getLastModifiedAt(), this.getConfiguration());
        if (exists && writeMode == Target.WriteMode.CHECKPOINT) {
            SourceTarget<?> st = target.asSourceTarget(pcollection.getPType());
            if (st == null) {
                throw new CrunchRuntimeException("Target " + target + " does not support checkpointing");
            }
            ((PCollectionImpl)pcollection).materializeAt(st);
            return;
        }
        if (writeMode != Target.WriteMode.APPEND && this.targetInCurrentRun(target)) {
            throw new CrunchRuntimeException("Target " + target + " is already written in current run." + " Use WriteMode.APPEND in order to write additional data to it.");
        }
        this.addOutput((PCollectionImpl)pcollection, target);
    }

    private boolean targetInCurrentRun(Target target) {
        for (Set<Target> targets : this.outputTargets.values()) {
            if (!targets.contains(target)) continue;
            return true;
        }
        return false;
    }

    private void addOutput(PCollectionImpl<?> impl, Target target) {
        if (!this.outputTargets.containsKey(impl)) {
            this.outputTargets.put(impl, Sets.newHashSet());
        }
        this.outputTargets.get(impl).add(target);
    }

    public <S> PCollection<S> emptyPCollection(PType<S> ptype) {
        return new EmptyPCollection<S>(this, ptype);
    }

    @Override
    public <K, V> PTable<K, V> emptyPTable(PTableType<K, V> ptype) {
        return new EmptyPTable<K, V>(this, ptype);
    }

    public <T> ReadableSource<T> getMaterializeSourceTarget(PCollection<T> pcollection) {
        SourceTarget<T> st;
        PCollectionImpl<T> impl = this.toPCollectionImpl(pcollection);
        if (impl instanceof BaseInputCollection) {
            BaseInputCollection ic = (BaseInputCollection)impl;
            if (ic.getSource() instanceof ReadableSource) {
                return (ReadableSource)ic.getSource();
            }
            throw new IllegalArgumentException("Cannot materialize non-readable input collection: " + ic);
        }
        if (impl instanceof BaseInputTable) {
            BaseInputTable it = (BaseInputTable)impl;
            if (it.getSource() instanceof ReadableSource) {
                return (ReadableSource)((Object)it.getSource());
            }
            throw new IllegalArgumentException("Cannot materialize non-readable input table: " + it);
        }
        SourceTarget<T> matTarget = impl.getMaterializedAt();
        if (matTarget != null && matTarget instanceof ReadableSourceTarget) {
            return (ReadableSourceTarget)matTarget;
        }
        ReadableSourceTarget srcTarget = null;
        if (this.outputTargets.containsKey(pcollection)) {
            for (Target target : this.outputTargets.get(impl)) {
                if (!(target instanceof ReadableSourceTarget)) continue;
                return (ReadableSourceTarget)target;
            }
        }
        if (!((st = this.createIntermediateOutput(pcollection.getPType())) instanceof ReadableSourceTarget)) {
            throw new IllegalArgumentException("The PType for the given PCollection is not readable and cannot be materialized");
        }
        srcTarget = (ReadableSourceTarget)st;
        this.addOutput(impl, srcTarget);
        return srcTarget;
    }

    private <T> PCollectionImpl<T> toPCollectionImpl(PCollection<T> pcollection) {
        PCollectionImpl pcollectionImpl = null;
        pcollectionImpl = pcollection instanceof BaseUnionCollection || pcollection instanceof BaseUnionTable ? (PCollectionImpl)pcollection.parallelDo("UnionCollectionWrapper", IdentityFn.getInstance(), pcollection.getPType()) : (PCollectionImpl)pcollection;
        return pcollectionImpl;
    }

    public <T> SourceTarget<T> createIntermediateOutput(PType<T> ptype) {
        return ptype.getDefaultFileSource(this.createTempPath());
    }

    public Path createTempPath() {
        ++this.tempFileIndex;
        return new Path(this.tempDirectory, "p" + this.tempFileIndex);
    }

    private static Path createTempDirectory(Configuration conf) {
        Path dir = DistributedPipeline.createTemporaryPath(conf);
        try {
            dir.getFileSystem(conf).mkdirs(dir);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create job output directory " + dir, e);
        }
        return dir;
    }

    private static Path createTemporaryPath(Configuration conf) {
        String baseDir = conf.get("crunch.tmp.dir", "/tmp");
        return new Path(baseDir, "crunch-" + (RANDOM.nextInt() & Integer.MAX_VALUE));
    }

    @Override
    public <T> void writeTextFile(PCollection<T> pcollection, String pathName) {
        pcollection.parallelDo("asText", new StringifyFn(), Writables.strings()).write(To.textFile(pathName));
    }

    @Override
    public void cleanup(boolean force) {
        if (force || this.outputTargets.isEmpty()) {
            try {
                FileSystem fs = this.tempDirectory.getFileSystem(this.conf);
                if (fs.exists(this.tempDirectory)) {
                    fs.delete(this.tempDirectory, true);
                }
            }
            catch (IOException e) {
                LOG.info((Object)"Exception during cleanup", (Throwable)e);
            }
        } else {
            LOG.warn((Object)"Not running cleanup while output targets remain.");
        }
    }

    private void cleanup() {
        this.cleanup(false);
    }

    public int getNextAnonymousStageId() {
        return this.nextAnonymousStageId++;
    }

    @Override
    public void enableDebug() {
        this.getConfiguration().setBoolean("crunch.debug", true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private static class StringifyFn<T>
    extends MapFn<T, String> {
        private StringifyFn() {
        }

        @Override
        public String map(T input) {
            return input.toString();
        }
    }
}

